// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Serialize/Resource/hkResource.h>

_Ret_maybenull_ void* hkResource::getContentsPointer(_In_opt_z_ const char* typeName) const
{
    hkReflect::Var contents = getContents();
    if(contents.isValid())
    {
        if(!typeName || !hkString::strCmp(contents.getType()->getName(), typeName))
        {
            return contents.getAddress();
        }
    }
    return HK_NULL;
}

_Ret_maybenull_ void* hkResource::getContentsPointer(_In_opt_ const hkReflect::Type* type) const
{
    hkReflect::Var contents = getContents();
    if(contents.isValid())
    {
        if(!type || contents.isInstanceOf(type))
        {
            return contents.getAddress();
        }
    }
    return HK_NULL;
}

_Ret_z_ const char* hkResource::getContentsTypeName() const
{
    hkReflect::Var contents = getContents();
    return contents.getType()->getName();
}

_Ret_notnull_ const hkReflect::Type* hkResource::getContentsType() const
{
    hkReflect::Var contents = getContents();
    return contents.getType();
}

bool hkResource::getObjectName(_In_ const void* object, hkStringBuf& nameOut) const
{
    hkArray<Import> impOut;
    hkArray<Export> expOut;
    getImportsExports( impOut, expOut );
    for(int i=0; i < expOut.getSize(); i++)
    {
        if(expOut[i].m_location.getAddress() == object)
        {
            nameOut = expOut[i].m_name;
            return true;
        }
    }

    return false;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
