// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Serialize/Resource/hkResource.h>

    /// Abstract base class for resources which require cleanup.
class HK_EXPORT_COMMON hkObjectResource : public hkResource
{
    public:
        HK_DECLARE_CLASS(hkObjectResource, New, ReflectIdentity);
            /// Construct hkObjectResource from hkReflect::Var.
        hkObjectResource(const hkReflect::Var& v);

            /// Get the name of this resource.
        virtual _Ret_z_ const char* getName() const HK_OVERRIDE;

            /// Destroy the resource data.
            /// Decrease reference count for the top level object if it is reference counted,
            /// otherwise call the non-virtual object's destructor and deallocate its memory.
            /// Note: You may free hkObjectResource even if your other objects still reference
            /// the loaded reference counted objects, assuming you maintain reference
            /// counting accordingly.
        virtual ~hkObjectResource();

        virtual void getImportsExports( hkArray<Import>& impOut, hkArray<Export>& expOut ) const HK_OVERRIDE;

            /// Analogous to getContents except that cleanup is now the responsibility of the caller, not the resource.
        template<typename T>
        _Ret_maybenull_ T* stealContents()
        {
            if(T* t = hkDynCast<T>(m_topLevelObject))
            {
                m_topLevelObject.clear();
                return t;
            }
            return HK_NULL;
        }

            /// Similar to getContentsPointer except that cleanup is now the responsibility of the caller, not the resource.
        virtual _Ret_maybenull_ void* stealContentsPointer(_In_z_ const char* typeName);

        hkReflect::Var stealContentsVar()
        {
            hkReflect::Var contents(m_topLevelObject);
            m_topLevelObject.clear();
            return contents;
        }

        template<typename T>
        _Ret_maybenull_ T* getContents() const
        {
            return static_cast<T*>(getContentsPointer(hkReflect::getType<T>()));
        }

        hkReflect::Var getContents() const HK_OVERRIDE
        {
            return m_topLevelObject;
        }

    protected:

        hkReflect::Var m_topLevelObject;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
