// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Serialize/Resource/hkObjectResource.h>

hkObjectResource::hkObjectResource(const hkReflect::Var& v)
: m_topLevelObject(v)
{
    HK_ASSERT_NO_MSG(0x36e7deb0, v);
}

hkObjectResource::~hkObjectResource()
{
    if(m_topLevelObject.getType())
    {
        if(const hkReferencedObject* object = hkDynCast<hkReferencedObject>(m_topLevelObject))
        {
            object->removeReference();
        }
        else
        {
            m_topLevelObject.destroy();
        }
    }
}

_Ret_z_ const char* hkObjectResource::getName() const
{
    return HK_NULL;
}

void hkObjectResource::getImportsExports( hkArray<Import>& impOut, hkArray<Export>& expOut ) const
{
}

_Ret_maybenull_ void* hkObjectResource::stealContentsPointer(_In_z_ const char* typeName)
{
    void* ret = getContentsPointer(typeName);
    if( ret ) // successful steal,
    {
        m_topLevelObject.clear();
    }
    return ret;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
