// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL !OSINTERNAL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Serialize/Core/hkSerializeCore.h>

namespace hkSerialize
{
    class TypeWriter;

    class HK_EXPORT_COMMON XmlWriteFormat : public WriteFormat
    {
    public:
        typedef int TypeId;

        XmlWriteFormat(_In_opt_ hkSerialize::TypeWriter* writer = HK_NULL);
        ~XmlWriteFormat();

        virtual void beginBundle(_In_ hkIo::WriteBuffer* writeBuffer) HK_OVERRIDE;
        virtual void endBundle() HK_OVERRIDE;

        virtual hkResult write(const hkReflect::Var& var, IdFromVar& idFromVar) HK_OVERRIDE;
        virtual hkResult writeNote(VarId vid, const hkReflect::Var& note, IdFromVar& idFromVar) HK_OVERRIDE;

        struct XmlFormatter;
        struct TypeWriter;

    protected:

        void writeVarContents(const hkReflect::Var& firstObject, _In_ IdFromVar* idFromVar, int numObjects);
        hkResult writeInternal(const hkReflect::Var& topVar, VarId vid, VarId annotated, _Inout_ IdFromVar* idFromVar);

        static bool hasVariantArrays(_In_ const hkReflect::Type* type, _In_opt_ const hkReflect::RecordType* curRecord = HK_NULL);
        void writeVariantArraySubtypes(const hkReflect::Var& var);

        XmlFormatter* m_formatter;
        hkRefPtr<hkSerialize::TypeWriter> m_typeWriter;
        hkHashSet<hkUint32> m_withVariantArrays;
    };
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
