// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL !OSINTERNAL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

class hkStreamReader;
class hkOArchive;

/// Common data used in the binary tagfile reader and writer.
/// See the comments in hkBinaryTagfileWriter for version descriptions.
namespace hkBinaryTagfile2014
{
        /// Magic marker constants used in the file.
    enum TagType
    {
        TAG_EOF = -1,
            /// Invalid tag.
        TAG_NONE = 0,

            /// File header info. Followed by an integer version number.
            /// The rest of the header data is determined by the version number.
        TAG_FILE_INFO = 1,

            /// The following item is an hkGenericClass
        TAG_METADATA = 2,

            /// The following item is an hkGenericObject which will not be
            /// referenced again.
        TAG_OBJECT = 3,
            /// The following item is an object which may be referenced again
            /// from TAG_OBJECT_BACKREF. The id is implicitly the count of preceding
            /// remembered objects.
        TAG_OBJECT_REMEMBER = 4,
            /// Refer to a previously encountered object.
            /// Followed by the integer object index.
        TAG_OBJECT_BACKREF = 5,
            /// The null object pointer, only used in version 0 and 1
        TAG_OBJECT_NULL = 6,

            /// End of file marker
        TAG_FILE_END = 7,
    };

    enum
    {
        BINARY_MAGIC_0 = 0xCAB00D1E,
        BINARY_MAGIC_1 = 0xD011FACE,
    };

    typedef hkInt32 SerialId;

    template <int SIZE>
    HK_INLINE void copySwapped(_Out_writes_bytes_all_(SIZE) char* buf, _In_reads_bytes_(SIZE) const char* src)
    {
        for (int i = 0; i < SIZE; ++i)
        {
            buf[i] = src[SIZE-1-i];
        }
    }

    template <typename T>
    inline T convertEndian(T value)
    {
        T res;
        copySwapped<sizeof(T)>(reinterpret_cast<char*>(&res), reinterpret_cast<const char*>(&value));
        return res;
    }

        /// Do the numbers match the binary magic numbers in either endianness?
    inline hkBool HK_CALL isBinaryMagic( hkUint32 number0, hkUint32 number1 )
    {
        return (((number0 == hkBinaryTagfile2014::BINARY_MAGIC_0) && (number1 == hkBinaryTagfile2014::BINARY_MAGIC_1))
            || ((convertEndian(number0) == hkUint32(hkBinaryTagfile2014::BINARY_MAGIC_0)) && (convertEndian(number1) == hkUint32(hkBinaryTagfile2014::BINARY_MAGIC_1))));
    }

    // This is only used for compatibility to load to load older tagfiles
    struct TagfileArray_TypeArrayImpl
    {
        struct Serialized
        {
            int m_numElements;
            int m_fixedSize;
        };
    };

    struct Header
    {
        HK_DECLARE_CLASS(Header, New);
        int m_magic[2];
        int m_tag;

        int m_version;

        hkResult read(_Inout_ hkStreamReader* sr, bool& swapBytes);
        // Write header for the current version
        static void write(_Inout_ hkStreamWriter* dest);

        hkStringPtr m_sdk;
        hkUint16 m_numPredicates;

        bool supportsPredicates() const { return m_version >= 5; }
        hkUint16 m_maxpredicate;
        hkArray<hkUint16> m_truePredicates;
    };
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
