// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL !OSINTERNAL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Serialize/Format/Tagfile2014/hkTagfileCommon2014.h>
#include <Common/Base/System/Io/Reader/hkStreamReader.h>
#include <Common/Base/System/Io/IArchive/hkIArchive.h>
#include <Common/Base/Types/hkEndian.h>
#include <Common/Base/Container/PointerMap/hkMap.hxx>

hkResult hkBinaryTagfile2014::Header::read(_Inout_ class hkStreamReader* sr, bool& swapBytes)
{
    // checks if a byte swap is necessary
    hkUint32 magic0;
    sr->read(&magic0, sizeof(magic0));
    if(magic0 == hkBinaryTagfile2014::BINARY_MAGIC_0)
    {
        swapBytes = false;
    }
    else if(magic0 == (hkUint32)hkBinaryTagfile2014::convertEndian<hkUint32>((hkUint32)hkBinaryTagfile2014::BINARY_MAGIC_0))
    {
        swapBytes = true;
    }
    else
    {
        return HK_FAILURE;
    }

    hkIArchive ia(sr, (hkBool)swapBytes);
    hkUint32 magic1 = ia.read32u();
    if(magic1 != hkBinaryTagfile2014::BINARY_MAGIC_1)
    {
        return HK_FAILURE;
    }
    hkUint32 tag = ia.read32u(); // Old tagfiles have a tag == 1 here
    int ver = ia.read32();
    if (tag != 1 && ver != 11 )
    {
        return HK_FAILURE;
    }
    return (ver == 13 ? HK_SUCCESS : HK_FAILURE);
}

void hkBinaryTagfile2014::Header::write(_Inout_ hkStreamWriter* dest)
{
    // Tagfile version is the physical file layout, nothing to do
    // with the versions of the contained objects.
    const int TAGFILE_VERSION_2014_2 = 13; // 10 = old tagfile, 11/12 = intermediate, 13 = new tagfile
    dest->write1As<hkUint32Le>((hkUint32)hkBinaryTagfile2014::BINARY_MAGIC_0);
    dest->write1As<hkUint32Le>((hkUint32)hkBinaryTagfile2014::BINARY_MAGIC_1);
    dest->write1As<hkUint32Le>(1); // for compatibility with older tagfiles, we expect a tag here
    dest->write1As<hkUint32Le>( TAGFILE_VERSION_2014_2 );
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
