// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Serialize/Core/hkSerializeCore.h>

namespace hkReflect { class TypeCopier; }

namespace hkSerialize
{
    class TypeWriter;

    class TagfileWriteFormat : public WriteFormat
    {
    public:

        HK_EXPORT_COMMON TagfileWriteFormat();
        HK_EXPORT_COMMON TagfileWriteFormat(_Inout_ hkReflect::TypeCopier* copier);
        HK_EXPORT_COMMON TagfileWriteFormat(_In_z_ const char* platform);
        HK_EXPORT_COMMON ~TagfileWriteFormat();

        void beginBundle(_In_ hkIo::WriteBuffer* writeBuffer) HK_OVERRIDE;
        void endBundle() HK_OVERRIDE;

        virtual hkResult write(const hkReflect::Var& var, IdFromVar& idFromVar) HK_OVERRIDE;
        virtual hkResult writeNote(VarId vid, const hkReflect::Var& note, IdFromVar& idFromVar) HK_OVERRIDE;

        void beginTypeCompendium(const hkIo::Detail::WriteBufferAdapter& sink) HK_OVERRIDE;
        void endTypeCompendium() HK_OVERRIDE;

        hkResult enableMultiBundle() HK_OVERRIDE;

        struct Impl;

    protected:

        void operator=(const TagfileWriteFormat&);
        Impl* m_impl;
    };
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
