// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Serialize/Core/hkSerializeCore.h>

namespace hkSerialize
{
    class HK_EXPORT_COMMON TagfileReadFormat : public ReadFormat
    {
    public:
        typedef void(*NewTypeCallback)(hkReflect::Type*);

        TagfileReadFormat();
        ~TagfileReadFormat();

        virtual hkViewPtr<Bundle> read(hkIo::ReadBuffer& rb) HK_OVERRIDE;
        virtual hkViewPtr<Bundle> view(_In_reads_bytes_(bufLen) const void* buf, hkUlong bufLen, _Out_opt_ hkUlong* usedOut) HK_OVERRIDE;
        virtual hkViewPtr<Bundle> inplace(_In_reads_bytes_(bufLen) const void* buf, hkUlong bufLen, _Out_ hkUlong* usedOut, _In_ const hkReflect::TypeReg* typeReg) HK_OVERRIDE;

        void registerCallback(NewTypeCallback cb);

        static hkResult unload(_In_reads_bytes_(len) const void* buf, hkUlong len);

    protected:
        struct Impl;
        Impl* m_impl;
    };
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
