// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

namespace hkSerialize
{
    namespace Detail
    {
        extern const hkUint32 s_optMapping[8];

        #define FOUR_CC(a,b,c,d) (((a)<<24)|((b)<<16)|((c)<<8)|((d)<<0))

        struct TagfileRoot
        {
            enum Enum
            {
                TAGFILE = FOUR_CC('T','A','G','0'),
                COMPENDIUM = FOUR_CC('T','C','M','0'),
            };
        };

        struct TagfileSection
        {
            enum Enum
            {
                // Order is important.
                // SDK_VERSION is first and is exactly 8 bytes so that DATA falls naturally on a 32 byte boundary.
                // DATA is next so it can be aligned sensibly.
                // TYPES or COMPENDIUM_REFERENCE
                // INDEX

                SDK_VERSION = FOUR_CC('S','D','K','V'), ///< 8 character string. e.g. 2015.1.0 = 20150100
                DATA = FOUR_CC('D','A','T','A'), ///< The main contents

                TYPES = FOUR_CC('T', 'Y', 'P', 'E'), ///< Type data (except for the strings, templates etc)
                COMPENDIUM_REFERENCE = FOUR_CC('T', 'C', 'R', 'F'), ///< TypeCompendium reference (a 64 bit hash of types)
                COMPENDIUM_ID = FOUR_CC('T', 'C', 'I', 'D'), ///< An array of 64 bit hashes corresponding to TCRF values using this compendium.

                INDEX = FOUR_CC('I','N','D','X'),
            };
        };

        struct TagfileTypeSection
        {
            enum Enum
            {
                // parent is TYPE_SECTION
                NATIVE_POINTERS = FOUR_CC('T', 'P', 'T', 'R'), ///< (packfile only) Some reserved space for native type pointers. (Makes unload easier)
                SEQUENCE_NUMBER_V0 = FOUR_CC('T', 'S', 'E', 'Q'), ///< For multibundle streaming (packet number + type hash) (has a bug with streaming)
                ROLLING_HASH = FOUR_CC('T', 'S', 'H', 'A'), ///< For multibundle streaming
                NAME_STRINGS = FOUR_CC('T', 'S', 'T', 'R'), ///< Strings used in type names and templates
                IDENTITY_V0 = FOUR_CC('T', 'N', 'A', 'M'), ///< Name + Template encoded (has a bug with streaming)
                IDENTITY = FOUR_CC('T', 'N', 'A', '1'), ///< Name + Template encoded
                FIELD_NAME_STRINGS = FOUR_CC('F', 'S', 'T', 'R'), ///< Strings used in field names (can be stripped for inplace)
                ATTRIBUTE_STRINGS = FOUR_CC('A', 'S', 'T', 'R'), ///< Attributes of dynamic types
                BODY_V0 = FOUR_CC('T', 'B', 'O', 'D'), ///< Everything except (Name + Template) encoded. (can be stripped for inplace) (has a bug with streaming)
                BODY = FOUR_CC('T', 'B', 'D', 'Y'), ///< Everything except (Name + Template) encoded. (can be stripped for inplace)
                HASHES = FOUR_CC('T', 'H', 'S', 'H'), ///< Type,hash(crc) pairs. Pairs of (type id, hkUint32Le)
                PROPERTIES = FOUR_CC('T', 'P', 'R', 'O'), ///< Decls included on demand (e.g. non-serializable)
                PROPS_HASHES = FOUR_CC('T', 'P', 'H', 'S'), ///< Hash of property decls (name only), saved only for types mentioned in PROPERTIES
                PADDING = FOUR_CC('T', 'P', 'A', 'D'), ///<
            };
        };

        struct TagfileIndexSection
        {
            enum Enum
            {
                // parent is INDEX_SECTION
                ITEMS = FOUR_CC('I', 'T', 'E', 'M'), ///< triples of hkUint32Be
                PATCH_DATA = FOUR_CC('P', 'T', 'C', 'H'), ///< (packfile only) Inplace patches
            };
        };

        struct TagfileItem
        {
            enum Enum
            {
                KIND_EMPTY= 0x00000000u, //packed=0, offset=0, count=0 or associated note index
                KIND_VAR0 = 0x10000000u, //offset=data, count=1
                KIND_VARN = 0x20000000u, //offset=data, count=1
                KIND_NOTE = 0x30000000u, //offset=data, count=noteId
                KIND_TYPE = 0x40000000u, //offset=-1, count=0
                KIND_DECL = 0x50000000u, //offset=-1, count=fieldindex

                KIND_MASK = 0xf0000000u,

                FLAG_VTINIT = 0x01000000u,
                FLAG_MASK = 0x0f000000u,

                INDEX_MASK = 0x00ffffffu,
            };
            TagfileItem() : packed(0), offset(0), count(0) {}

            bool isKindVar0() const { return (packed & KIND_MASK) == KIND_VAR0; }
            bool isKindVarN() const { return (packed & KIND_MASK) == KIND_VARN; }
            bool isKindNote() const { return (packed & KIND_MASK) == KIND_NOTE; }
            bool isKindType() const { return (packed & KIND_MASK) == KIND_TYPE; }
            bool isKindDecl() const { return (packed & KIND_MASK) == KIND_DECL; }
            Enum getKind() const { return Enum(packed & KIND_MASK); }
            bool isEmpty() const { return (packed & KIND_MASK) == 0; }
            hkUint32 getIndex() const { return packed & INDEX_MASK; }
            hkUint32 packed; // (kind4, flags4, tid24)
            hkUint32 offset;
            hkUint32 count;
        };

        #undef FOUR_CC
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
