// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Serialize/Core/hkSerializeCore.h>

namespace hkReflect { class TypeCopier; }

namespace hkSerialize
{
    /// Compression types used by compression format.
    struct HK_EXPORT_COMMON CompressionFormatType
    {
        enum Enum
        {
            DEFAULT_COMPRESSION,
            UNCOMPRESSED
        };
    };

    class HK_EXPORT_COMMON CompressionWriteFormat : public WriteFormat
    {
    public:

        CompressionWriteFormat(_In_opt_ WriteFormat* writeFormat = HK_NULL, CompressionFormatType::Enum compressionType = CompressionFormatType::Enum::DEFAULT_COMPRESSION);
        ~CompressionWriteFormat();

        void beginBundle(_In_ hkIo::WriteBuffer* writeBuffer) HK_OVERRIDE;
        void endBundle() HK_OVERRIDE;

        void beginTypeCompendium(const hkIo::Detail::WriteBufferAdapter& sink) HK_OVERRIDE;
        void endTypeCompendium() HK_OVERRIDE;

        virtual hkResult write(const hkReflect::Var& var, IdFromVar& idFromVar) HK_OVERRIDE;
        virtual hkResult writeNote(VarId vid, const hkReflect::Var& note, IdFromVar& idFromVar) HK_OVERRIDE;

    protected:

        void writeCompressed(hkArrayView<char> content, hkIo::WriteBuffer& writeBuffer);

        hkRefPtr<WriteFormat> m_writeFormat;
        hkEnum<CompressionFormatType::Enum, hkUint8> m_compressionType;

        hkIo::WriteBuffer* m_writeBuffer;
        hkIo::WriteBuffer m_localWriteBuffer;

        hkIo::Detail::WriteBufferAdapter m_compendiumAdapter;
        hkIo::Detail::WriteBufferAdapter m_localCompendiumAdapter;
        hkArray<char> m_localCompendiumContent;

        hkArray<char> m_content;
        hkRefPtr<hkStreamWriter> m_writer;

    };
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
