// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/Serialize/Format/Compression/hkCompressionWriteFormat.h>

#include <Common/Base/System/Io/Writer/Array/hkArrayStreamWriter.h>

#include <Common/Base/Config/hkOptionalComponent.h>

#include <Common/Base/Algorithm/Compression/hkBufferCompression.h>

#include <Common/Base/Serialize/Detail/hkSerializeDetail.h>

#define DEBUG_LOG_IDENTIFIER "s11n.CompressionWriteFormat"
#include <Common/Base/System/Log/hkLog.hxx>


hkSerialize::CompressionWriteFormat::CompressionWriteFormat(_In_opt_ WriteFormat* writeFormat, CompressionFormatType::Enum compressionType)
    : m_writeFormat(writeFormat)
    , m_compressionType(compressionType)
{
    if (m_writeFormat == HK_NULL)
    {
        m_writeFormat = WriteFormat::createDefault();
    }
}

hkSerialize::CompressionWriteFormat::~CompressionWriteFormat()
{
    m_writeFormat = HK_NULL;
}

void hkSerialize::CompressionWriteFormat::beginBundle(_In_ hkIo::WriteBuffer* writeBuffer)
{
    m_writeBuffer = writeBuffer;

    m_content.clear();
    m_writer = hkRefNew<hkArrayStreamWriter>(new hkArrayStreamWriter(&m_content, hkArrayStreamWriter::ARRAY_BORROW));
    HK_ASSERT_NO_MSG(0x40c596c9, !m_localWriteBuffer.isAttached());
    m_localWriteBuffer.attach(m_writer);

    m_writeFormat->beginBundle(&m_localWriteBuffer);
}

void hkSerialize::CompressionWriteFormat::writeCompressed(hkArrayView<char> content, hkIo::WriteBuffer& writeBuffer)
{
    // TODO: we need to switch over the compression type if we support more than the default compression in the future.
    hkUint8 compressionType = static_cast<hkUint8>(m_compressionType);
    hkUint32 uncompressedSize = content.getSize();

    // Write header with some additional information about the compression being used and the uncompressed size.
    {
        const void* in = content.begin();
        hkArray<char>::Temp out; out.setSize(uncompressedSize);

        hk_size_t compsz = hkBufferCompression::compressBuffer(in, uncompressedSize, out.begin(), uncompressedSize);
        const bool compressionFailed = compsz == 0;

        // If compression fails, save as uncompressed type
        if (compressionFailed)
        {
            compressionType = CompressionFormatType::Enum::UNCOMPRESSED;
        }

        writeBuffer.writeRaw("<compr>", 7);
        writeBuffer.write8(compressionType);
        writeBuffer.write32u(uncompressedSize);

        if (!compressionFailed)
        {
            writeBuffer.write32u(static_cast<hkUint32>(compsz));
            writeBuffer.writeRaw(out.begin(), compsz);
        }
        else
        {
            writeBuffer.write32u(static_cast<hkUint32>(content.getSize()));
            writeBuffer.writeRaw(content.begin(), content.getSize());
        }
    }
}

void hkSerialize::CompressionWriteFormat::endBundle()
{
    m_writeFormat->endBundle();

    // Detach local write buffer so that content is fully available in m_content.
    m_localWriteBuffer.detach();
    m_writer = HK_NULL;

    writeCompressed(m_content, *m_writeBuffer);

    m_writeBuffer = HK_NULL;
    m_content.clear();
}

void hkSerialize::CompressionWriteFormat::beginTypeCompendium(const hkIo::Detail::WriteBufferAdapter& sink)
{
    m_compendiumAdapter = sink;

    m_localCompendiumAdapter.set(&m_localCompendiumContent);

    m_writeFormat->beginTypeCompendium(m_localCompendiumAdapter);
}

void hkSerialize::CompressionWriteFormat::endTypeCompendium()
{
    m_writeFormat->endTypeCompendium();

    hkIo::WriteBuffer compendiumBuffer(m_compendiumAdapter);

    writeCompressed(m_localCompendiumContent, compendiumBuffer);

    m_compendiumAdapter.clear();
    m_localCompendiumAdapter.clear();
    m_localCompendiumContent.clear();
}

hkResult hkSerialize::CompressionWriteFormat::write(const hkReflect::Var& topvar, IdFromVar& idFromVar)
{
    return m_writeFormat->write(topvar, idFromVar);
}

hkResult hkSerialize::CompressionWriteFormat::writeNote(VarId vid, const hkReflect::Var& note, IdFromVar& idFromVar)
{
    return m_writeFormat->writeNote(vid, note, idFromVar);
}

#ifndef HK_DYNAMIC_DLL
static
#endif
hkRefNew<hkSerialize::WriteFormat> compressedTagfileCreateWrite()
{
    HK_OPTIONAL_COMPONENT_MARK_USED(hkWriteFormatCompressedTagfile);
    return new hkSerialize::CompressionWriteFormat(HK_NULL);
}

HK_OPTIONAL_COMPONENT_DEFINE(hkWriteFormatCompressedTagfile, hkSerialize::Detail::fileFormatCompressedTagfile.m_writeFormatCreateFunc, compressedTagfileCreateWrite);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
