// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Serialize/Format/Compression/hkCompressionReadFormat.h>
#include <Common/Base/Serialize/Format/Compression/hkCompressionWriteFormat.h>

#include <Common/Base/Config/hkOptionalComponent.h>

#include <Common/Base/Serialize/Detail/hkSerializeDetail.h>

#include <Common/Base/Algorithm/Compression/hkBufferCompression.h>

#define DEBUG_LOG_IDENTIFIER "s11n.CompressionReadFormat"
#include <Common/Base/System/Log/hkLog.hxx>

hkSerialize::CompressionReadFormat::CompressionReadFormat()
{
}

hkSerialize::CompressionReadFormat::~CompressionReadFormat()
{
}

hkViewPtr<hkSerialize::Bundle> hkSerialize::CompressionReadFormat::read(hkIo::ReadBuffer& rb)
{
    // Skip format identifier and read compression information.
    rb.skip(7);

    // TODO: use hkCompressionFormatType when we support more than the default compression in the future.
    const CompressionFormatType::Enum compressionType = (CompressionFormatType::Enum)rb.read8u();
    if (compressionType != CompressionFormatType::DEFAULT_COMPRESSION &&
        compressionType != CompressionFormatType::UNCOMPRESSED)
    {
        Log_Warning("Unsupported compression type!");
        return HK_NULL;
    }

    const hkUint32 decompressedSize = rb.read32u();
    const hkUint32 compressedSize = rb.read32u();

    hkLong bufferSize = rb.prefetch(compressedSize);
    if (bufferSize <= 0)
    {
        return HK_NULL;
    }

    // Decompress content.
    hkArray<char>::Temp decompressedContent;
    decompressedContent.setSize(decompressedSize);

    {
        // Read compressed content.
        hkArray<char>::Temp content;
        content.setSize(static_cast<int>(bufferSize));
        rb.read(content.begin(), bufferSize);

        switch (compressionType)
        {
        case CompressionFormatType::DEFAULT_COMPRESSION:
        {
            void* out = decompressedContent.begin();
        if (hkBufferCompression::decompressBuffer(content.begin(), content.getSize(), out, decompressedSize).isFailure())
            {
                Log_Warning("Decompression failed!");
                return HK_NULL;
            }
            break;
        }
        case CompressionFormatType::UNCOMPRESSED:
            decompressedContent.swap(content);
            break;
        default:
            Log_Warning("Unsupported compression type!");
            return HK_NULL;
        }
    }

    if (!m_readFormat)
    {
        // Detect format on the decompressed content to find out the correct reader format.
        if (const hkSerialize::Detail::FileFormatRegNode* format = hkSerialize::Detail::detectFormat(decompressedContent.begin(), decompressedSize))
        {
            m_readFormat = format->createReadFormat();
        }
        else
        {
            Log_Warning("No registered loader was found for the format \"{}\".", format->getName()).setId(Detail::ERRORID_UNSUPPORTED_FORMAT);
        }
    }

    if (m_readFormat)
    {
        // Forward to the original read format and let it do the actual work.
        hkIo::ReadBuffer localReadBuffer(decompressedContent.begin(), decompressedSize);
        return m_readFormat->read(localReadBuffer);
    }

    return HK_NULL;
}

hkViewPtr<hkSerialize::Bundle> hkSerialize::CompressionReadFormat::view(_In_reads_bytes_(bufLen) const void* buf, hkUlong bufLen, _Out_opt_ hkUlong* usedOut)
{
    hkIo::ReadBuffer rb(buf, bufLen);

    hkViewPtr<hkSerialize::Bundle> bundle = read(rb);

    if (usedOut)
    {
        *usedOut = rb.tell();
    }

    return bundle;
}

#ifndef HK_DYNAMIC_DLL
static
#endif
hkRefNew<hkSerialize::ReadFormat> compressedTagfileCreateRead()
{
    HK_OPTIONAL_COMPONENT_MARK_USED(hkReadFormatCompressedTagfile);
    return new hkSerialize::CompressionReadFormat();
}

HK_OPTIONAL_COMPONENT_DEFINE(hkReadFormatCompressedTagfile, hkSerialize::Detail::fileFormatCompressedTagfile.m_readFormatCreateFunc, compressedTagfileCreateRead);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
