// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64 !OSINTERNAL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Serialize/Format/Compat/hkCompatFormats.h>
#include <Common/Base/System/Dll/DynamicLibrary/hkDynamicLibrary.h>
#include <Common/Base/Serialize/Core/hkSerializeCore.h>
#include <Common/Base/Serialize/Detail/hkSerializeDetail.h>
#include <Common/Base/System/Io/IStream/hkIStream.h>
#include <Common/Base/Config/hkOptionalComponent.h>
#include <Common/Base/Serialize/Format/Tagfile2014/hkTagfileReadFormat2014.h>
#include <Common/Base/System/hkBaseSystem.h>
#include <Common/Base/Object/hkSingleton.h>
#include <Common/Base/Reflect/Builder/hkTypeBuilder.h>
#include <Common/Base/Reflect/Core/Detail/hkReflectTypeDetail.h>
#include <Common/Base/Reflect/Builder/hkRecordLayout.h>
#include <Common/Base/Serialize/Format/Xml/hkXmlWriteFormat.h>
#include <Common/Base/System/Io/Util/hkLoadUtil.h>

#include <Common/Base/Serialize/Format/Compat/ContentTools/hkClassMember.h>
#include <Common/Base/Serialize/Format/Compat/ContentTools/hkClass.h>
#include <Common/Base/Serialize/Format/Compat/ContentTools/hctFilterConfigurationSet.h>
#include <Common/Base/Serialize/Format/Compat/ContentTools/hctClothSetup20141Options.h>
#include <Common/Base/Serialize/Format/Compat/ContentTools/hctClothSetupClothData20141Options.h>
#include <Common/Base/Serialize/Format/Compat/ContentTools/hctClothSetupObjectData.h>
#include <Common/Base/Serialize/Format/Compat/ContentTools/hctFilterClothSetupStubOptions.h>
#include <Common/Base/Serialize/Format/Compat/ContentTools/hctAttributeDescription.h>
#include <Common/Base/Serialize/Util/Xml/hkXmlParser.h>
#include <Common/Base/Reflect/Visitor/hkReflectVisitor.h>
#include <Common/Base/Container/RelArray/hkRelArray.h>
#include <Common/Base/Container/StringMap/hkStorageStringMap.h>

namespace
{
    typedef int(*MessageFunc)(int, int, const char*, const char*, int);
    typedef bool(*InitFunc)(MessageFunc);
    typedef void(*VoidFunc)();
    typedef const void* (*LoadFunc)(const void*, int&, int&, hkUlong&, const char*&);
    typedef void(*FreeFunc)(hkUlong);

    typedef bool(*LoadOptionsFunc)(const void*, int);

    typedef void(*GetFilterConfigSetFunc)(int&, int&);
    typedef void(*GetFilterConfigFunc)(int, const char*&, int&);
    typedef void(*GetFilterStageFunc)(int, int, unsigned int&, const void*&, const class hkClass*&, const void*&, int&, unsigned int&);

    typedef bool(*LoadClothSetupFunc)(const void*, int, hkUlong&);
    typedef int(*GetClothSetupDataNumFunc)(hkUlong);
    typedef void(*GetClothSetupDataFunc)(hkUlong, int, const char*&, int&, int&, int(&)[8]);
    typedef void(*GetClothSetupObjectFunc)(hkUlong, int, int, int, const char*&, const char*&, unsigned int&, const void*&, const class hkClass*&, const void*&, int&, unsigned int&);

    typedef int(*GetAttributeDescriptionGroupsNumFunc)();
    typedef void(*GetAttributeDescriptionGroupFunc)(int, const char*&, int&);
    typedef void(*GetAttributeDescriptionFunc)(int, int, const char*&, const char*&, int&, const char*&, int&, int&, bool&, float&);
    typedef void(*GetAttributeDescriptionEnumItemFunc)(int, int, int, const char*&, int&);

    // Forwards the errors in the DLL to the local hkError singleton.
    int defaultMessageFunc(int m, int id, _In_z_ const char* description, _In_z_ const char* file, int line)
    {
        hkError::Message message = hkError::MESSAGE_ERROR;
        switch (m)
        {
            case 0: message = hkError::MESSAGE_REPORT; break;
            case 1: message = hkError::MESSAGE_WARNING; break;
            case 2: message = hkError::MESSAGE_ASSERT; break;
            case 3: message = hkError::MESSAGE_ERROR; break;
            default: HK_ASSERT_NO_MSG(0x6b21e9cc, 0);
        }
        return hkError::getInstance().message(message, id, description, file, line);
    }

    void deleteTempType(_Inout_ hkReflect::Type* type, _Inout_ hkMemoryAllocator* allocator, hkUlong data)
    {
        if (const hkReflect::RecordType* rec = type->asRecord())
        {
            for (int i = rec->getNumFields() - 1; i >= 0; --i)
            {
                hk::DeleteTypeInfo::deleteType(const_cast<hkReflect::Type*>(rec->getField(i).getType()->getParent()));
            }

            if (const hkReflect::Type* parent = rec->getParent())
            {
                hk::DeleteTypeInfo::deleteType(const_cast<hkReflect::Type*>(parent));
            }
        }
        else if (const hkReflect::ArrayType* arr = type->asArray())
        {
            hk::DeleteTypeInfo::deleteType(const_cast<hkReflect::Type*>(arr->getSubType().get()));
        }

        hkReflect::TypeBuilder::deallocateType(type, allocator, data);
    }

    // Simple hkClass -> hkReflect conversion functions.
    // Assume that the layout and behavior of basic Havok types (hkStringPtr, hkArray, math types) never changes.
    _Ret_notnull_ hkReflect::Type* convertClass(_In_ const hkClass* klass);

    _Ret_maybenull_ const hkReflect::Type* getTypeForField(hkClassMember::Type type, hkClassMember::Type subType, _In_ const hkClass* klass, int arrSize)
    {
        if (arrSize)
        {
            // C array
            const hkReflect::Type* elemType = getTypeForField(type, subType, klass, 0);
            hkReflect::TypeBuilder builder;
            builder.beginArray(elemType, arrSize);
            builder.addItem<hkReflect::Opt::IMPL>(&hkReflect::Detail::RepeatImpl::s_instance);
            builder.setItem<hkReflect::Opt::SIZE_ALIGN>(
                hkReflect::Detail::SizeAlign(elemType->getSizeOf() * arrSize, elemType->getAlignOf()).asUlong());
            builder.addDeleteInfo(&deleteTempType);
            return builder.allocate(hkMemHeapAllocator());
        }

        switch (type)
        {
        case hkClassMember::TYPE_BOOL: return hkReflect::getType<bool>();
        case hkClassMember::TYPE_CHAR: return hkReflect::getType<char>();
        case hkClassMember::TYPE_INT8: return hkReflect::getType<hkInt8>();
        case hkClassMember::TYPE_UINT8: return hkReflect::getType<hkUint8>();
        case hkClassMember::TYPE_INT16: return hkReflect::getType<hkInt16>();
        case hkClassMember::TYPE_UINT16: return hkReflect::getType<hkUint16>();
        case hkClassMember::TYPE_INT32: return hkReflect::getType<hkInt32>();
        case hkClassMember::TYPE_UINT32: return hkReflect::getType<hkUint32>();
        case hkClassMember::TYPE_INT64: return hkReflect::getType<hkInt64>();
        case hkClassMember::TYPE_UINT64: return hkReflect::getType<hkUint64>();
        case hkClassMember::TYPE_REAL: return hkReflect::getType<hkReal>();
        case hkClassMember::TYPE_VECTOR4: return hkReflect::getType<hkVector4>();
        case hkClassMember::TYPE_QUATERNION: return hkReflect::getType<hkQuaternion>();
        case hkClassMember::TYPE_MATRIX3: return hkReflect::getType<hkMatrix3>();
        case hkClassMember::TYPE_ROTATION: return hkReflect::getType<hkRotation>();
        case hkClassMember::TYPE_QSTRANSFORM: return hkReflect::getType<hkQsTransform>();
        case hkClassMember::TYPE_MATRIX4: return hkReflect::getType<hkMatrix4>();
        case hkClassMember::TYPE_TRANSFORM: return hkReflect::getType<hkTransform>();
        case hkClassMember::TYPE_POINTER: { return hkReflect::getType<void*>(); }
        case hkClassMember::TYPE_ARRAY:
        {
            // hkArray
            const hkReflect::Type* elemType = getTypeForField(subType, hkClassMember::TYPE_VOID, klass, 0);
            hkReflect::TypeBuilder builder;
            builder.beginArray(elemType, 0);
            builder.addItem<hkReflect::Opt::IMPL>(&hkReflect::Detail::hkArrayImpl::s_instance);
            builder.setItem<hkReflect::Opt::SIZE_ALIGN>(
                hkReflect::Detail::SizeAlign(sizeof(hkArray<char>), HK_ALIGN_OF(hkArray<char>)).asUlong());
            builder.addDeleteInfo(&deleteTempType);
            return builder.allocate(hkMemHeapAllocator());
        }
        case hkClassMember::TYPE_ENUM: return getTypeForField(subType, hkClassMember::TYPE_VOID, HK_NULL, 0);
        case hkClassMember::TYPE_STRUCT: return convertClass(klass);
        case hkClassMember::TYPE_CSTRING: return hkReflect::getType<char*>();
        case hkClassMember::TYPE_ULONG: return hkReflect::getType<hkUlong>();
        case hkClassMember::TYPE_FLAGS: return getTypeForField(subType, hkClassMember::TYPE_VOID, HK_NULL, 0);
        case hkClassMember::TYPE_STRINGPTR: return hkReflect::getType<hkStringPtr>();
        default:
        {
            HK_ASSERT_NO_MSG(0x3c6d182a, 0);
            return HK_NULL;
        }
        }
    }

    _Ret_maybenull_ const hkReflect::Type* getTypeForField(const hkClassMember& field)
    {
        return getTypeForField(field.getType(), field.getSubType(), field.getClass(), field.getCstyleArraySize());
    }

    _Ret_notnull_ hkReflect::Type* convertClass(_In_ const hkClass* klass)
    {
        hkReflect::TypeBuilder builder;
        const hkReflect::Type* parent = klass->getParent() ? convertClass(klass->getParent()) : HK_NULL;
        builder.beginRecord(klass->getName(), parent);
        builder.setItem<hkReflect::Opt::IMPL>(&hkReflect::Detail::HavokRecordImpl::s_instance);

        // Alignment should be unused.
        builder.setItem<hkReflect::Opt::SIZE_ALIGN>(hkReflect::Detail::SizeAlign(klass->getObjectSize(), 1).asUlong());

        if (int version = klass->getDescribedVersion())
        {
            builder.setItem<hkReflect::Opt::VERSION>(version);
        }

        for (int i = 0; i < klass->getNumDeclaredMembers(); ++i)
        {
            const hkClassMember& field = klass->getDeclaredMember(i);
            if (field.getFlags().noneIsSet(hkClassMember::SERIALIZE_IGNORED))
            {
                builder.addMember(field.getName(), field.getOffset(), 0, getTypeForField(field));
            }
        }

        builder.addDeleteInfo(&deleteTempType);
        hkReflect::Type* res = builder.allocate(hkMemHeapAllocator());
        return res;
    }
}

hkCompatFormats::hkCompatFormats(_In_opt_z_ const char* dir)
{
    clearPtrs();

    // Load the library.
    hkStringBuf path(dir);
    path.pathAppend("hkCompatFormats.dll");
    m_library = hkDynamicLibrary::load(path);

    if (m_library)
    {
        // Load the symbols.
        do
        {
            #define LOAD_FUNC(PTR, NAME) \
                { PTR = m_library->findSymbol(NAME); if (PTR == HK_NULL) break; }

            LOAD_FUNC(m_initFunc, "compatInit");
            LOAD_FUNC(m_quitFunc, "compatQuit");
            LOAD_FUNC(m_loadFunc, "compatLoad");
            LOAD_FUNC(m_freeFunc, "compatFree");
            LOAD_FUNC(m_loadFilterConfigSetFunc, "loadFilterConfigSet");
            LOAD_FUNC(m_getFilterConfigSetFunc, "getFilterConfigSet");
            LOAD_FUNC(m_getFilterConfigFunc, "getFilterConfig");
            LOAD_FUNC(m_getFilterStageFunc, "getFilterStage");
            LOAD_FUNC(m_loadClothSetupFunc, "loadClothSetup");
            LOAD_FUNC(m_freeClothSetupFunc, "freeClothSetup");
            LOAD_FUNC(m_getClothSetupDataNumFunc, "getClothSetupDataNum");
            LOAD_FUNC(m_getClothSetupDataFunc, "getClothSetupData");
            LOAD_FUNC(m_getClothSetupObjectFunc, "getClothSetupObject");
            LOAD_FUNC(m_loadAttributeDescriptionFunc, "loadAttributeDescription");
            LOAD_FUNC(m_getAttributeDescriptionGroupsNumFunc, "getAttributeDescriptionGroupsNum");
            LOAD_FUNC(m_getAttributeDescriptionGroupFunc, "getAttributeDescriptionGroup");
            LOAD_FUNC(m_getAttributeDescriptionFunc, "getAttributeDescription");
            LOAD_FUNC(m_getAttributeDescriptionEnumItemFunc, "getAttributeDescriptionEnumItem");

            #undef LOAD_FUNC
            m_isLoaded = true;
        } while (0);

        if(m_isLoaded)
        {
            // Initialize the library.
            if (!reinterpret_cast<InitFunc>(m_initFunc)(&defaultMessageFunc))
            {
                m_isLoaded = false;
            }
        }

        if (!m_isLoaded)
        {
            clearPtrs();
            HK_WARN_ALWAYS(0xabba9734, path.cString() << " is not a valid DLL.");
        }
    }
}

hkCompatFormats::~hkCompatFormats()
{
    // Quit the library.
    if(m_quitFunc)
    {
        static_cast<VoidFunc>(m_quitFunc)();
    }
}

void hkCompatFormats::clearPtrs()
{
    m_library = HK_NULL;
    hkString::memSet(&m_initFunc, 0, sizeof(hkCompatFormats) - HK_OFFSET_OF(hkCompatFormats, m_initFunc));
}

class hkCompatFormats::ReadFormat : public hkSerialize::ReadFormat
{
    public:
        HK_DECLARE_CLASS(ReadFormat, New);

        ReadFormat(const hkCompatFormats& library)
            : m_load(static_cast<LoadFunc>(library.m_loadFunc))
            , m_free(static_cast<FreeFunc>(library.m_freeFunc))
        {
            HK_ASSERT_NO_MSG(0x438b3c47, m_load);
            HK_ASSERT_NO_MSG(0x3a88190b, m_free);
        }

        virtual hkViewPtr<hkSerialize::Bundle> read(hkIo::ReadBuffer& rb) HK_OVERRIDE
        {
            hkLong size = rb.prefetchAll();
            if (size)
            {
                hkUlong used = 0;
                // rely on the fact that this->view() actually copies the input
                hkViewPtr<hkSerialize::Bundle> b = view(rb.peekAt<void>(0,size), size, &used);
                rb.skip(used);
                return b;
            }
            return HK_NULL;
        }

        virtual hkViewPtr<hkSerialize::Bundle> view(_In_reads_bytes_(bufLen) const void* buf, hkUlong bufLen, _Out_ hkUlong* usedOut) HK_OVERRIDE
        {
            int convertedSize = hkLosslessCast<int>(bufLen);
            int usedOutLocal = 0;
            hkUlong handle = 0;
            const char* error = HK_NULL;
            if(const void* res = (*m_load)(buf, convertedSize, usedOutLocal, handle, error) )
            {
                // Read the 2014 tagfile into a bundle.
                hkIo::ReadBuffer converted(res, convertedSize);
                hkViewPtr<hkSerialize::Bundle> bundle = m_tagfileReadFormat.read(converted);
                (*m_free)(handle);
                if(usedOut)
                {
                    *usedOut = usedOutLocal;
                }
                return bundle;
            }
            else
            {
                HK_WARN_ALWAYS(0xabba9735, "File could not be loaded: " << error);
                (*m_free)(handle);
            }
            return HK_NULL;
        }

    private:
        LoadFunc m_load;
        FreeFunc m_free;
        VoidFunc m_initThread;
        VoidFunc m_quitThread;
        hkSerialize::TagfileReadFormat2014 m_tagfileReadFormat;
};

#define DEFINE_READ_FORMAT(FORMAT_NAME) \
    hkRefNew<hkSerialize::ReadFormat> HK_CALL hkCompatFormats::create ## FORMAT_NAME() \
    { \
        HK_OPTIONAL_COMPONENT_MARK_USED(hkReadFormat ## FORMAT_NAME); \
        hkCompatFormats& cf = hkCompatFormats::getInstance(); \
        if (cf.isLoaded()) \
        { \
            return new ReadFormat(cf); \
        } \
        HK_WARN_ALWAYS(0xabba9736, "File with format '" #FORMAT_NAME "' could not be loaded, a valid hkCompatFormats.dll was not found"); \
        return HK_NULL; \
    } \
    HK_OPTIONAL_COMPONENT_DEFINE(hkReadFormat ## FORMAT_NAME, hkSerialize::Detail::fileFormat ## FORMAT_NAME.m_readFormatCreateFunc, &hkCompatFormats::create ## FORMAT_NAME);

DEFINE_READ_FORMAT(BinaryPackfile2014);
DEFINE_READ_FORMAT(XmlTagfile2014);
DEFINE_READ_FORMAT(XmlPackfile2010);

#undef DEFINE_READ_FORMAT

// ------------------------------- Filters ------------------------------- //

void hkCompatFormats::convertConfigurationSet(_In_reads_bytes_(optionSize) const void* optionData, int optionSize, _Inout_ hkStreamWriter* optionsOut) const
{
    HK_ASSERT_NO_MSG(0x265c06c6, m_initFunc);
    HK_ASSERT_NO_MSG(0x36d4eafb, m_quitFunc);
    HK_ASSERT_NO_MSG(0x425516d, m_loadFilterConfigSetFunc);

    // Update the error handler with the one in the current DLL.
    if (!reinterpret_cast<InitFunc>(m_initFunc)(&defaultMessageFunc))
    {
        return;
    }

    bool success = static_cast<LoadOptionsFunc>(m_loadFilterConfigSetFunc)(optionData, optionSize);

    if (!success)
    {
        return;
    }

    // Convert the loaded set to the 2015.1 version.
    hctFilterConfigurationSet20151 newFcs;
    hkArray< hkScopedPtr<hctFilterClothSetupStubOptions20151> >::Temp newCSFilterOptionsArray;
    hkArray< hkUlong >::Temp newCSOptionsHandles;
    hkArray<hkReflect::Any>::Temp customOptions;
    hkArray<hkReflect::Type*>::Temp convertedTypes;

    int configNum;
    static_cast<GetFilterConfigSetFunc>(m_getFilterConfigSetFunc)(configNum, newFcs.m_currentIndex);

    newFcs.m_configurations.setSize(configNum);
    for (int ci = 0; ci < newFcs.m_configurations.getSize(); ++ci)
    {
        hctFilterConfigurationSet20151::Configuration& newConfig = newFcs.m_configurations[ci];

        const char* configName; int stageNum;
        static_cast<GetFilterConfigFunc>(m_getFilterConfigFunc)(ci, configName, stageNum);

        newConfig.m_configName = configName;
        newConfig.m_filterStages.setSize(stageNum);

        for (int fi = 0; fi < newConfig.m_filterStages.getSize(); ++fi)
        {
            hctFilterConfigurationSet20151::FilterStage& newStage = newConfig.m_filterStages[fi];

            const void* options; const hkClass* optionsClass;
            const void* rawOptions; int rawOptionsSize; unsigned int rawVersion;
            static_cast<GetFilterStageFunc>(m_getFilterStageFunc)(ci, fi,
                newStage.m_filterId, options, optionsClass, rawOptions, rawOptionsSize, rawVersion);

            newStage.m_optionDataVersion = 0;

            if (rawOptions)
            {
                if (OptionsCb cb = m_filterCbs.getWithDefault(newStage.m_filterId, HK_NULL))
                {
                    // Use a custom callback to deserialize the options.
                    cb(rawOptions, rawOptionsSize, rawVersion, customOptions.expandOne());
                    newStage.m_options.stealOwnership(customOptions.back().var());
                }
                else if (options && optionsClass)
                {
                    // Craft a Type for the options object.
                    hkReflect::Type* convertedType = convertClass(optionsClass);
                    convertedTypes.pushBack(convertedType);
                    hkReflect::RecordLayout::recomputeNative(convertedType);

                    hkReflect::Var oldOptions(options, convertedType);

                    if (newStage.m_filterId == 0x700030ce) // hctFilterClothSetupStubOptions
                    {
                        // Manual conversion.
                        newCSFilterOptionsArray.expandOne().reset(new hctFilterClothSetupStubOptions20151);
                        hctFilterClothSetupStubOptions20151& newCSFilterOptions = *newCSFilterOptionsArray.back();

                        hkReflect::DeclIter<hkReflect::FieldDecl> oldIter(oldOptions.getType());
                        HK_ON_DEBUG(bool adv = )oldIter.advance();
                        HK_ASSERT_NO_MSG(0x761eb764, adv);

                        // hkArray<char> -> Any
                        hkReflect::ArrayVar optField = oldOptions[oldIter.current()];
                        HK_ASSERT_NO_MSG(0x4e893378, optField);
                        hkArrayView<hkUint8> serialized = optField.getValue().isArrayOf<hkUint8>();
                        hkUlong handle = 0;
                        if (serialized.getSize())
                        {
                            // Deserialize the hctClothSetupOptions and store them in the Any.
                            newCSFilterOptions.m_clothToolOptions.init(hkReflect::getType<hctClothSetup20151Options>());
                            hctClothSetup20151Options& newCSOptions = *newCSFilterOptions.m_clothToolOptions.var().dynCast<hctClothSetup20151Options>();
                            handle = loadClothSetupOptions((char*)serialized.begin(), serialized.getSize(), newCSOptions, customOptions, convertedTypes);
                            if (!handle)
                            {
                                newCSFilterOptions.m_clothToolOptions.clear();
                            }
                        }
                        newCSOptionsHandles.pushBack(handle);

                        // Copy over all the other fields.
                        hkReflect::DeclIter<hkReflect::FieldDecl> newIter(hkReflect::getType<hctFilterClothSetupStubOptions20151>());
                        HK_ON_DEBUG(adv = )newIter.advance();
                        HK_ASSERT_NO_MSG(0x6aea198d, adv);
                        while (newIter.advance())
                        {
                            HK_ON_DEBUG(adv = )oldIter.advance();
                            HK_ASSERT_NO_MSG(0x74561be1, adv);
                            hkReflect::Var(&newCSFilterOptions)[newIter.current()].assign(oldOptions[oldIter.current()]);
                        }

                        oldOptions = hkReflect::Var(&newCSFilterOptions);
                    }

                    newStage.m_options.stealOwnership(oldOptions); 
                }
                else if (newStage.m_filterId != 0xb349ffa1) // hctCreateCollidablesFilter, does not have options any more
                {
                    HK_WARN_ALWAYS(0xabbaa1df, "Cannot load options for filter ID " << newStage.m_filterId << " using hkCompatFormats.");
                }
            }
        }
    }

    // Write the XML.
    hkSerialize::Save().withFormat<hkSerialize::XmlWriteFormat>().contentsPtr(&newFcs, optionsOut);

    // Release the converted Cloth Setup options if they were used.
    for (int i = 0; i < newCSFilterOptionsArray.getSize(); ++i)
    {
        hctFilterClothSetupStubOptions20151& newCSFilterOptions = *newCSFilterOptionsArray[i];
        hkUlong handle = newCSOptionsHandles[i];
        releaseClothSetupOptions(*newCSFilterOptions.m_clothToolOptions.var().dynCast<hctClothSetup20151Options>(), handle);
    }

    // Release the options so that they are not deleted by the Any and delete the temp types
    
    
    
    
    
    
    for (int ci = 0; ci < newFcs.m_configurations.getSize(); ++ci)
    {
        hctFilterConfigurationSet20151::Configuration& config = newFcs.m_configurations[ci];
        for (int fi = 0; fi < config.m_filterStages.getSize(); ++fi)
        {
            hctFilterConfigurationSet20151::FilterStage& stage = config.m_filterStages[fi];
            stage.m_options.yieldOwnership(); 
        }
    }

    customOptions.clear();
    for (int i = 0; i < convertedTypes.getSize(); ++i)
    {
        hk::DeleteTypeInfo::deleteType(convertedTypes[i]);
    }

    // Pop the error manager.
    reinterpret_cast<VoidFunc>(m_quitFunc)();
}


// ------------------------------- Cloth Setup plugins ------------------------------- //

namespace
{
    hkArray<hctClothSetupObjectData20151*>& getObjectArray(hctClothSetupClothData20151Options& clothData, int arrayIdx)
    {
        switch (arrayIdx)
        {
        case 0: return clothData.m_setupMeshes;
        case 1: return clothData.m_simSetupMeshes;
        case 2: return clothData.m_buffers;
        case 3: return clothData.m_simCloth;
        case 4: return clothData.m_operators;
        case 5: return clothData.m_transformSets;
        case 6: return clothData.m_simClothConstraints;
        default:
        {
            HK_ASSERT_NO_MSG(0xad4532db, arrayIdx == 7);
            return clothData.m_clothStates;
        }
        }
    }
}

hkUlong hkCompatFormats::loadClothSetupOptions(_In_reads_bytes_(optionSize) const char* optionData, int optionSize,
    class hctClothSetup20151Options& newOpts,
    hkArray<hkReflect::Any>::Temp& customOptions,
    hkArray<hkReflect::Type*>::Temp& convertedTypes) const
{
    HK_ASSERT_NO_MSG(0x29700fa6, m_loadClothSetupFunc);

    // Use the DLL to load and upgrade the options.
    hkUlong handle;
    bool success = static_cast<LoadClothSetupFunc>(m_loadClothSetupFunc)(optionData, optionSize, handle);

    if (!success)
    {
        return 0;
    }

    // Convert the options into the 2015.1 format.
    newOpts.m_clothData.setSize(static_cast<GetClothSetupDataNumFunc>(m_getClothSetupDataNumFunc)(handle));
    for (int cdi = 0; cdi < newOpts.m_clothData.getSize(); ++cdi)
    {
        hctClothSetupClothData20151Options*& newCD = newOpts.m_clothData[cdi];
        newCD = new hctClothSetupClothData20151Options;

        const char* name; int arraySizes[8];
        static_cast<GetClothSetupDataFunc>(m_getClothSetupDataFunc)(handle, cdi, name, newCD->m_currentState, newCD->m_defaultState, arraySizes);
        newCD->m_name = name;

        for (int arrIdx = 0; arrIdx < 8; ++arrIdx)
        {
            hkArray<hctClothSetupObjectData20151*>& objectArray = getObjectArray(*newCD, arrIdx);
            objectArray.setSize(arraySizes[arrIdx]);

            for (int objIdx = 0; objIdx < objectArray.getSize(); ++objIdx)
            {
                hctClothSetupObjectData20151*& newObj = objectArray[objIdx];
                newObj = new hctClothSetupObjectData20151;

                const char* pluginName, *objectName;
                const void* options; const hkClass* optionsClass;
                const void* rawOptions; int rawOptionsSize; unsigned int rawVersion;
                static_cast<GetClothSetupObjectFunc>(m_getClothSetupObjectFunc)(handle, cdi, arrIdx, objIdx,
                    pluginName, objectName, newObj->m_ref.m_hash,
                    options, optionsClass, rawOptions, rawOptionsSize, rawVersion);

                newObj->m_ref.m_pluginName = pluginName;
                newObj->m_ref.m_objectName = objectName;

                if (options)
                {
                    if (OptionsCb cb = m_clothSetupCbs.getWithDefault(pluginName, HK_NULL))
                    {
                        // Use a custom callback to deserialize the options.
                        cb(rawOptions, rawOptionsSize, rawVersion, customOptions.expandOne());
                        newObj->m_options.stealOwnership(customOptions.back().var()); 
                    }
                    else if(optionsClass)
                    {
                        // Craft a Type for the options object.
                        hkReflect::Type* convertedType = convertClass(optionsClass);
                        convertedTypes.pushBack(convertedType);
                        hkReflect::RecordLayout::recomputeNative(convertedType);
                        newObj->m_options.stealOwnership(hkReflect::Var(options, convertedType)); 
                    }
                    else
                    {
                        HK_WARN_ALWAYS(0xabbaa1de, "Cannot load options for Cloth Setup plugin \"" << pluginName << "\" using hkCompatFormats.");
                    }
                }
            }
        }
    }

    return handle;
}

#include <Common/Base/KeyCode.h>

void hkCompatFormats::convertClothSetupOptions(_Inout_ hkStreamReader* optionsIn, _Inout_ hkStreamWriter* optionsOut) const
{
#if defined(HK_FEATURE_PRODUCT_CLOTH)
    HK_ASSERT_NO_MSG(0x29700fa6, m_initFunc);
    HK_ASSERT_NO_MSG(0x29700fa6, m_quitFunc);

    // Update the error handler with the one in the current DLL.
    if (!reinterpret_cast<InitFunc>(m_initFunc)(&defaultMessageFunc))
    {
        return;
    }
    hkArray<char> serialized;
    hkLoadUtil(optionsIn).toArray(serialized);

    hctClothSetup20151Options newOpts;

    hkArray<hkReflect::Type*>::Temp convertedTypes;
    hkArray<hkReflect::Any>::Temp customOptions;
    hkUlong handle = loadClothSetupOptions(serialized.begin(), serialized.getSize(), newOpts, customOptions, convertedTypes);
    if (handle == 0)
    {
        return;
    }

    // Write the XML.
    hkSerialize::Save().withFormat<hkSerialize::XmlWriteFormat>().contentsPtr(&newOpts, optionsOut);

    // Release the options so that they are not deleted by the Anys and delete the types.
    releaseClothSetupOptions(newOpts, handle);

    customOptions.clear();
    for (int i = 0; i < convertedTypes.getSize(); ++i)
    {
        hk::DeleteTypeInfo::deleteType(convertedTypes[i]);
    }

    // Pop the error manager.
    reinterpret_cast<VoidFunc>(m_quitFunc)();
#else
    HK_ERROR(0x6b34f187, "Cloth versioning not enabled");
#endif
}

void hkCompatFormats::releaseClothSetupOptions(class hctClothSetup20151Options& newOpts, hkUlong handle) const
{
    HK_ASSERT_NO_MSG(0x71a89033, m_freeClothSetupFunc);
    if (handle)
    {
        
        
        
        
        
        
        for (int cdi = 0; cdi < newOpts.m_clothData.getSize(); ++cdi)
        {
            for (int arrIdx = 0; arrIdx < 8; ++arrIdx)
            {
                hkArray<hctClothSetupObjectData20151*>& arr = getObjectArray(*newOpts.m_clothData[cdi], arrIdx);
                for (int i = 0; i < arr.getSize(); ++i)
                {
                    arr[i]->m_options.yieldOwnership(); 
                }
            }
        }

        static_cast<FreeFunc>(m_freeClothSetupFunc)(handle);
    }
}

void hkCompatFormats::convertAttributeDescriptionOptions(_Inout_ class hkStreamReader* optionsIn, _Inout_ class hkStreamWriter* optionsOut) const
{
    HK_ASSERT_NO_MSG(0x29700fa6, m_loadAttributeDescriptionFunc);

    hkArray<char> serialized;
    hkLoadUtil(optionsIn).toArray(serialized);

    // Use the DLL to load the options.
    bool success = static_cast<LoadOptionsFunc>(m_loadAttributeDescriptionFunc)(serialized.begin(), serialized.getSize());

    if (!success)
    {
        return;
    }

    // Convert the attributes into the 2015.1 format.
    hctAttributeDescriptionDatabase20151 newDb;

    newDb.m_groupDescriptions.setSize(static_cast<GetAttributeDescriptionGroupsNumFunc>(m_getAttributeDescriptionGroupsNumFunc)());
    for (int groupIdx = 0; groupIdx < newDb.m_groupDescriptions.getSize(); ++groupIdx)
    {
        hctAttributeGroupDescription20151& newGroup = newDb.m_groupDescriptions[groupIdx];
        const char* groupName;
        int descNum;
        static_cast<GetAttributeDescriptionGroupFunc>(m_getAttributeDescriptionGroupFunc)(groupIdx, groupName, descNum);
        newGroup.m_name = groupName;
        newGroup.m_attributeDescriptions.setSize(descNum);
        for (int descIdx = 0; descIdx < descNum; ++descIdx)
        {
            hctAttributeDescription20151& newDesc = newGroup.m_attributeDescriptions[descIdx];
            const char* descName;
            const char* enabledBy;
            const char* enumName;
            int enumItemNum;
            int forcedType, hint;
            HK_COMPILE_TIME_ASSERT(sizeof(bool) == sizeof(hkBool));
            static_cast<GetAttributeDescriptionFunc>(m_getAttributeDescriptionFunc)(groupIdx, descIdx, descName, enabledBy,
                forcedType, enumName, enumItemNum, hint, reinterpret_cast<bool&>(newDesc.m_clearHints), newDesc.m_floatScale);
            newDesc.m_name = descName;
            newDesc.m_enabledBy = enabledBy;
            newDesc.m_forcedType = static_cast<hctAttributeDescription20151::ForcedType>(forcedType);
            newDesc.m_hint = static_cast<hctAttributeDescription20151::Hint>(hint);

            if (enumName)
            {
                hctAttributeDescription20151::Enum* newEnum = new hctAttributeDescription20151::Enum;
                newDesc.m_enum.reset(newEnum);
                newEnum->m_name = enumName;
                newEnum->m_items.setSize(enumItemNum);
                for (int itemIdx = 0; itemIdx < enumItemNum; ++itemIdx)
                {
                    hctAttributeDescription20151::Enum::Item& newItem = newEnum->m_items[itemIdx];
                    const char* itemName;
                    static_cast<GetAttributeDescriptionEnumItemFunc>(m_getAttributeDescriptionEnumItemFunc)(groupIdx, descIdx, itemIdx, itemName, newItem.m_value);
                    newItem.m_name = itemName;
                }
            }
        }
    }

    // Write the XML.
    hkSerialize::Save().withFormat<hkSerialize::XmlWriteFormat>().contentsPtr(&newDb, optionsOut);
}

void hkCompatFormats::registerFilterOptionsCallback(unsigned filterId, OptionsCb callback)
{
    m_filterCbs.insert(filterId, callback);
}

void hkCompatFormats::registerClothSetupOptionsCallback(_In_z_ const char* pluginName, OptionsCb callback)
{
    m_clothSetupCbs.insert(pluginName, callback);
}

void hkCompatFormats::unregisterFilterOptionsCallback(unsigned filterId)
{
    m_filterCbs.remove(filterId);
}

void hkCompatFormats::unregisterClothSetupOptionsCallback(_In_z_ const char* pluginName)
{
    m_clothSetupCbs.remove(pluginName);
}

namespace
{
    /// Contains data needed to move buffer in memory.
    class hkRelocationInfo
    {
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SERIALIZE, hkRelocationInfo);

        /// Create an empty object.
        hkRelocationInfo()
            : m_pool(HK_NULL)
        {
        }

        hkRelocationInfo(const hkRelocationInfo& r)
        {
            HK_ASSERT_NO_MSG(0x4aa2092e, 0);
        }

        /// Destroy object.
        ~hkRelocationInfo();

        /// Pointer fixups within a buffer.
        struct Local
        {
            HK_DECLARE_POD_TYPE();
            Local(int f, int t)
                : m_fromOffset(f),
                m_toOffset(t)
            {
            }
            /// source offset in buffer
            int m_fromOffset;
            /// destination offset in buffer
            int m_toOffset;
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SERIALIZE, hkRelocationInfo::Local);
        };

        /// Pointer fixups to a location outside the buffer.
        struct Global
        {
            HK_DECLARE_POD_TYPE();
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE, hkRelocationInfo::Global);
            Global(int f, _In_ void* ta, _In_ const hkClass* k, hkBool32 related)
                : m_fromOffset(f),
                m_toAddress(ta),
                m_toClass(k),
                m_related(related)
            {
            }
            /// source offset in buffer
            int m_fromOffset;
            /// dest pointer in global address
            void* m_toAddress;
            /// type of pointed to object
            const hkClass* m_toClass;
            /// indicates if object must be kept near the source
            hkBool32 m_related;
        };

        /// Objects which will need a "finish" step on load.
        struct Finish
        {
            HK_DECLARE_POD_TYPE();
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE, hkRelocationInfo::Finish);
            Finish(int f, _In_ const char* k)
                : m_fromOffset(f),
                m_className(k)
            {
            }
            /// Object start in buffer
            int m_fromOffset;
            /// name of fixup
            const char* m_className;
        };

        /// Pointers to objects not in this data block.
        struct Import
        {
            HK_DECLARE_POD_TYPE();
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE, hkRelocationInfo::Import);
            Import(int fromOffset, _In_ const char* identifier)
                : m_fromOffset(fromOffset),
                m_identifier(identifier)
            {
            }
            /// source offset in buffer
            int m_fromOffset;
            /// unique identifier
            const char* m_identifier;
        };

        /// Add a local relocation.
        void addLocal(int fromOffset, int toOffset)
        {
            m_local.pushBack(Local(fromOffset, toOffset));
        }

        /// Add a global relocation.
        void addGlobal(int fromOffset, _In_ void* toAddr, _In_ const hkClass* klass, hkBool32 related = false)
        {
            m_global.pushBack(Global(fromOffset, toAddr, klass, related));
        }

        /// Add a finish marker.
        void addFinish(int fromOffset, _In_z_ const char* klassName)
        {
            m_finish.pushBack(Finish(fromOffset, klassName));
        }

        /// Add an import marker.
        void addImport(int fromOffset, _In_z_ const char* name);

        /// Apply local and global relocations to the supplied buffer.
        void applyLocalAndGlobal(_Inout_updates_bytes_(_Inexpressible_()) void* buffer);

        /// Clear all lists.
        void clear()
        {
            m_local.clear();
            m_global.clear();
            m_finish.clear();
            m_imports.clear();
        }

    public:

        hkArray<Local> m_local;
        hkArray<Global> m_global;
        hkArray<Finish> m_finish;
        hkArray<Import> m_imports;
        hkStorageStringMap<int, hkContainerHeapAllocator>* m_pool;
    };
    hkRelocationInfo::~hkRelocationInfo()
    {
        delete m_pool;
    }

    void hkRelocationInfo::applyLocalAndGlobal(_Inout_updates_bytes_(_Inexpressible_()) void* buffer)
    {
        char* ret = static_cast<char*>(buffer);

        // apply all fixups
        {
            for (int i = 0; i < m_local.getSize(); ++i)
            {
                *(void**)(ret + m_local[i].m_fromOffset) = ret + m_local[i].m_toOffset;
            }
        }
        {
            for (int i = 0; i < m_global.getSize(); ++i)
            {
                *(void**)(ret + m_global[i].m_fromOffset) = m_global[i].m_toAddress;
            }
        }
    }

    void hkRelocationInfo::addImport(int off, _In_z_ const char* name)
    {
        if (m_pool == HK_NULL)
        {
            m_pool = new hkStorageStringMap<int>();
        }
        m_imports.pushBack(Import(off, m_pool->insert(name, 0)));
    }


    struct XmlObjectReader_DummyArray
    {
        void* ptr;
        int size;
        int cap;
    };

    template <typename T>
    T& lookupMember(void* start)
    {
        return *reinterpret_cast<T*>(start);
    }

    struct Buffer
    {
        public:

            enum Pad
            {
                PAD_NONE = 1,
                PAD_4 = 4,
                PAD_8 = 8,
                PAD_16 = 16
            };

            Buffer(hkArray<char>& c)
                :    m_buf(c)
            {
            }

                // Reserve space for nbytes - fill with zeros
                // Return offset of writable space
            int reserve(int nbytes, Pad pad = PAD_NONE)
            {
                int orig = m_buf.getSize();
                int size = HK_NEXT_MULTIPLE_OF(pad, orig + nbytes);
                m_buf.setSize( size, 0 );
                m_buf.setSizeUnchecked( orig );
                return orig;
            }

                // Advance by nbytes - should never cause reallocation
                // because we should have previously reserve()d space.
            void advance( int nbytes, Pad pad = PAD_NONE )
            {
                int size = HK_NEXT_MULTIPLE_OF(pad, m_buf.getSize() + nbytes);
                HK_ASSERT(0x12402f4c, size <= m_buf.getCapacity(), "Overflowing XML write buffer capacity, will cause resize." );
                m_buf.setSizeUnchecked( size );
            }

            void* pointerAt( int offset )
            {
                HK_ASSERT(0x6c591289, offset <= m_buf.getSize(), "Offset of pointer not within XML buffer range." );
                return m_buf.begin() + offset;
            }

        private:

            hkArray<char>& m_buf;
    };

    void* addByteOffset(void* p, int n)
    {
        return static_cast<char*>(p) + n;
    }

    static bool isPodMember(_In_ const hkReflect::Type* mtype)
    {
        return (mtype->asValue() && !mtype->asString()) ||
            mtype->extendsOrEquals<hkVector4>() || mtype->extendsOrEquals<hkQuaternion>() ||
            mtype->extendsOrEquals<hkMatrix3>() || mtype->extendsOrEquals<hkRotation>() ||
            mtype->extendsOrEquals<hkQsTransform>() || mtype->extendsOrEquals<hkMatrix4>() || mtype->extendsOrEquals<hkTransform>();
    }

    static inline hkResult extractCstring(int memberStartOffset, const hkStringBuf& text, Buffer& buffer, hkRelocationInfo& reloc)
    {
        if (text.getLength() != 1 || text[0] != 0) // null pointer is represented as single null
        {
            int len = text.getLength() + 1; // include null
            int textOffset = buffer.reserve(len, Buffer::PAD_16);
            hkString::memCpy(buffer.pointerAt(textOffset), text.cString(), len);
            reloc.addLocal( memberStartOffset, textOffset );
            buffer.advance(len, Buffer::PAD_16);
            return HK_SUCCESS;
        }
        return HK_FAILURE;
    }

    // read a member into the location curp.
    // The input data is available as an istream.
    // Arrays are temporarily stored in array* for later processing.
    static hkResult readSinglePodMember(_In_ const hkReflect::Type* mtype, _Inout_ void* curp, hkIstream& is)
    {
        if (mtype->asBool())
        {
            hkBool* f = static_cast<hkBool*>(curp);
            is >> *f;
        }
        else if (mtype->extendsOrEquals<char>())
        {
            char* f = static_cast<char*>(curp);
            is.read(f, 1);
        }
        else if (mtype->asValue())
        {
            switch(mtype->getFormat().get())
            {
                
                case hkReflect::Format::OfInt<hkInt8>::Value:
                {
                    hkInt8* f = static_cast<hkInt8*>(curp);
                    int foo;
                    is >> foo;
                    *f = static_cast<hkInt8>(foo);
                    break;
                }
                case hkReflect::Format::OfInt<hkUint8>::Value:
                {
                    hkUint8* f = static_cast<hkUint8*>(curp);
                    int foo;
                    is >> foo;
                    *f = static_cast<hkUint8>(foo);
                    break;
                }
                case hkReflect::Format::OfInt<hkInt16>::Value:
                {
                    hkInt16* f = static_cast<hkInt16*>(curp);
                    is >> *f;
                    break;
                }
                case hkReflect::Format::OfInt<hkUint16>::Value:
                {
                    hkUint16* f = static_cast<hkUint16*>(curp);
                    is >> *f;
                    break;
                }
                case hkReflect::Format::OfInt<hkInt32>::Value:
                {
                    hkInt32* f = static_cast<hkInt32*>(curp);
                    is >> *f;
                    break;
                }
                case hkReflect::Format::OfInt<hkUint32>::Value:
                {
                    hkUint32* f = static_cast<hkUint32*>(curp);
                    is >> *f;
                    break;
                }
                case hkReflect::Format::OfInt<hkInt64>::Value:
                {
                    hkInt64* f = static_cast<hkInt64*>(curp);
                    is >> *f;
                    break;
                }
                case hkReflect::Format::OfInt<hkUint64>::Value:
                {
                    hkUint64* f = static_cast<hkUint64*>(curp);
                    is >> *f;
                    break;
                }
                case hkReflect::Format::OfFloat<hkReal>::Value:
                {
                    hkReal* f = static_cast<hkReal*>(curp);
                    is >> *f;
                    break;
                }
                case hkReflect::Format::OfFloat<hkHalf16>::Value:
                {
                    hkHalf16* hf = static_cast<hkHalf16*>(curp);
                    hkReal f;
                    is >> f;
                    hf->setReal<false>(f);
                    break;
                }
                default:
                {
                    HK_ERROR(0x19fca9ac, "Unknown value format: " << mtype->getFormat().get());
                    return HK_FAILURE;
                }
            }
        }
        else if (mtype->extendsOrEquals<hkVector4>() || mtype->extendsOrEquals<hkQuaternion>())
        {
            hkReal* f = static_cast<hkReal*>(curp);
            is >> f[0] >> f[1] >> f[2] >> f[3];
        }
        else if (mtype->extendsOrEquals<hkMatrix3>() || mtype->extendsOrEquals<hkRotation>())
        {
            hkReal* f = static_cast<hkReal*>(curp);
            hkString::memSet(f, 0, 12 * sizeof(hkReal));
            is >> f[0] >> f[1] >> f[2];
            is >> f[4] >> f[5] >> f[6];
            is >> f[8] >> f[9] >> f[10];
        }
        else if (mtype->extendsOrEquals<hkQsTransform>())
        {
            hkReal* f = static_cast<hkReal*>(curp);
            is >> f[0] >> f[1] >> f[2];
            is >> f[4] >> f[5] >> f[6] >> f[7];
            is >> f[8] >> f[9] >> f[10];
            f[3] = f[11] = 0;
        }
        else if (mtype->extendsOrEquals<hkMatrix4>())
        {
            hkReal* f = static_cast<hkReal*>(curp);
            is >> f[0] >> f[1] >> f[2] >> f[3];
            is >> f[4] >> f[5] >> f[6] >> f[7];
            is >> f[8] >> f[9] >> f[10] >> f[11];
            is >> f[12] >> f[13] >> f[14] >> f[15];
        }
        else if (mtype->extendsOrEquals<hkTransform>())
        {
            hkReal* f = static_cast<hkReal*>(curp);
            is >> f[0] >> f[1] >> f[2];
            is >> f[4] >> f[5] >> f[6];
            is >> f[8] >> f[9] >> f[10];
            is >> f[12] >> f[13] >> f[14];
            f[3] = f[7] = f[11] = 0;
            f[15] = 1;
        }
        else
        {
            HK_ERROR(0x19fca9ad, "Class member unknown / unhandled: " << mtype );
        }
        return is.isOk() ? HK_SUCCESS : HK_FAILURE;
    }

    static hkBool32 extractText(hkXmlParser& parser, _Inout_ hkStreamReader* reader, _In_ const hkXmlParser::StartElement* start, bool canonicalize, hkStringBuf& ret)
    {
        hkBool32 gotText = true;
        hkXmlParser::Node* node = HK_NULL;
        parser.nextNode(&node, reader);
        if (hkXmlParser::Characters* chars = node->asCharacters())
        {
            if (canonicalize)
            {
                chars->canonicalize("(),");
            }
            ret = chars->text;
            gotText = chars->text.cString() != HK_NULL; // null string (not empty string "")
            delete node;
        }
        else if (node->asEnd())
        {
            // empty characters ok == the empty string
            parser.putBack(node);
        }
        else
        {
            HK_ASSERTV(0x6cc04e1a, 0, "Parse error, expected characters after {}.", start->name);
        }
        return gotText;
    }

    static hkResult consumeEndElement(hkXmlParser& parser, _Inout_ hkStreamReader* reader, _Inout_ hkXmlParser::StartElement* start)
    {
        hkResult retValue = HK_SUCCESS;
        hkXmlParser::Node* node = HK_NULL;
        parser.nextNode(&node, reader);
        hkXmlParser::EndElement* end = node->asEnd();
        if (end == HK_NULL || end->name != start->name)
        {
            HK_ASSERTV(0x4cadab61, end != HK_NULL, "Parse error, expected end element for {}.", start->name);
            HK_ASSERTV(0x2c0e93cf, end && (end->name == start->name), "Mismatched end element for {}.", start->name);
            retValue = HK_FAILURE;
        }
        delete node;
        return retValue;
    }

    static int loadSimpleArray(_In_ const hkReflect::Type* mtype, const hkStringBuf& text, Buffer& buffer)
    {
        int numElements = 0;
        if (isPodMember(mtype))
        {
            int msize = mtype->getSizeOf();
            hkIstream istream(text.cString(), text.getLength());
            int off = buffer.reserve(msize);
            // Variable used to skip one character after every element in the array
            // (required when reading an array of chars).
            char c;
            while (readSinglePodMember(mtype, buffer.pointerAt(off), istream).isSuccess())
            {
                numElements += 1;
                istream.get(c);
                // Either we are in the middle of the array or we should have exhausted the text line.
                HK_ASSERT_NO_MSG(0x60ddf9fe, c == ' ' || !istream.isOk());
                buffer.advance(msize);
                off = buffer.reserve(msize);
            }
        }
        else
        {
            // these aren't simple types
            HK_ASSERT(0x6cc0400a, 0, "Load simple array called on a member that is not a simple array.");
        }
        buffer.reserve(0, Buffer::PAD_16);
        buffer.advance(0, Buffer::PAD_16);

        return numElements;
    }

    static hkResult readClassBody(
        _In_ const hkReflect::Type* klass,
        int classStartOffset,
        Buffer& buffer,
        _Inout_ hkXmlParser::StartElement* topElement,
        hkXmlParser& parser,
        _Inout_ hkStreamReader* reader,
        hkRelocationInfo& reloc)
    {
        hkXmlParser::Node* node;

        while (parser.nextNode(&node, reader).isSuccess())
        {
            if (hkXmlParser::StartElement* startElement = node->asStart())
            {
                HK_ASSERTV(0x3acc8f13, startElement->name == "hkparam", "XML element starts with {}, not with the expected 'hkparam'.", startElement->name);
                const char* paramName = startElement->getAttribute("name", HK_NULL);
                HK_ASSERT(0x3bbb5581, paramName != HK_NULL, "XML element missing 'name' attribute.");

                hkReflect::FieldDecl member = klass->findDecl(paramName).asField();
                if (!member)
                {
                    HK_WARN(0x28cd8bfc, "Unknown member '" << klass->getName() << "::" << paramName << "'. Ignoring it.");
                    hkXmlParser::Tree tree;
                    parser.expandNode(startElement, tree, reader);
                    startElement->removeReference();
                    // tree destructor deletes xml nodes.
                    continue;
                }

                struct Visitor : public hkReflect::TypeVisitor<Visitor, hkResult, int>
                {
                    typedef hkReflect::TypeVisitor<Visitor, hkResult, int> ParentType;

                    Visitor(hkXmlParser& p, _In_ hkStreamReader* r, _In_ hkXmlParser::StartElement* s, Buffer& b, hkRelocationInfo& rl, _In_z_ const char* mn, _In_z_ const char* cn)
                        : parser(p), reader(r), startElement(s), buffer(b), reloc(rl), memberName(mn), className(cn) {}

                    hkXmlParser& parser;
                    hkStreamReader* reader;
                    hkXmlParser::StartElement* startElement;
                    Buffer& buffer;
                    hkRelocationInfo& reloc;
                    const char* memberName;
                    const char* className;

                    hkResult visit(_In_ const hkReflect::VoidType* member, int memberOffset) { HK_UNREACHABLE(0x6ec71760, "Void field found"); }
                    hkResult visit(_In_ const hkReflect::ValueType* member, int memberOffset) { HK_UNREACHABLE( 0x3d715fea, "Values should be handled in dispatch()" ); }

                    hkResult dispatch(_In_ const hkReflect::Type* member, int memberOffset)
                    {
                        if (const hk::Presets* presets = member->findAttribute<hk::Presets>())
                        {
                            if(member->getName() && hkString::strCmp(member->getName(), "hkFlags") == 0)
                            {
                                return handleFlags(member, presets, memberOffset);
                            }
                            return handleEnum(member, presets, memberOffset);
                        }

                        if (isPodMember(member))
                        {
                            hkStringBuf text; extractText(parser, reader, startElement, true, text);
                            hkIstream iss(text.cString(), text.getLength());
                            void* memberAddress = buffer.pointerAt(memberOffset);
                            return readSinglePodMember(member, memberAddress, iss);
                        }
                        return ParentType::dispatch(member, memberOffset);
                    }

                    hkResult visit(_In_opt_ const hkReflect::StringType* member, int memberOffset)
                    {
                        hkStringBuf text;
                        if (extractText(parser, reader, startElement, false, text))
                        {
                            
                            return extractCstring(memberOffset, text, buffer, reloc);
                        }
                        return HK_SUCCESS;
                    }

                    hkResult visit(_In_opt_ const hkReflect::PointerType* member, int memberOffset)
                    {
                        hkStringBuf text; extractText(parser, reader, startElement, true, text);
                        if (text != "null")
                        {
                            HK_WARN_ALWAYS(0xabba8761, "Cannot read " << className << "::" << memberName <<
                                ", pointers are not supported. Will be ignored");
                        }
                        return HK_SUCCESS;
                    }

                    hkResult visit(_In_ const hkReflect::ArrayType* member, int memberOffset)
                    {
                        if (!member->getSubType())
                        {
                            HK_WARN_ALWAYS(0xabba8760, "Cannot read " << className << "::" << memberName <<
                                ", variant arrays are not supported.");
                            return HK_FAILURE;
                        }

                        if (member->getFixedCount())
                        {
                            void* memberAddress = buffer.pointerAt(memberOffset);
                            int numElem = member->getFixedCount();
                            int elemSize = member->getSubType()->getSizeOf();
                            if (isPodMember(member->getSubType()))
                            {
                                hkStringBuf text; extractText(parser, reader, startElement, true, text);
                                hkIstream iss(text.cString(), text.getLength());
                                for (int i = 0; i < numElem; ++i)
                                {
                                    if (readSinglePodMember(member->getSubType(), memberAddress, iss).isFailure())
                                    {
                                        return HK_FAILURE;
                                    }
                                    memberAddress = addByteOffset(memberAddress, elemSize);
                                }
                            }
                            else
                            {
                                for (int i = 0; i < member->getFixedCount(); ++i)
                                {
                                    if (dispatch(member->getSubType(), memberOffset + i * elemSize).isFailure())
                                    {
                                        return HK_FAILURE;
                                    }
                                }
                            }
                        }
                        else
                        {
                            int numElements = -1;
                            int arrayBeginOffset = buffer.reserve(0);

                            if (member->getSubType()->asRecord())
                            {
                                const char* numElementsString = startElement->getAttribute("numelements", HK_NULL);
                                HK_ASSERT(0x3cbc5582, numElementsString != 0, "Could not find 'numelements' attribute in an array of structs.");
                                numElements = hkString::atoi(numElementsString);
                                const hkReflect::Type* sclass = member->getSubType();
                                int ssize = sclass->getSizeOf();
                                buffer.reserve(ssize * numElements, Buffer::PAD_16);
                                buffer.advance(ssize * numElements, Buffer::PAD_16);
                                for (int i = 0; i < numElements; ++i)
                                {
                                    hkXmlParser::Node* snode = HK_NULL;
                                    parser.nextNode(&snode, reader);
                                    readClassBody(sclass, arrayBeginOffset + i*ssize, buffer,
                                        snode->asStart(), parser, reader, reloc);
                                    delete snode;
                                }
                                // maybe peek and assert next is </hkparam>
                            }
                            else if (member->getSubType()->asString())
                            {
                                const char* numElementsString = startElement->getAttribute("numelements", HK_NULL);
                                HK_ASSERT(0x3cbc5582, numElementsString != 0, "Could not find 'numelements' attribute in an array of c-strings.");
                                numElements = hkString::atoi(numElementsString);
                                buffer.reserve(sizeof(char*) * numElements, Buffer::PAD_16);
                                buffer.advance(sizeof(char*) * numElements, Buffer::PAD_16);
                                for (int i = 0; i < numElements; ++i)
                                {
                                    hkXmlParser::Node* snode = HK_NULL;
                                    parser.nextNode(&snode, reader);
                                    HK_ASSERT(0x3acc8f13, snode->asStart() && snode->asStart()->name == "hkcstring", "Expected <hkcstring>");

                                    hkStringBuf text;
                                    if (extractText(parser, reader, startElement, false, text))
                                    {
                                        
                                        extractCstring(arrayBeginOffset + i*sizeof(char*), text, buffer, reloc);
                                    }
                                    // skip to next hkcstring
                                    delete snode;
                                    parser.nextNode(&snode, reader);
                                    HK_ASSERT(0x3acc8f13, snode->asEnd() && snode->asEnd()->name == "hkcstring", "Expected </hkcstring>");
                                    delete snode;
                                }
                            }
                            else
                            {
                                bool canonicalize = !member->getSubType()->asRecord();
                                hkStringBuf text; extractText(parser, reader, startElement, canonicalize, text);
                                if (member->getSubType()->asPointer())
                                {
                                    HK_WARN_ALWAYS(0xabba8762, "Cannot read " << className << "::" << memberName <<
                                        ", pointers are not supported. Will be ignored.");
                                }
                                else
                                {
                                    numElements = loadSimpleArray(member->getSubType(), text, buffer);
                                }
                            }

                            HK_ASSERT_NO_MSG(0x7ede835a, numElements >= 0);
                            HK_ASSERT_NO_MSG(0x7ede835b, member->getName());

                            if (hkString::strCmp(member->getName(), "hkRelArray") != 0)
                            {
                                
                                XmlObjectReader_DummyArray& dummy = lookupMember<XmlObjectReader_DummyArray>(buffer.pointerAt(memberOffset));
                                dummy.ptr = HK_NULL;
                                dummy.size = numElements;
                                if (numElements > 0)
                                {
                                    dummy.ptr = buffer.pointerAt(arrayBeginOffset);
                                }
                            }
                            else
                            {
                                hkRelArray<hkUint8>& dummy = lookupMember< hkRelArray<hkUint8> >(buffer.pointerAt(memberOffset));
                                dummy._setSize(static_cast<hkUint16>(numElements));
                                dummy._setOffset(0);
                                if (numElements > 0)
                                {
                                    // don't need relocation info for rel arrays, if the buffer is moved in memory the data will still be valid
                                    int offset = (arrayBeginOffset)-(memberOffset);
                                    HK_ASSERT_NO_MSG(0x4d984ae5, offset > 0);
                                    dummy._setOffset(static_cast<hkUint16>(offset));
                                }
                            }
                        }

                        return HK_SUCCESS;
                    }

                    hkResult handleEnum(_In_ const hkReflect::Type* member, _In_ const hk::Presets* presets, int memberOffset)
                    {
                        hkStringBuf text; extractText(parser, reader, startElement, false, text);
                        if (text.getLength())
                        {
                            hkReflect::IntVar val = presets->getPresetByName(text.cString());
                            if (!val)
                            {
                                HK_WARN(0x555b54ab, "Invalid enum string '" << text.cString() << "' found for '"
                                    << member->getName() << "' in member '" << memberName);
                            }
                            else
                            {
                                hkReflect::IntVar asInt = hkReflect::Var(buffer.pointerAt(memberOffset), member);
                                if (!asInt)
                                {
                                    HK_WARN_ALWAYS(0xabba8763, className << "::" << memberName <<
                                        " has presets but it is not an integer, will be ignored.");
                                }
                                else
                                {
                                    asInt.assign(val);
                                }
                            }
                        }
                        return HK_SUCCESS;
                    }

                    hkResult visit(_In_ const hkReflect::RecordType* member, int memberOffset)
                    {
                        hkXmlParser::Node* snode = HK_NULL;
                        parser.nextNode(&snode, reader);
                        if (hkXmlParser::StartElement* structStart = snode->asStart())
                        {
                            HK_ASSERTV(0x48b01b1e, structStart != HK_NULL && (structStart->name == "struct" || structStart->name == "hkobject"),
                                "Parse error, expected <struct> or <hkobject> after {].", startElement->name);

                            readClassBody(member, memberOffset,
                                buffer, structStart, parser, reader, reloc);
                            delete snode;
                        }
                        else
                        {
                            parser.putBack(snode);
                        }
                        return HK_SUCCESS;
                    }

                    hkResult handleFlags(_In_ const hkReflect::Type* member, _In_ const hk::Presets* presets, int memberOffset)
                    {
                        hkStringBuf stext; extractText(parser, reader, startElement, false, stext);
                        if (stext.getLength())
                        {
                            hkArray<char> text; text.setSize(stext.getLength() + 1); //copy for modification
                            hkString::strNcpy(text.begin(), text.getCapacity(), stext.cString(), stext.getLength() + 1);
                            char* cur = text.begin();
                            int accum = 0;
                            while (cur)
                            {
                                char* next = HK_NULL;
                                if (char* bar = const_cast<char*>(hkString::strChr(cur, '|')))
                                {
                                    *bar = 0; // bar = ptr to '|' separator
                                    next = bar + 1;
                                }
                                if (cur[0] >= '0' && cur[0] <= '9')
                                {
                                    int val = hkString::atoi(cur);
    #                            if defined(HK_DEBUG)
                                    if (val != 0)
                                    {
                                        const char* extraWarning = "'.";
                                        for (int i = 0; i < presets->getNumPresets(); ++i)
                                        {
                                            if (hkReflect::IntVar(presets->getPreset(i)).getValue().convertTo<hkInt64>() & val)
                                            {
                                                extraWarning = "'. Some bits conflict with reflected bits.";
                                                break;
                                            }
                                        }
                                        HK_WARN(0x555b54ac, "Unreflected bits found in flags - using them anyway. '"
                                            << cur << "' found for '" << member->getName() << "' in member '" << memberName
                                            << extraWarning);
                                    }
    #                            endif
                                    accum |= val;
                                }
                                else
                                {
                                    hkReflect::IntVar val = presets->getPresetByName(cur);
                                    if (val)
                                    {
                                        accum |= val.getValue().convertTo<hkInt64>();
                                    }
                                    else
                                    {
                                        HK_WARN(0x555b54ab, "Invalid flag string '" << cur << "' found for '"
                                            << member->getName() << "' in member '" << memberName);
                                    }
                                }
                                cur = next;
                            }
                            hkReflect::IntVar asInt = hkReflect::Var(buffer.pointerAt(memberOffset), member);
                            if (!asInt)
                            {
                                HK_WARN_ALWAYS(0xabba8763, className << "::" << memberName <<
                                    " has presets but it is not an integer, will be ignored.");
                            }
                            else
                            {
                                asInt.setValue(accum);
                            }
                        }
                        return HK_SUCCESS;
                    }
                } visitor(parser, reader, startElement, buffer, reloc, member.getName(), klass->getName());
                visitor.dispatch(member.getType(), classStartOffset + member.getOffset());


                if (consumeEndElement(parser, reader, startElement).isFailure())
                {
                    delete node;
                    break;
                }
            }
            else if (hkXmlParser::EndElement* ee = node->asEnd())
            {
                if (topElement && (ee->name == topElement->name))
                {
                    delete node;
                    return HK_SUCCESS;
                }
            }
            delete node;
        }
        return HK_FAILURE;
    }
}


hkResult readObject(_Inout_ hkStreamReader* reader, hkArray<char>& array, _In_ const hkReflect::Type* klass, hkRelocationInfo& reloc)
{
    HK_ON_DEBUG(char peekTmp = 0);
    HK_ASSERT(0x5412ce0d, reader->peek(&peekTmp, 1) == 1, "Stream needs to support marking");
    hkXmlParser::Node* node;
    Buffer buffer(array);
    hkResult result = HK_FAILURE;

    hkXmlParser parser;

    while (parser.nextNode(&node, reader).isSuccess())
    {
        if (hkXmlParser::StartElement* startElement = node->asStart())
        {
            if (startElement->name == "hkobject")
            {
                int objectStart = buffer.reserve(klass->getSizeOf(), Buffer::PAD_16);
                buffer.advance(klass->getSizeOf(), Buffer::PAD_16);
                reloc.addFinish( objectStart, klass->getName() );
                result = readClassBody(klass, objectStart, buffer, startElement, parser, reader, reloc);
            }
            else
            {
                HK_ASSERTV(0x5ae0b569, 0, "Unknown tag {}.", startElement->name);
            }
        }
        else if (hkXmlParser::Characters* characters = node->asCharacters())
        {
            characters->canonicalize();
            HK_ASSERTV(0x742a0073, characters->text.getLength() == 0, "unexpected characters {}", startElement->name);

        }
        else if (hkXmlParser::EndElement* endElement = node->asEnd())
        {
            HK_ASSERTV(0x46a5a10e, 0, "unexpected end node {}", endElement->name);
        }
        else
        {
            HK_ERROR(0x6a858ec3, "Unknown element type returned from XML parser.");
        }
        delete node;
        break;
    }
    return result;
}

hkReflect::Var HK_CALL hkCompatFormats::readOptionsXml(_In_reads_bytes_(optionDataSize) const void* optionData, const int optionDataSize, hkArray<char>& buffer, _In_ const hkReflect::Type* klass)
{
    hkIstream optionStream( optionData, optionDataSize );
    HK_ASSERT_NO_MSG( 0x5469fae1, optionStream.isOk() );

    hkStreamReader* reader = optionStream.getStreamReader();

    hkRelocationInfo ri;

    hkResult res = readObject( reader, buffer, klass, ri );

    if ( res.isSuccess() )
    {
        ri.applyLocalAndGlobal( buffer.begin() );
        return hkReflect::Var(buffer.begin(), klass);
    }

    return hkReflect::Var();
}

// HK_SINGLETON_IMPLEMENTATION is in hkProductFeatures.cxx

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
