// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64 !OSINTERNAL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

class hkClass;
class hkStreamWriter;

#include <Common/Base/Types/hkBaseTypes.h>

class hkClassEnum
{
    public:
        HK_DECLARE_CLASS(hkClassEnum, New);

            /// A single enumerated name and value pair.
        class Item
        {
            public:

                HK_DECLARE_CLASS(Item, New);

                Item() {}

                    /// Create a new enumerated item.
                Item( int v, const char* n) : m_value(v), m_name(n) { }

                    /// Get the name of this item.
                const char* getName() const { return m_name; }

                    /// Get the integer value of this item.
                int getValue() const { return m_value; }

            private:

                int m_value;
                hkStringPtr m_name;
        };

        enum FlagValues
        {
            FLAGS_NONE = 0
        };
        typedef hkFlags<FlagValues, hkUint32> Flags;

            /// Create an enumerated type.
        hkClassEnum(_In_z_ const char* name, _In_reads_(numItems) const Item* items, int numItems);

            /// Get the name of this type.
        _Ret_z_ const char* getName() const;

            /// Get the number of values of this enum.
        int getNumItems() const;

            /// Get the i'th item.
        const hkClassEnum::Item& getItem(int i) const;

            /// Get the name of the item with value val.
            /// Not to be confused with the i'th item.
        hkResult getNameOfValue( int val, _Outptr_result_z_ const char** name ) const;

            /// Get the value of the item named name (note: case insensitive).
            /// Not to be confused with the index of the item.
        hkResult getValueOfName(_In_z_ const char* name, _Out_ int* val) const;

            ///
        hkResult decomposeFlags( int flagValue, hkArray<const char*, hkContainerHeapAllocator>& bitsOut, int& bitsOver ) const;

            /// Get the enum signature for versioning.
        hkUint32 getSignature() const;

            /// Write the enum signature for versioning.
        void writeSignature(_Inout_ hkStreamWriter* w) const;

            ///
        _Ret_maybenull_ const hkVariant* getAttribute(_In_z_ const char* name) const;

            /// See the Flags enum for a description of flags.
        inline const Flags& getFlags() const;

            /// See the Flags enum for a description of flags.
        inline Flags& getFlags();

    private:

        hkStringPtr m_name;
        hkArray<Item> m_items;
        void* m_attributes;
        Flags m_flags;
};

#include <Common/Base/Serialize/Format/Compat/ContentTools/hkClassEnum.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
