// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL !OSINTERNAL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Serialize/Format/Compat/ContentTools/hkClassEnum.h>
#include <Common/Base/System/Io/OArchive/hkOArchive.h>
#include <Common/Base/System/Io/Writer/Crc/hkCrcStreamWriter.h>

hkResult hkClassEnum::decomposeFlags( int flagValue, hkArray<const char*>& bitsOut, int& bitsOver ) const
{
    HK_ASSERT_NO_MSG(0x79a2a032,0);
    return HK_FAILURE;
}

hkResult hkClassEnum::getNameOfValue( int val, _Outptr_result_z_ const char** name ) const
{
    HK_ASSERT_NO_MSG(0x1564a37a,0);
    return HK_FAILURE;
}

hkResult hkClassEnum::getValueOfName(_In_z_ const char* name, _Out_ int* val) const
{
    HK_ASSERT_NO_MSG(0x1ef39c47,0);
    return HK_FAILURE;
}

hkUint32 hkClassEnum::getSignature() const
{
    hkCrc32StreamWriter crc;
    writeSignature(&crc);
    return crc.getCrc();
}

void hkClassEnum::writeSignature(_Inout_ hkStreamWriter* w ) const
{
    hkOArchive oa(w);
    oa.writeRaw( getName(), hkString::strLen(getName()) );
    int numItem = getNumItems();

    for( int j = 0; j < numItem; ++j )
    {
        const Item& item = getItem(j);
        oa.writeRaw( item.getName(), hkString::strLen(item.getName()));
        int val = item.getValue();
        oa.write32( val );
    }
    oa.write32( numItem );
}

_Ret_maybenull_ const hkVariant* hkClassEnum::getAttribute(_In_z_ const char* id) const
{
    return HK_NULL;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
