// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64 !OSINTERNAL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Serialize/Format/Compat/ContentTools/hkClass.h>
#include <Common/Base/System/Io/OArchive/hkOArchive.h>
#include <Common/Base/System/Io/Writer/Crc/hkCrcStreamWriter.h>
//#include <Common/Base/Types/hkTypedUnion.h>

hkClass::hkClass(_In_z_ const char* className,
                _In_opt_ const hkClass* parentClass,
                int objectSizeInBytes,
                _In_opt_ const hkClass** implementedInterfaces,
                int numImplementedInterfaces,
                _In_reads_opt_(numDeclaredEnums) const hkClassEnum* declaredEnums,
                int numDeclaredEnums,
                _In_reads_opt_(numMembers) const hkClassMember* members,
                int numMembers,
                _In_opt_ const void* defaults,
                _In_opt_ const void* attrs,
                hkUint32 flags,
                hkUint32 version )
    :    m_name(className),
        m_parent(parentClass),
        m_objectSize(objectSizeInBytes),
        //m_implementedInterfaces(implementedInterfaces),
        m_numImplementedInterfaces(numImplementedInterfaces),
        m_declaredEnums( declaredEnums ),
        m_numDeclaredEnums( numDeclaredEnums ),
        m_declaredMembers(members),
        m_numDeclaredMembers(numMembers),
        m_defaults(defaults),
        m_attributes(attrs),
        m_flags(flags),
        m_describedVersion(version)
{
#if defined(HK_DEBUG_SLOW)
    for( int i = 1; i < numMembers; ++i )
    {
        // assert offsets are increasing, except for all zero offsets (as in hkcompat)
        if( (members[i].getOffset() != 0 || members[i-1].getOffset() != 0 )
        &&  (members[i].getOffset() <= members[i-1].getOffset()) ) // normal HK_OFFSET_OF
        {
            // cannot assert as usually these are statically initialized.
            HK_BREAKPOINT(0); //    Reflected member order must match declared order.
        }
    }
#endif
}

_Ret_z_ const char* hkClass::getName() const
{
    return m_name;
}

//
//    Compares this class with other by name. Returns true if the classes have the same name

bool hkClass::equals(_In_opt_ const hkClass* other) const
{
    if ( other == HK_NULL )
    {
        return false;
    }

    return    ( this == other ) ||
            ( hkString::strCmp( getName(), other->getName() ) == 0 );
}

_Ret_maybenull_ const hkClass* hkClass::getParent() const
{
    return m_parent;
}

_Ret_maybenull_ hkClass* hkClass::getParent()
{
    return const_cast<hkClass*>(m_parent);
}

int hkClass::getInheritanceDepth() const
{
    int depth = 0;
    const hkClass* c = this;
    while( c != HK_NULL )
    {
        ++depth;
        c = c->m_parent;
    }
    return depth;
}

hkBool hkClass::isSuperClass(const hkClass& k) const
{
    const hkClass* c = &k;
    while( c )
    {
        if ( 0 == hkString::strCmp( c->getName(), this->getName() ))
        
        {
            return true;
        }
        c = c->getParent();
    }
    return false;
}

#define RETURN_SUM_MEMBERS(MEMBER) \
    const hkClass* c = this->m_parent; \
    int RETURN = MEMBER; \
    while( c ) \
    { \
        RETURN += c->MEMBER; \
        c = c->m_parent; \
    } \
    return RETURN

int hkClass::getNumInterfaces() const
{
    RETURN_SUM_MEMBERS(m_numImplementedInterfaces);
}

_Ret_maybenull_ const hkClass* hkClass::getInterface( int i ) const
{
    return HK_NULL;
}

_Ret_maybenull_ const hkClass* hkClass::getDeclaredInterface( int i ) const
{
    return HK_NULL;
}

int hkClass::getNumDeclaredInterfaces() const
{
    return m_numImplementedInterfaces;
}

int hkClass::getNumEnums() const
{
    RETURN_SUM_MEMBERS(m_numDeclaredEnums);
}

const hkClassEnum& hkClass::getEnum(int enumIndex) const
{
    int numEnums = getNumEnums();
    HK_ASSERT_NO_MSG(0x275d8b19, enumIndex >= 0 && enumIndex < numEnums );
    const hkClass* c = this;
    int localIndex = enumIndex - numEnums;
    while( c )
    {
        localIndex += c->m_numDeclaredEnums;
        if( localIndex >= 0 )
        {
            return c->m_declaredEnums[localIndex];
        }
        c = c->m_parent;
    }
    HK_ASSERT(0x1036239f, 0, "notreached");
    return m_declaredEnums[0];
}

_Ret_maybenull_ const hkClassEnum* hkClass::getEnumByName(_In_z_ const char* name) const
{
    for( int i = 0; i < getNumEnums(); ++i)
    {
        const hkClassEnum& e = getEnum(i);
        if( hkString::strCmp(e.getName(), name) == 0)
        {
            return &e;
        }
    }
    return HK_NULL;
}

_Ret_maybenull_ const hkClassEnum* hkClass::getDeclaredEnumByName(_In_z_ const char* name) const
{
    for( int i = 0; i < getNumDeclaredEnums(); ++i)
    {
        const hkClassEnum& e = getDeclaredEnum(i);
        if( hkString::strCmp(e.getName(), name) == 0)
        {
            return &e;
        }
    }
    return HK_NULL;
}

const hkClassEnum& hkClass::getDeclaredEnum(int enumIndex) const
{
    HK_ASSERT_NO_MSG(0x275d8b19, enumIndex >= 0 && enumIndex < getNumDeclaredEnums() );
    return m_declaredEnums[enumIndex];
}

int hkClass::getNumDeclaredEnums() const
{
    return m_numDeclaredEnums;
}

int hkClass::getNumMembers() const
{
    RETURN_SUM_MEMBERS(m_numDeclaredMembers);
}

const hkClassMember& hkClass::getMember(int memberIndex) const
{
    int numMembers = getNumMembers();
    HK_ASSERT_NO_MSG(0x275d8b19, memberIndex >= 0 && memberIndex < numMembers );
    const hkClass* c = this;
    int localIndex = memberIndex - numMembers;
    while( c )
    {
        localIndex += c->m_numDeclaredMembers;
        if( localIndex >= 0 )
        {
            return c->m_declaredMembers[localIndex];
        }
        c = c->m_parent;
    }
    HK_ASSERT(0x1036239f, 0, "notreached");
    return m_declaredMembers[0];
}

hkClassMember& hkClass::getMember(int memberIndex)
{
    const hkClass* constThis = this;
    return const_cast<hkClassMember&>( constThis->getMember(memberIndex) );
}

int hkClass::getNumDeclaredMembers() const
{
    return m_numDeclaredMembers;
}

const hkClassMember& hkClass::getDeclaredMember(int i) const
{
    HK_ASSERT_NO_MSG(0x39d720db, i>=0 && i < m_numDeclaredMembers);
    return m_declaredMembers[i];
}

_Ret_maybenull_ const hkClassMember* hkClass::getDeclaredMemberByName(_In_z_ const char* name) const
{
    for( int i = 0; i < getNumDeclaredMembers(); ++i)
    {
        const hkClassMember& m = getDeclaredMember(i);
        if( hkString::strCmp(m.getName(), name) == 0)
        {
            return &m;
        }
    }
    return HK_NULL;
}

_Ret_maybenull_ const hkClassMember* hkClass::getMemberByName(_In_z_ const char* name) const
{
    for( int i = 0; i < getNumMembers(); ++i)
    {
        const hkClassMember& m = getMember(i);
        if( hkString::strCmp(m.getName(), name) == 0)
        {
            return &m;
        }
    }
    return HK_NULL;
}

int hkClass::getMemberIndexByName(const char* name) const
{
    for( int i = 0; i < getNumMembers(); ++i)
    {
        const hkClassMember& m = getMember(i);
        if( hkString::strCmp(m.getName(), name) == 0)
        {
            return i;
        }
    }
    return -1;
}

// Case insensitive version for get member. Used by Max exporter, due to some weird max behavior regarding symbol names
int hkClass::getMemberIndexByNameCaseInsensitive(_In_z_ const char* name) const
{
    for( int i = 0; i < getNumMembers(); ++i)
    {
        const hkClassMember& m = getMember(i);
        if( hkString::strCasecmp(m.getName(), name) == 0)
        {
            return i;
        }
    }
    return -1;
}

int hkClass::getDeclaredMemberIndexByName(_In_z_ const char* name) const
{
    for( int i = 0; i < getNumDeclaredMembers(); ++i)
    {
        const hkClassMember& m = getDeclaredMember(i);
        if( hkString::strCmp(m.getName(), name) == 0)
        {
            return i;
        }
    }
    return -1;
}

int hkClass::getObjectSize() const
{
    return m_objectSize;
}

void hkClass::setObjectSize(int size)
{
    m_objectSize = size;
}

hkBool hkClass::hasVtable() const
{
    const hkClass* c = this;
    while(c->getParent())
    {
        c = c->getParent();
    }
    HK_ON_DEBUG(int v = getNumInterfaces());
    int i = c->m_numImplementedInterfaces;
    HK_ASSERT(0x279061ac, (i==0 && v==0) || (i!=0 && v!=0), "Vtable is not in base class.");
    return i != 0;
}

hkUint32 hkClass::getSignature(int signatureFlags) const
{
    hkCrc32StreamWriter crc;
    bool recurse = (signatureFlags & SIGNATURE_LOCAL)==0;
    const hkClass* c = this;
    while( c )
    {
        c->writeSignature(&crc);
        c = recurse ? c->getParent() : HK_NULL;
    }

    return crc.getCrc();
}

int hkClass::getDescribedVersion() const
{
    return m_describedVersion;
}

// This buffer is used for pretend zero-value defaults
// 64 bytes is enough to hold the largest defaultable type (hkTransform)
static const char s_defaultClassBuffer[64] =
    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

hkResult hkClass::retrieveMember(int memberIndex, const void*& defaultOut, const hkClassMember*& memberOut) const
{
    int numMembers = getNumMembers();
    HK_ASSERT_NO_MSG(0x275d8b19, memberIndex >= 0 && memberIndex < numMembers );
    const hkClass* c = this;
    int localIndex = memberIndex - numMembers;
    while( c )
    {
        localIndex += c->m_numDeclaredMembers;
        if( localIndex >= 0 )
        {
            if( c->m_defaults )
            {
                int defIndex = reinterpret_cast<const int*>(c->m_defaults)[localIndex];
                if((defIndex >= 0 ) || (defIndex == hkClassMember::HK_CLASS_ZERO_DEFAULT))
                {
                    defaultOut = (defIndex == hkClassMember::HK_CLASS_ZERO_DEFAULT ? static_cast<const char *>(s_defaultClassBuffer) : static_cast<const char*>(c->m_defaults)+defIndex);
                    memberOut = &(c->m_declaredMembers[localIndex]);
                    return HK_SUCCESS;
                }
            }
            break;
        }
        c = c->m_parent;
    }
    return HK_FAILURE;
}

hkBool32 hkClass::hasDefault(int memberIndex) const
{
    const void* defaultPtr;
    const hkClassMember* member;
    return retrieveMember(memberIndex, defaultPtr, member).isSuccess();
}

hkBool32 hkClass::hasDeclaredDefault(int declaredIndex) const
{
    HK_ASSERT_NO_MSG(0x3f24c58c, 0 <= declaredIndex && declaredIndex < getNumDeclaredMembers());
    return m_defaults && ((reinterpret_cast<const int*>(m_defaults)[declaredIndex] >= 0)
                            || (reinterpret_cast<const int*>(m_defaults)[declaredIndex] == hkClassMember::HK_CLASS_ZERO_DEFAULT));
}

_Ret_maybenull_ const void* hkClass::getDefault(int memberIndex) const
{
    const void* defaultPtr = HK_NULL;
    const hkClassMember* member = HK_NULL;
    hkResult res = retrieveMember(memberIndex, defaultPtr, member);
    if( res.isSuccess() )
    {
        return defaultPtr;
    }
    return HK_NULL;
}

hkResult hkClass::getDefault(int memberIndex, _Inout_ hkStreamWriter* writer) const
{
    const void* defaultPtr = HK_NULL;
    const hkClassMember* member = HK_NULL;
    hkResult res = retrieveMember(memberIndex, defaultPtr, member);
    if( res.isSuccess() )
    {
        HK_ASSERT(0x3f24c18c, member->getType() != hkClassMember::TYPE_STRUCT, "struct not supported");
        writer->write( defaultPtr, member->getSizeInBytes() );
    }
    return res;
}

hkResult hkClass::getDeclaredDefault(int declaredIndex, _Inout_ hkStreamWriter* writer) const
{
    HK_ASSERT_NO_MSG(0x3f24c08c, 0 <= declaredIndex && declaredIndex < getNumDeclaredMembers());
    if( m_defaults )
    {
        int defIndex = reinterpret_cast<const int*>(m_defaults)[declaredIndex];
        if( (defIndex >= 0) || (defIndex == hkClassMember::HK_CLASS_ZERO_DEFAULT))
        {
            const void* defaultPtr = (defIndex == hkClassMember::HK_CLASS_ZERO_DEFAULT ? static_cast<const char*>(s_defaultClassBuffer) : static_cast<const char*>(m_defaults) + defIndex);
            const hkClassMember& member = m_declaredMembers[declaredIndex];
            HK_ASSERT(0x3f24c28c, member.getType() != hkClassMember::TYPE_STRUCT, "struct not supported");

            writer->write( defaultPtr, member.getSizeInBytes() );
            return HK_SUCCESS;
        }
    }
    return HK_FAILURE;
}

hkResult hkClass::getDefault(int memberIndex, hkTypedUnion& value) const
{
    return HK_FAILURE;
}


_Ret_maybenull_ const void* hkClass::getDeclaredDefault(int declaredIndex) const
{
    HK_ASSERT_NO_MSG(0x3f24c48c, 0 <= declaredIndex && declaredIndex < getNumDeclaredMembers());
    if( m_defaults )
    {
        int defIndex = reinterpret_cast<const int*>(m_defaults)[declaredIndex];
        if( (defIndex >= 0) || (defIndex == hkClassMember::HK_CLASS_ZERO_DEFAULT) )
        {
            return (defIndex == hkClassMember::HK_CLASS_ZERO_DEFAULT ? static_cast<const char*>(s_defaultClassBuffer) : static_cast<const char*>(m_defaults) + defIndex);
        }
    }
    return HK_NULL;
}

hkResult hkClass::getDeclaredDefault(int declaredIndex, hkTypedUnion& value) const
{
    return HK_FAILURE;
}


void hkClass::writeSignature( _Inout_ hkStreamWriter* w ) const
{
    HK_ASSERT_NO_MSG(0x75f6a8af, 0);
}

_Ret_maybenull_ const hkVariant* hkClass::getAttribute(_In_z_ const char* id) const
{
    return HK_NULL;
}

const hkClass::Flags& hkClass::getFlags() const
{
    return m_flags;
}

hkClass::Flags& hkClass::getFlags()
{
    return m_flags;
}


extern const hkClass hkClassEnumClass("hkClassEnum", HK_NULL, 0, HK_NULL, 0, HK_NULL, 0, HK_NULL, 0, HK_NULL, HK_NULL, 0, 0);
extern const hkClass hkClassEnumItemClass("hkClassEnumItem", HK_NULL, 0, HK_NULL, 0, HK_NULL, 0, HK_NULL, 0, HK_NULL, HK_NULL, 0, 0);
extern const hkClass hkClassMemberClass("hkClassMember", HK_NULL, 0, HK_NULL, 0, HK_NULL, 0, HK_NULL, 0, HK_NULL, HK_NULL, 0, 0);
extern const hkClass hkClassClass("hkClass", HK_NULL, 0, HK_NULL, 0, HK_NULL, 0, HK_NULL, 0, HK_NULL, HK_NULL, 0, 0);
extern const hkClass hkReferencedObjectClass("hkReferencedObject", HK_NULL, 0, HK_NULL, 0, HK_NULL, 0, HK_NULL, 0, HK_NULL, HK_NULL, 0, 0);

void HK_CALL hkBaseRegister()
{

}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
