// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64 !OSINTERNAL REFLECT
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Container/String/Deprecated/hkStringOld.h>
#include <Common/Base/Reflect/Util/hkReflectAny.h>

/// This class stores a set of filter configurations,
/// and handles loading/saving of that data
class hctFilterConfigurationSet20151
{
    public:

        /// Structure describing a single filter stage
        struct FilterStage
        {
            HK_DECLARE_CLASS(FilterStage, New, Reflect);

            // Change the name so that it will be saved/loaded as the original class.
            HK_RECORD_ATTR(hk::Rename(hctFilterConfigurationSet::FilterStage));
            HK_RECORD_ATTR(hk::RegisterType(false));
            HK_RECORD_ATTR(hk::IncludeInMgd(false));

            unsigned int    m_filterId;
            unsigned int    m_optionDataVersion;    // version of the filter that saved the options 
            hkReflect::Any    m_options;
        };

        /// Structure describing a single configuration of multiple filters
        struct Configuration
        {
            HK_DECLARE_CLASS(Configuration, New, Reflect);

            // Change the name so that it will be saved/loaded as the original class.
            HK_RECORD_ATTR(hk::Rename(hctFilterConfigurationSet::Configuration));
            HK_RECORD_ATTR(hk::RegisterType(false));
            HK_RECORD_ATTR(hk::IncludeInMgd(false));

            hkStringPtr                m_configName;
            hkArray<FilterStage>    m_filterStages;
        };


        HK_DECLARE_CLASS(hctFilterConfigurationSet20151, New, Reflect);

        // Change the name so that it will be saved/loaded as the original class.
        HK_RECORD_ATTR(hk::Rename(hctFilterConfigurationSet));
        HK_RECORD_ATTR(hk::RegisterType(false));
        HK_RECORD_ATTR(hk::IncludeInMgd(false));

        /// The set of configurations
        hkArray<Configuration> m_configurations;
        int m_currentIndex;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
