// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64 !OSINTERNAL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Serialize/Format/Compat/ContentTools/hctClothSetupObjectData.h>

/// Contains the options used for the Cloth Data Options post 2013.3
class hctClothSetupClothData20151Options : public hkReferencedObject
{
public:

    HK_DECLARE_CLASS(hctClothSetupClothData20151Options, New, Reflect);

    // Change the name so that it will be saved/loaded as the original class.
    HK_RECORD_ATTR(hk::Rename(hctClothSetupClothData20141Options));
    HK_RECORD_ATTR(hk::RegisterType(false));
    HK_RECORD_ATTR(hk::IncludeInMgd(false));

    hkStringPtr m_name;

    // owns all data, will remove ref on exit
    int m_currentState;
    int m_defaultState;

    hkArray< hctClothSetupObjectData20151* > m_setupMeshes;
    hkArray< hctClothSetupObjectData20151* > m_simSetupMeshes;
    hkArray< hctClothSetupObjectData20151* > m_buffers;
    hkArray< hctClothSetupObjectData20151* > m_simCloth;
    hkArray< hctClothSetupObjectData20151* > m_operators;
    hkArray< hctClothSetupObjectData20151* > m_transformSets;
    hkArray< hctClothSetupObjectData20151* > m_simClothConstraints;
    hkArray< hctClothSetupObjectData20151* > m_clothStates;

    virtual ~hctClothSetupClothData20151Options()
    {
        deleteArray(m_setupMeshes);
        deleteArray(m_simSetupMeshes);
        deleteArray(m_buffers);
        deleteArray(m_simCloth);
        deleteArray(m_operators);
        deleteArray(m_transformSets);
        deleteArray(m_simClothConstraints);
        deleteArray(m_clothStates);
    }

    static void deleteArray(hkArray<hctClothSetupObjectData20151*>& arr)
    {
        for (int i = 0; i < arr.getSize(); ++i)
        {
            arr[i]->removeReference();
        }
        arr.clear();
    }
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
