// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64 !OSINTERNAL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Serialize/Format/Compat/ContentTools/hctClothSetupClothData20141Options.h>

/// Contains the options used for the Set Radius filter
class hctClothSetup20151Options : public hkReferencedObject
{
public:

    HK_DECLARE_CLASS(hctClothSetup20151Options, New, Reflect);

    // Change the name so that it will be saved/loaded as the original class.
    HK_RECORD_ATTR(hk::Rename(hctClothSetup20141Options));
    HK_RECORD_ATTR(hk::RegisterType(false));
    HK_RECORD_ATTR(hk::IncludeInMgd(false));

    hkArray< hctClothSetupClothData20151Options* > m_clothData;

    virtual ~hctClothSetup20151Options()
    {
        for (int i = 0; i < m_clothData.getSize(); ++i)
        {
            m_clothData[i]->removeReference();
        }
    }
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
