// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64 !OSINTERNAL REFLECT
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Types/hkScopedPtr.h>

    /// An attribute description object contains information about an attribute that can be used by
    /// an exporter to complement the data given by the modeler regarding that attribute. This is useful
    /// in order to support attribute types and hints not natively supported by the modeler.
struct hctAttributeDescription20151
{
    HK_DECLARE_CLASS(hctAttributeDescription20151, New, Reflect);
    // Change the name so that it will be saved/loaded as the original class.
    HK_RECORD_ATTR(hk::Rename(hctAttributeDescription));
    HK_RECORD_ATTR(hk::RegisterType(false));
    HK_RECORD_ATTR(hk::IncludeInMgd(false));

        /// Name of the attribute we are describing
    hkStringPtr m_name;

        /// If a boolean attribute with the given name is not set to true, then this attribute is ignored.
        /// Note: From 4.0, attributes are usually automatically enabled/disabled if another bool/int attribute named
        /// "changeXXX" (where XXX is the name of this attribute) is found. This is done in hctAttributeProcessingUtil::processAttributeGroup().
    hkStringPtr m_enabledBy;

        /// Sometimes the modeler may use a type that doesn't match the expected final type.
        /// We can force a conversion by specifying one of these enums in m_forceType.
    enum ForcedType
    {
        LEAVE,
        FORCE_BOOL,
        FORCE_INT,
        FORCE_ENUM,
        FORCE_FLOAT,
        FORCE_STRING,
        FORCE_VECTOR,
        FORCE_MATRIX,
        FORCE_QUATERNION,
    } HK_ATTR(hk::Rename(hctAttributeDescription::ForcedType), hk::RegisterType(false));

        /// (Possibly) force this attribute to be of the given type.
    hkEnum<ForcedType,hkInt8> m_forcedType;

    class Enum
    {
        public:
            HK_DECLARE_CLASS(Enum, New, Reflect);

            // Change the name so that it will be saved/loaded as the original class.
            HK_RECORD_ATTR(hk::Rename(hctAttributeDescription::Enum));
            HK_RECORD_ATTR(hk::RegisterType(false));

            class Item
            {
                public:
                    HK_DECLARE_CLASS(Item, New, Reflect);
                    // Change the name so that it will be saved/loaded as the original class.
                    HK_RECORD_ATTR(hk::Rename(hctAttributeDescription::Enum::Item));
                    HK_RECORD_ATTR(hk::RegisterType(false));

                    int m_value;
                    hkStringPtr m_name;
            };

            hkStringPtr m_name;
            hkArray<Item> m_items;
    };

        /// For attributes with FORCE_ENUM, this describes the enum used for the given attribute.
    hkScopedPtr<Enum> m_enum;

        // Note : There should be a one to one mapping between this enum and the hkxattrib enum (serialization
        // doesn't like referencing it from here)

        /// This hint specifies extra information for the attribute; in particular, for numeric (float, vector) attributes
        /// it describes how it should be transformed if the scene is transformed.
    enum Hint
    {
            /// No hint
        HINT_NONE = 0,
            /// This attribute should be ignored.
        HINT_IGNORE = 1,
            /// This attribute should be fully transformed (rotated) but not scaled; it is a direction.
        HINT_TRANSFORM = 2,
            /// This attribute should be scaled; it is a distance.
        HINT_SCALE = 4,
            /// This attribute should be fully transformed and scaled; it is a position.
        HINT_TRANSFORM_AND_SCALE= 6,
            /// This attribute should be flipped upon handness flip; it is an angle.
        HINT_FLIP = 8
    } HK_ATTR(hk::Rename(hctAttributeDescription::Hint), hk::RegisterType(false));

        /// Want to know if it has a special meaning or usage
    hkEnum<Hint,hkInt8> m_hint;

        /// If true, the above hint(s) will override any previous hints - otherwise they will be OR-ed
    hkBool m_clearHints;

        /// Float attributes will be scaled by this value. It used to transform degrees into radians (in XSI)
    float m_floatScale;
};

HK_REFLECT_ENUM(, hctAttributeDescription20151::ForcedType);
HK_REFLECT_ENUM(, hctAttributeDescription20151::Hint);

    /// hctAttributeDescription20151 objects are grouped in hctAttributeGroupDescription20151 objects,
    /// just as hkxAttribute objects are grouped in hkxAttributeGroup objects.
struct hctAttributeGroupDescription20151
{
    HK_DECLARE_CLASS(hctAttributeGroupDescription20151, New, Reflect);
    // Change the name so that it will be saved/loaded as the original class.
    HK_RECORD_ATTR(hk::Rename(hctAttributeGroupDescription));
    HK_RECORD_ATTR(hk::RegisterType(false));
    HK_RECORD_ATTR(hk::IncludeInMgd(false));

        /// The name of the attribute group description (should match the name of the hkxAttributeGroup it describes).
        /// For example: "hkRigidBody"
    hkStringPtr m_name;

        /// The array of hctAttributeDescription20151 objects in this group.
    hkArray<hctAttributeDescription20151> m_attributeDescriptions;
};

    /// An hctAttributeDescriptionDatabase20151 object stores descriptions for all attributes and attribute groups.
    /// It contains an array of hctAttributeGroupDescription20151 objects.
struct hctAttributeDescriptionDatabase20151
{
    HK_DECLARE_CLASS(hctAttributeDescriptionDatabase20151, New, Reflect)
    // Change the name so that it will be saved/loaded as the original class.
    HK_RECORD_ATTR(hk::Rename(hctAttributeDescriptionDatabase));
    HK_RECORD_ATTR(hk::RegisterType(false));
    HK_RECORD_ATTR(hk::IncludeInMgd(false));

        /// The array of hctAttributeGroupDescription20151 objects in the database.
    hkArray<hctAttributeGroupDescription20151> m_groupDescriptions;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
