// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

hkLong hkIo::WriteBuffer::writeRaw(_In_reads_bytes_(n) const void* p, hkLong n)
{
    void* e = hkAddByteOffset(m_state.m_cur, n);
    if( e <= m_state.m_end)
    {
        hkMemUtil::memCpy(m_state.m_cur, p, n);
        m_state.m_cur = e;
        return n;
    }
    else
    {
        return implWriteRaw(p,n);
    }
}

hkLong hkIo::WriteBuffer::writeRaw(hkArrayView<const void> a)
{
    return writeRaw(a.begin(), a.getSize());
}


hkLong hkIo::WriteBuffer::writeRawAt(hkLong off, _In_reads_bytes_(n) const void* p, hkLong n)
{
    HK_ASSERT(0x2c8d4144, off >= 0, "Offset greater than 0");
    HK_ASSERT(0x5cea5a4e, n >= 0, "Size greater than 0");

    const hkLong roff = off - m_state.m_offsetAtStart;
    if( roff >= 0 && n >= 0 && hkAddByteOffset(m_state.m_start, roff + n) <= m_state.m_end)
    {
        void* pos = hkAddByteOffset(m_state.m_start, roff);
        hkMemUtil::memCpy(pos, p, n);
        return n;
    }
    else
    {
        return implWriteRawAt(off, p,n);
    }
}


_Ret_notnull_ void* hkIo::WriteBuffer::expandBy(hkLong n)
{
    void* e = hkAddByteOffset(m_state.m_cur, n);
    if( e <= m_state.m_end)
    {
        void* c = m_state.m_cur;
        m_state.m_cur = e;
        return c;
    }
    else
    {
        return implExpandBy(n);
    }
}

template<typename DST, typename SRC>
void hkIo::WriteBuffer::writePod(const SRC& s )
{
    DST d = hkLosslessCast<DST>(s);
    this->writeRaw(&d,sizeof(d));
}


template<typename DST, typename SRC>
void hkIo::WriteBuffer::writePodAt(hkLong off, const SRC& s )
{
    DST d = hkLosslessCast<DST>(s);
    this->writeRawAt(off, &d,sizeof(d));
}


template<typename DST, typename SRC>
void hkIo::WriteBuffer::writeObj(const SRC& s )
{
    DST(s).write(*this);
}

hkResult hkIo::WriteBuffer::rewind(hkLong amount)
{
    void* e = hkAddByteOffset(m_state.m_cur, -amount);
    if (e < m_state.m_start)
    {
        return HK_FAILURE;
    }

    if (e > m_state.m_end)
    {
        return HK_FAILURE;
    }

    m_state.m_cur = e;
    return HK_SUCCESS;
}

bool hkIo::WriteBuffer::isOk() const
{
    return m_state.m_okay;
}

void hkIo::WriteBuffer::forceNotOk()
{
    m_state.setValid(false);
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
