// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

    /// Unsigned variable length integer.
    /// We only need to peek at the first byte to decide how to process the rest of the input.
    /// One other curiosity of this format is that the integer is a valid big-endian integer
    /// once the prefix control bits are masked off.
class HK_EXPORT_COMMON hkUintVle
{
    public:

            /// Construct
        hkUintVle( hkUint64 i ) : m_i(i) {}

            /// Conversion
        template<typename T>
        operator T() const
        {
            return hkLosslessCast<T>(m_i);
        }

            /// Return the number of bytes required to store this value.
        int numBytesNeeded() const;

            /// Decode a uint64 at "p".
            /// This method may access up to 9 bytes at "p", regardless of how many actually contribute to the value.
            /// i.e. dereferencing p[8] must be safe.
            /// on error, nOut will be set to 0
            /// on success, nOut will be in the inclusive range [1; MAX_BYTE_COUNT]
        static hkUint64 read(_In_reads_bytes_(9) const hkUint8* p, int& nOut);

            /// Encode to a buffer. Returns the number of bytes used.
        int write(_Out_writes_bytes_(9) hkUint8* pOut) const;

            /// Encode a signed value into an unsigned one.
            /// Use this instead of bitcasting to u64 so that small negative values have small encodings.
        static hkUintVle encodeSigned(hkInt64 s);
            /// Reverse the process of encodeSigned.
        static hkInt64 decodeSigned(hkUintVle v);

            /// The largest a vle integer can get is sizeof(uint64) + one byte prefix
        static const int MAX_BYTE_COUNT = 9;

    private:

        hkUint64 m_i;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
