// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/Serialize/Detail/hkUintVle.h>
#include <Common/Base/Types/hkBinaryConst.h>
#include <Common/Base/Types/hkEndian.h>
#include <Common/Base/Fwd/hkcstring.h>

template<int NB>
static HK_ALWAYS_INLINE hkUint64 shift(hkUint64 u)
{
    return u >> ((8-NB) * 8);
}

hkUint64 hkUintVle::read(_In_reads_bytes_(9) const hkUint8* p, int& nOut)
{
    unsigned p0 = p[0];
    if( (p0 & HK_BINARY_8(10000000)) == 0 )
    {
        nOut = 1;
        return p0;
    }
    else
    {
        #if defined(HK_ARCH_INTEL) && 0//ARCH_SUPPORT_UNALIGNED_LOADS
        const hkUint64Be& ube = *reinterpret_cast<const hkUint64Be*>(p);
        #else
        hkUint64Be ube; HK_STD_NAMESPACE::memcpy(&ube, p, sizeof(hkUint64Be)); // not hkString::memCpy, this needs to be inlined.
        #endif

        hkUint64 ret = ube;
        int nb = 0;
        switch(p0 >> 3)
        {
            default:
                return 0;
            case HK_BINARY_8(10000):
            case HK_BINARY_8(10001):
            case HK_BINARY_8(10010):
            case HK_BINARY_8(10011):
            case HK_BINARY_8(10100):
            case HK_BINARY_8(10101):
            case HK_BINARY_8(10110):
            case HK_BINARY_8(10111):
            {
                nb = 2;
                ret = shift<2>(ret);
                ret &= (1ull<<14)-1; //14 bit
                break;
            }
            case HK_BINARY_8(11000):
            case HK_BINARY_8(11001):
            case HK_BINARY_8(11010):
            case HK_BINARY_8(11011):
            {
                nb = 3;
                ret = shift<3>(ret);
                ret &= (1ull << 21) - 1; // 21bit
                break;
            }
            case HK_BINARY_8(11100):
            {
                nb = 4;
                ret = shift<4>(ret);
                ret &= (1ull << 27) - 1; // 27bit
                break;
            }
            case HK_BINARY_8(11101):
            {
                nb = 5;
                ret = shift<5>(ret);
                ret &= (1ull << 35) - 1; // 35bit
                break;
            }
            case HK_BINARY_8(11110):
            {
                nb = 8;
                ret &= (1ull << 59) - 1; // 59bit
                break;
            }
            case HK_BINARY_8(11111):
            {
                switch( p[0] & 0x7)
                {
                    case 0x0:
                        nb = 6;
                        ret = shift<6>(ret);
                        ret &= (1ull << 40) - 1; // 40bit
                        break;
                    case 0x1:
                        nb = 9;
                        // full 64 bit value, no shift/mask needed
#if !defined(HK_ARCH_INTEL)
                        // Unaligned load not supported
                        HK_STD_NAMESPACE::memcpy(&ube, p+1, 8);
                        ret = ube;
#else
                        ret = *reinterpret_cast<const hkUint64Be*>(p+1);
#endif
                        break;
                    default:
                        // invalid but do not assert (corrupted data)
                        nOut = 0;
                        return 0;
                }
                break;
            }
        }
        nOut = nb;
        return ret;
    }
}


int hkUintVle::numBytesNeeded() const
{
    hkUint8 buf[MAX_BYTE_COUNT];
    return this->write(buf);
}


int hkUintVle::write(_Out_writes_bytes_(9) hkUint8* p) const
{
    #define FITS(i,b) ((i)<(1ull<<(b)))
    //  See http://www.dlugosz.com/ZIP2/VLI.html
    if(FITS(m_i, 7))
    {
        p[0] = hkLosslessCast<hkUint8>(m_i);
        return 1;
    }
    else if(FITS(m_i, 14))
    {
        p[0] = hkLosslessCast<hkUint8>(HK_BINARY_8(10000000) | (m_i >> 8));
        p[1] = hkLosslessCast<hkUint8>(0xff & m_i);
        return 2;
    }
    else if(FITS(m_i, 21))
    {
        p[0] = hkLosslessCast<hkUint8>(HK_BINARY_8(12000000) | (m_i >> 16));
        p[1] = hkLosslessCast<hkUint8>(0xff & (m_i >> 8));
        p[2] = hkLosslessCast<hkUint8>(0xff & m_i);
        return 3;
    }
    else if(FITS(m_i, 27))
    {
        p[0] = hkLosslessCast<hkUint8>(HK_BINARY_8(12300000) | (m_i >> 24));
        p[1] = hkLosslessCast<hkUint8>(0xff & (m_i >> 16));
        p[2] = hkLosslessCast<hkUint8>(0xff & (m_i >> 8));
        p[3] = hkLosslessCast<hkUint8>(0xff & m_i);
        return 4;
    }
    else if(FITS(m_i, 35))
    {
        p[0] = hkLosslessCast<hkUint8>(HK_BINARY_8(12305000) | (m_i >> 32));
        p[1] = hkLosslessCast<hkUint8>(0xff & (m_i >> 24));
        p[2] = hkLosslessCast<hkUint8>(0xff & (m_i >> 16));
        p[3] = hkLosslessCast<hkUint8>(0xff & (m_i >> 8));
        p[4] = hkLosslessCast<hkUint8>(0xff & m_i);
        return 5;
    }
    else if(FITS(m_i, 40))
    {
        p[0] = hkLosslessCast<hkUint8>(HK_BINARY_8(12345000));
        p[1] = hkLosslessCast<hkUint8>(0xff & (m_i >> 32));
        p[2] = hkLosslessCast<hkUint8>(0xff & (m_i >> 24));
        p[3] = hkLosslessCast<hkUint8>(0xff & (m_i >> 16));
        p[4] = hkLosslessCast<hkUint8>(0xff & (m_i >> 8));
        p[5] = hkLosslessCast<hkUint8>(0xff & m_i);
        return 6;
    }
    else if(FITS(m_i, 59))
    {
        p[0] = hkLosslessCast<hkUint8>(HK_BINARY_8(12340000) | (m_i >> 56));
        p[1] = hkLosslessCast<hkUint8>(0xff & (m_i >> 48));
        p[2] = hkLosslessCast<hkUint8>(0xff & (m_i >> 40));
        p[3] = hkLosslessCast<hkUint8>(0xff & (m_i >> 32));
        p[4] = hkLosslessCast<hkUint8>(0xff & (m_i >> 24));
        p[5] = hkLosslessCast<hkUint8>(0xff & (m_i >> 16));
        p[6] = hkLosslessCast<hkUint8>(0xff & (m_i >> 8));
        p[7] = hkLosslessCast<hkUint8>(0xff & m_i);
        return 8;
    }
    else// if(FITS(m_i, 63))
    {
        p[0] = hkLosslessCast<hkUint8>(HK_BINARY_8(12345008));
        p[1] = hkLosslessCast<hkUint8>(0xff & (m_i >> 56));
        p[2] = hkLosslessCast<hkUint8>(0xff & (m_i >> 48));
        p[3] = hkLosslessCast<hkUint8>(0xff & (m_i >> 40));
        p[4] = hkLosslessCast<hkUint8>(0xff & (m_i >> 32));
        p[5] = hkLosslessCast<hkUint8>(0xff & (m_i >> 24));
        p[6] = hkLosslessCast<hkUint8>(0xff & (m_i >> 16));
        p[7] = hkLosslessCast<hkUint8>(0xff & (m_i >> 8));
        p[8] = hkLosslessCast<hkUint8>(0xff & m_i);
        return 9;
    }
    #undef FITS

    // not implemented yet
    //111 11 010    17  128 A GUID/UUID
    //111 11 111    n   any Any multi-precision integer
}


hkUintVle hkUintVle::encodeSigned(hkInt64 s)
{
    // Use the low bit as "isNegative" flag
    // if isNegative is set, bias by 1 to cover the whole range
    hkUint64 u;
    if(s >= 0)
    {
        u = hkUint64(s << 1) | 0;
    }
    else
    {
        hkInt64 a = -hkInt64(s + 1); //think about the largest negative number
        u = hkUint64(a << 1) | 1;
    }
    return u;
}

hkInt64 hkUintVle::decodeSigned(hkUintVle v)
{
    hkUint64 m = v.m_i >> 1;
    if((v.m_i & 1) == 0)
    {
        return hkInt64( m );
    }
    else // neg
    {
        hkInt64 a = -hkInt64(m) - 1;
        return a;
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
