// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

HK_ALWAYS_INLINE hkReflect::Var hkSerialize::Detail::IndexedBundle::var(int i) const
{
    return m_items[i].var();
}

HK_ALWAYS_INLINE hkSerialize::VarN hkSerialize::Detail::IndexedBundle::varn(int i) const
{
    return m_items[i].varn();
}

HK_ALWAYS_INLINE const hkSerialize::Bundle::Item& hkSerialize::Detail::IndexedBundle::item(int i) const
{
    return m_items[i];
}

HK_INLINE void hkSerialize::Detail::IndexedBundle::setVar(VarId vid, _In_opt_ const void* addr, TypeId tid)
{
    HK_ASSERT_NO_MSG(0x19276f8d, addr == HK_NULL || tid != 0);
    makeSpace(vid);
    m_items[vid].set(addr, m_types[tid], Item::VAR0, 0);
}

HK_INLINE void hkSerialize::Detail::IndexedBundle::setVarToType(VarId vid, TypeId tid)
{
    makeSpace(vid);
    auto typeOfType = tid == 0 ? HK_NULL : hkReflect::exactTypeOf(m_types[tid]);
    m_items[vid].set(m_types[tid], typeOfType, Item::VAR0, 0);
}

HK_INLINE void hkSerialize::Detail::IndexedBundle::setNote(VarId vid, VarId annotated, _In_opt_ const void* addr, TypeId tid)
{
    HK_ASSERT_NO_MSG(0x521df55c, addr == HK_NULL || tid != 0);
    makeSpace(hkMath::max2(vid, annotated));

    
    if (m_items[annotated].m_addr == HK_NULL)
    {
        m_items[annotated].m_extra = vid;
    }

    m_items[vid].set(addr, m_types[tid], Item::NOTE, annotated);
}

HK_INLINE void hkSerialize::Detail::IndexedBundle::setType(int tid, _In_ const hkReflect::Type* _type)
{
    m_types.setSize(hkMath::max2(m_types.getSize(), tid + 1), HK_NULL);
    m_types[tid] = _type;
}

HK_INLINE void hkSerialize::Detail::IndexedBundle::setVarN(VarId vid, _In_opt_ const void* addr, TypeId tid, int count)
{
    HK_ASSERT_NO_MSG(0x1938bae0, addr == HK_NULL || tid != 0);
    makeSpace(vid);
    m_items[vid].set(addr, m_types[tid], Item::VARN, count);
}

HK_INLINE void hkSerialize::Detail::IndexedBundle::makeSpace(VarId vid)
{
    int oldSize = m_items.getSize();
    int newSize = hkMath::max2(oldSize, vid + 1);
    m_items.setSize(newSize);
}

HK_ALWAYS_INLINE int hkSerialize::Detail::IndexedBundle::getSize() const
{
    return m_items.getSize();
}

HK_ALWAYS_INLINE _Ret_notnull_ const hkReflect::Detail::ArrayImpl* hkSerialize::Detail::IndexedBundle::arrayImpl() const
{
    return &m_arrayImpl;
}

HK_ALWAYS_INLINE _Ret_notnull_ const hkReflect::Detail::PointerImpl* hkSerialize::Detail::IndexedBundle::pointerImpl() const
{
    return &m_pointerImpl;
}

HK_ALWAYS_INLINE _Ret_notnull_ const hkReflect::Detail::StringImpl* hkSerialize::Detail::IndexedBundle::stringImpl() const
{
    return &m_stringImpl;
}

HK_INLINE hkUint32 hkSerialize::Detail::OldIndexedPointerImpl::getIndex(_In_ const void* self) const
{
    hkUint32 i = *(hkUint32Le*)self;
    // We may have IDs to vars that haven't been written to the file (addEmpty). If so, just redirect
    // those IDs to the null var (id=0).
    if (i >= hkLosslessCast<hkUint32>(m_bundle->numVars()))
    {
        i = 0;
    }
    return i;
}

inline hkSerialize::Detail::OldIndexedBundle::OldIndexedBundle()
{
    m_pointerImpl.m_bundle = this;
    m_stringImpl.m_bundle = this;
    m_arrayImpl.m_bundle = this;
}

inline hkReflect::Var hkSerialize::Detail::OldIndexedBundle::var(int i) const
{
    IdxVar v = m_vars[i];
    return v.m_tid >= 0
        ? hkReflect::Var(v.m_addr, m_types[v.m_tid])
        : hkReflect::Var(m_types[-v.m_tid], hkReflect::exactTypeOf(static_cast<const hkReflect::Type*>(m_types[-v.m_tid])));
}
inline hkSerialize::VarN hkSerialize::Detail::OldIndexedBundle::extra(int i) const
{
    IdxVar v = m_extras[i];
    return VarN::fromArray(v.m_addr, m_types[v.m_tid], v.m_count);
}
inline hkReflect::Var hkSerialize::Detail::OldIndexedBundle::note(int i) const
{
    IdxVar v = m_notes[i];
    return hkReflect::Var(v.m_addr, m_types[v.m_tid]);
}

template<typename BaseBundle>
inline void hkSerialize::Detail::BundleWithRelocs<BaseBundle>::setType(int id, _In_ const hkReflect::Type* type)
{
    BaseBundle::setType(id, type);
    m_relocs.resolve(id, type);
}

template<typename BaseBundle>
inline void hkSerialize::Detail::BundleWithRelocs<BaseBundle>::setType(int id, _In_ hkReflect::Type* type, const TypeRelocs& relocs)
{
    setType(id, type);
    m_relocs.flatten(type, relocs, this->m_types);
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
