// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

template<typename T>
inline _Ret_maybenull_ T* hkSerializeUtil::loadObject(_Inout_ hkStreamReader* reader, _Inout_opt_ ErrorDetails* errorOut)
{
    hkRefPtr<hkObjectResource> res; res.setAndDontIncrementRefCount( loadOnHeap(reader, errorOut) );
    if( res )
    {
        return res->stealContents<T>();
    }
    return HK_NULL;
}

template<typename T>
inline _Ret_maybenull_ T* hkSerializeUtil::loadObject(_In_z_ const char* filename, _Inout_opt_ ErrorDetails* errorOut)
{
    hkRefPtr<hkObjectResource> res; res.setAndDontIncrementRefCount( loadOnHeap(filename, errorOut) );
    if( res )
    {
        return res->stealContents<T>();
    }
    return HK_NULL;
}

template<typename T>
inline _Ret_maybenull_ T* hkSerializeUtil::loadObject(_In_reads_bytes_(buflen) const void* buf, int bufLen, _Inout_opt_ ErrorDetails* errorOut)
{
    hkRefPtr<hkObjectResource> res; res.setAndDontIncrementRefCount( loadOnHeap(buf, bufLen, errorOut) );
    if( res )
    {
        return res->stealContents<T>();
    }
    return HK_NULL;
}

inline hkReflect::Var hkSerializeUtil::loadObjectVar(_Inout_ hkStreamReader* reader, _Inout_opt_ ErrorDetails* errorOut)
{
    hkRefPtr<hkObjectResource> res; res.setAndDontIncrementRefCount( loadOnHeap(reader, errorOut) );
    if( res )
    {
        return res->stealContentsVar();
    }
    return hkReflect::Var();
}

inline hkReflect::Var hkSerializeUtil::loadObjectVar(_In_z_ const char* filename, _Inout_opt_ ErrorDetails* errorOut)
{
    hkRefPtr<hkObjectResource> res; res.setAndDontIncrementRefCount( loadOnHeap(filename, errorOut) );
    if( res )
    {
        return res->stealContentsVar();
    }
    return hkReflect::Var();
}

inline hkReflect::Var hkSerializeUtil::loadObjectVar(_In_reads_bytes_(bufLen) const void* buf, int bufLen, _Inout_opt_ ErrorDetails* errorOut)
{
    hkRefPtr<hkObjectResource> res; res.setAndDontIncrementRefCount( loadOnHeap(buf, bufLen, errorOut) );
    if( res )
    {
        return res->stealContentsVar();
    }
    return hkReflect::Var();
}

template<typename T>
inline hkResult HK_CALL hkSerializeUtil::save(_In_ const T* object, _Inout_ hkStreamWriter* writer, SaveOptions options)
{
    return save(object, hkReflect::getType<T>(), writer, options);
}

template<typename T>
inline hkResult HK_CALL hkSerializeUtil::save(_In_ const T* object, _In_z_ const char* filename, SaveOptions options)
{
    hkOstream os(filename);
    if(hkStreamWriter* sw = os.getStreamWriter())
    {
        return save(object, hkReflect::getType<T>(), sw, options);
    }
    return HK_FAILURE;
}


hkSerializeUtil::SaveOptions& hkSerializeUtil::SaveOptions::useBinary(hkBool32 b)
{
    if(b)
    {
        andWith(~SAVE_TEXT_FORMAT);
    }
    else
    {
        orWith(SAVE_TEXT_FORMAT);
    }
    return *this;
}

hkSerializeUtil::SaveOptions& hkSerializeUtil::SaveOptions::useConcise(hkBool32 b)
{
    if(b)
    {
        orWith(SAVE_CONCISE);
    }
    else
    {
        andWith(~SAVE_CONCISE);
    }
    return *this;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
