// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Types/hkHandle.h>
#include <Common/Base/Serialize/Resource/hkObjectResource.h>

class hkStreamReader;
class hkStreamWriter;

    /// Deprecated utility functions to load and save tagfiles, replaced by hkSerialize::Load and hkSerialize::Save.
namespace hkSerializeUtil
{
    /// Error details class for loading packfile/tagfile.
    struct HK_EXPORT_COMMON ErrorDetails
    {
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_SERIALIZE, ErrorDetails );

        /// ErrorDetails constructor.
        ErrorDetails() : id(ERRORID_NONE) {}

            /// Error ids for loading packfile/tagfile.
        enum ErrorID
        {
                /// No errors reading from stream.
            ERRORID_NONE,
                /// Failed to read from stream.
            ERRORID_READ_FAILED,
                /// Unsupported file format.
            ERRORID_UNSUPPORTED_FORMAT,
                /// Packfile cannot be read on this platform.
            ERRORID_PACKFILE_PLATFORM,
                /// Versioning cannot be applied to loaded objects.
            ERRORID_VERSIONING_FAILED,
                /// Found object with members that cannot clean up memory when destroyed.
            ERRORID_NONHEAP_OBJECT,
                /// Stream was ok but some error in the data.
            ERRORID_LOAD_FAILED,
                /// The file contains deprecated format but hkFeature_serializeDeprecatedPre700() was not called
            ERRORID_DEPRECATED_NOT_INITIALIZED,
                /// Max error ID
            ERRORID_MAX_ID,

        };

        /// Logs an error inside the ErrorDetails.
        /// This function will not override the current error ID if it isn't ERRORID_NONE.
        /// The first error raised (the lowest level one) is always going to be the more interesting one.
        void raiseError(ErrorID i, _In_z_ const char* msg)
        {
            if(id == ERRORID_NONE)
            {
                id = i;
                defaultMessage = msg;
            }
        }

        /// Error id. Default is ErrorDetails::ERRORID_NONE.
        hkEnum<ErrorID, hkInt32> id;
        /// Detailed error message, if error id is not ErrorDetails::ERRORID_NONE.
        hkStringPtr defaultMessage;
    };

        /// Option bits for saving.
    enum SaveOptionBits
    {
        SAVE_DEFAULT                    = 0x00,     ///< All flags default to OFF; enable whichever are needed
        SAVE_TEXT_FORMAT                = 0x01,     ///< Use text (usually XML) format; default is binary format if available. Packfiles are always written as binary.
        SAVE_SERIALIZE_IGNORED_MEMBERS  = 0x02,     ///< Write members which are usually ignored; default is to skip SERIALIZE_IGNORED members.
        SAVE_WRITE_ATTRIBUTES           = 0x04,     ///< Include extended attributes in metadata; default is to write minimum metadata.
        SAVE_CONCISE                    = 0x08,     ///< Doesn't provide any extra information which would make the file easier to interpret. E.g. additionally write hex floats as text comments.
    };
        /// Options for saving.
    struct HK_EXPORT_COMMON SaveOptions : public hkFlags<SaveOptionBits, int>
    {
        SaveOptions(SaveOptionBits b=SAVE_DEFAULT) : hkFlags<SaveOptionBits,int>(b) {}
        SaveOptions& useText(hkBool32 b) { useBinary(!b); return *this; }
        inline SaveOptions& useBinary(hkBool32 b);
        inline SaveOptions& useConcise(hkBool32 b);
    };

        /// Option bits for loading.
    enum LoadOptionBits
    {
        LOAD_DEFAULT            = 0x00, ///< All flags default to OFF, enable whichever are needed
        LOAD_FAIL_IF_VERSIONING = 0x01, ///< Allows a way to skip versioning paths (if current version needs to be enforced)
        LOAD_FORCED = 0x02, ///< Force load.
        LOAD_NOVERSIONING = 0x04, ///< Don't even try to version
        LOAD_FAIL_IF_DYNAMIC = 0x08
    };

    extern HK_EXPORT_COMMON hkReflect::TypeReg* s_defaultLookupTypeCallback;

    struct HK_EXPORT_COMMON LoadOptions
    {
        LoadOptions(LoadOptionBits opts = LOAD_DEFAULT, _Inout_opt_ hkReflect::TypeReg* cb = HK_NULL);

        hkFlags<LoadOptionBits, hkUint32> getOptions() const { return m_options; }
        hkReflect::TypeReg* getTypeLookup() { return m_typeLookup; }

    private:
        hkReflect::TypeReg* m_typeLookup;
        hkFlags<LoadOptionBits, hkUint32> m_options;
    };
        /// Deprecated: Use hkSerialize::Load instead.
        /// Load serialized objects from stream and return pointer
        /// to hkResource object.
        /// To access hkResource objects you should call hkResource::getContents()
        /// or hkResource::getContentsWithRegistry() specifying type of top level
        /// object pointer you expect.
        /// hkResource is reference counted and users are responsible to
        /// remove reference when they do not need the hkResource content.
        /// The objects owned by hkResource are not reference counted.
        ///
        /// Load serialized objects from stream and return pointer
        /// to hkResource object.
        /// The function does additional check for the stream format, versioning and finishing steps.
        /// It will return HK_NULL if the checks failed. The error details are
        /// returned in 'detailsOut'.
    HK_EXPORT_COMMON _Ret_maybenull_ hkResource* HK_CALL load(_Inout_ hkStreamReader* stream, _Inout_opt_ ErrorDetails* detailsOut = HK_NULL, LoadOptions options = LoadOptions());

        /// Deprecated: Use hkSerialize::Load instead.
        /// Load serialized objects from a file using name and return pointer
        /// to hkResource object.
        /// See hkSerializeUtil::load( hkStreamReader* sr ) for details.
    HK_EXPORT_COMMON _Ret_maybenull_ hkResource* HK_CALL load(_In_z_ const char* filename, _Inout_opt_ ErrorDetails* detailsOut=HK_NULL, LoadOptions options=LoadOptions());

        /// Deprecated: Use hkSerialize::Load instead.
        /// Load serialized objects from buffer and return pointer
        /// to hkResource object. The buffer may be freed after loading.
        /// See hkSerializeUtil::load( hkStreamReader* sr ) for details.
    HK_EXPORT_COMMON _Ret_maybenull_ hkResource* HK_CALL load(_In_reads_bytes_(buflen) const void* buf, int buflen, _Inout_opt_ ErrorDetails* detailsOut=HK_NULL, LoadOptions options=LoadOptions());


        /// Deprecated: Use hkSerialize::Load instead.
        /// Load serialized objects from stream and return pointer
        /// to hkObjectResource object.
        /// To access hkObjectResource objects you should call hkObjectResource::getContents()
        /// or hkObjectResource::getContentsWithRegistry() specifying type of top level
        /// object pointer you expect.
        /// hkObjectResource is reference counted and users are responsible to
        /// remove reference when they do not need its content.
        /// The objects owned by hkObjectResource are allocated on heap and reference counted.
        ///
        /// Load serialized objects from stream and return pointer to hkObjectResource object.
        /// If 'classReg' or 'typeReg' are null the ones from hkBuiltinTypeRegistry are used.
        /// The function does additional check for the stream format, versioning and finishing steps.
        /// It will return HK_NULL if the checks failed. The error details are
        /// returned in 'detailsOut'.
    HK_EXPORT_COMMON _Ret_maybenull_ hkObjectResource* HK_CALL loadOnHeap(_Inout_ hkStreamReader* stream, _Inout_opt_ ErrorDetails* errorOut = HK_NULL, LoadOptions options = LoadOptions());

        /// Deprecated: Use hkSerialize::Load instead.
        /// Load serialized objects from a file using name and return pointer
        /// to hkObjectResource object.
        /// See hkSerializeUtil::load( hkStreamReader* sr ) for details.
    HK_EXPORT_COMMON _Ret_maybenull_ hkObjectResource* HK_CALL loadOnHeap(_In_z_ const char* filename, _Inout_opt_ ErrorDetails* errorOut = HK_NULL, LoadOptions options = LoadOptions());

        /// Deprecated: Use hkSerialize::Load instead.
        /// Load serialized objects from a file using name and return pointer
        /// to hkObjectResource object.
        /// See hkSerializeUtil::load( hkStreamReader* sr ) for details.
    HK_EXPORT_COMMON _Ret_maybenull_ hkObjectResource* HK_CALL loadOnHeap(_In_reads_bytes_(buflen) const void* buf, int buflen, _Inout_opt_ ErrorDetails* errorOut = HK_NULL, LoadOptions options = LoadOptions());


    //
    // Shortcut loads
    //

        /// Deprecated: Use hkSerialize::Load instead.
        /// Shortcut to combine loadOnHeap and hkObjectResource::stealContents.
    template<typename T> inline _Ret_maybenull_ T* loadObject(_Inout_ hkStreamReader* reader, _Inout_opt_ ErrorDetails* errorOut = HK_NULL);

        /// Deprecated: Use hkSerialize::Load instead.
        /// Shortcut to combine loadOnHeap and hkObjectResource::stealContents.
    template<typename T> inline _Ret_maybenull_ T* loadObject(_In_z_ const char* filename, _Inout_opt_ ErrorDetails* errorOut = HK_NULL);

        /// Deprecated: Use hkSerialize::Load instead.
        /// Shortcut to combine loadOnHeap and hkObjectResource::stealContents.
    template<typename T> inline _Ret_maybenull_ T* loadObject(_In_reads_bytes_(buflen) const void* buf, int buflen, _Inout_opt_ ErrorDetails* errorOut = HK_NULL);

        /// Deprecated: Use hkSerialize::Load instead.
        /// Shortcuts to load and return a var
    inline hkReflect::Var loadObjectVar(_Inout_ hkStreamReader* reader, _Inout_opt_ ErrorDetails* errorOut = HK_NULL);
        /// Deprecated: Use hkSerialize::Load instead.
    inline hkReflect::Var loadObjectVar(_In_z_ const char* filename, _Inout_opt_ ErrorDetails* errorOut = HK_NULL);
        /// Deprecated: Use hkSerialize::Load instead.
    inline hkReflect::Var loadObjectVar(_In_reads_bytes_(buflen) const void* buf, int buflen, _Inout_opt_ ErrorDetails* errorOut = HK_NULL);


        /// Deprecated: Use hkSerialize::Save instead.
        /// Save a snapshot of a given object in tagfile form using provided writer.
        /// Returns HK_SUCCESS if successful.
        /// NOTE: Some objects are inherently not serializable because they point to
        /// external memory, i.e., the vertex and index arrays of an hkpMeshShape.
        /// These objects should be converted before saving, i.e hkpMeshShape -> hkpStorageMeshShape
        /// (see hkpHavokSnapshot::ConvertListener class for details).
        /// If you want these conversions applied you should provide a hkpHavokSnapshot::ConvertListener as
        /// a value for userListener.
    HK_EXPORT_COMMON hkResult HK_CALL saveTagfile(_In_ const void* object, _In_ const hkReflect::Type* klass, _Inout_ hkStreamWriter* writer, SaveOptions options = SAVE_DEFAULT);

        /// Deprecated: Use hkSerialize::Save instead.
    template<typename T>
    hkResult HK_CALL saveTagfile(_In_ const T* object, _Inout_ hkStreamWriter* writer, SaveOptions options = SAVE_DEFAULT)
    {
        return saveTagfile( object, hkReflect::getType<T>(), writer, options );
    }

        /// Deprecated: Use hkSerialize::Save instead.
    HK_EXPORT_COMMON hkResult HK_CALL savePackfile(_In_ const void* object, _In_ const hkReflect::Type* klass, _Inout_ hkStreamWriter* writer, SaveOptions options = SAVE_DEFAULT);

        /// Deprecated: Use hkSerialize::Save instead.
    template<typename T>
    hkResult HK_CALL savePackfile(_In_ const T* object, _Inout_ hkStreamWriter* writer, SaveOptions options = SAVE_DEFAULT)
    {
        return savePackfile( object, hkReflect::getType<T>(), writer, options );
    }

        /// Deprecated: Use hkSerialize::Save instead.
        /// Save with the default options in the default file format (currently tagfile)
    HK_EXPORT_COMMON hkResult HK_CALL save(_In_ const void* object, _In_ const hkReflect::Type* klass, _Inout_ hkStreamWriter* writer, SaveOptions options = SAVE_DEFAULT);

        /// Deprecated: Use hkSerialize::Save instead.
        /// Shortcut to save an object with out having to specify the hkType.
    template<typename T> inline hkResult HK_CALL save(_In_ const T* object, _Inout_ hkStreamWriter* writer, SaveOptions options = SAVE_DEFAULT);

        /// Deprecated: Use hkSerialize::Save instead.
        /// Shortcut to save an object with out having to specify the hkType.
    template<typename T> inline hkResult HK_CALL save(_In_ const T* object, _In_z_ const char* filename, SaveOptions options = SAVE_DEFAULT);

    /// The known formats of asset files, including old formats which may not have a registered loading class (ReadFormat).
    enum FormatType
    {
        /// read or open error.
        FORMAT_ERROR,
        /// readable but not recognised.
        FORMAT_UNKNOWN,
        /// binary packfile
        FORMAT_PACKFILE_BINARY,
        /// XML packfile
        FORMAT_PACKFILE_XML,
        /// Binary tagfile
        FORMAT_TAGFILE_BINARY,
        /// XML tagfile
        FORMAT_TAGFILE_XML,
        /// A registered format newer than the hkSerializeUtil. May be loadable.
        FORMAT_OTHER
    };

        /// Information returned by detectFormat.
    struct HK_EXPORT_COMMON FormatDetails
    {
        HK_DECLARE_CLASS(FormatDetails, New);

        FormatDetails();

        /// The type of the file
        hkEnum<FormatType, hkInt32> m_formatType;
            /// The version number for the format
        int m_formatVersion;
            /// The SDK version which created this file, if known.
        hkStringPtr m_version;
    };


        /// Deprecated: Use hkSerialize::Detail::detectFormat instead.
        /// Detect the type of a packfile stream.
    HK_EXPORT_COMMON hkEnum<FormatType, hkInt32> HK_CALL detectFormat(_Inout_ hkStreamReader* reader, _Inout_opt_ ErrorDetails* errorOut=HK_NULL );

        /// Deprecated: Use hkSerialize::Detail::detectFormat instead.
        /// Extract some information from the file header.
        /// See FormatDetails for the available information.
    HK_EXPORT_COMMON void HK_CALL detectFormat(_In_z_ const char* filename, FormatDetails& detailsOut, _Inout_opt_ ErrorDetails* errorOut = HK_NULL);
    HK_EXPORT_COMMON void HK_CALL detectFormat(_Inout_ hkStreamReader* reader, FormatDetails& detailsOut, _Inout_opt_ ErrorDetails* errorOut = HK_NULL);

        /// Is the stream a tagfile, XML packfile or binary packfile for the current platform?
    HK_EXPORT_COMMON hkBool32 HK_CALL isLoadable(_Inout_opt_ hkStreamReader* sr);

        /// Calculate the crc of the object recursively following pointers.
    HK_EXPORT_COMMON hkUint32 HK_CALL calcCrc32(const hkReflect::Var& var, hkUint32 seed = 0);

        /// Calculate the crc of the object recursively following pointers.
    template<typename T>
    hkUint32 HK_CALL calcCrc32(_In_ const T* t, hkUint32 seed = 0) { return calcCrc32(hkReflect::Var(t), seed); }
}

#include <Common/Base/Serialize/Deprecated/hkSerializeUtil.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
