// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

HK_ALWAYS_INLINE hkSerialize::Note::Import::Import(const char* n, int l) : m_name(n, l) {}
HK_ALWAYS_INLINE hkSerialize::Note::Export::Export(const char* n, int l) : m_name(n, l) {}

HK_ALWAYS_INLINE hkSerialize::VarN::VarN(_In_ const void* addr, hkReflect::QualType type, int count)
    : m_first(addr, type), m_count(count)
{
}

HK_ALWAYS_INLINE hkSerialize::VarN hkSerialize::VarN::fromSingle(_In_ const void* addr, hkReflect::QualType type)
{
    return VarN(addr, type, SINGLE);
}

HK_ALWAYS_INLINE hkSerialize::VarN hkSerialize::VarN::fromSingle(const hkReflect::Var& var)
{
    return VarN(var.getAddress(), var.getType(), SINGLE);
}

HK_ALWAYS_INLINE hkSerialize::VarN hkSerialize::VarN::fromArray(_In_ const void* addr, hkReflect::QualType type, int count)
{
    return VarN(addr, type, count);
}

HK_ALWAYS_INLINE hkReflect::QualType hkSerialize::VarN::getType() const
{
    return m_first.getType();
}

template<typename T>
inline _Ret_maybenull_ T* hkSerialize::VarN::isInstanceOf() const
{
    HK_ASSERT_NO_MSG(0x44cd1b7f, m_count >= SINGLE);
    return (m_count == SINGLE && m_first.getAddress()) ? m_first.dynCast<T>() : HK_NULL;
}

_Ret_maybenull_ HK_ALWAYS_INLINE void* hkSerialize::VarN::getAddress() const
{
    return m_first.getAddress();
}

inline int hkSerialize::VarN::getCount() const
{
    HK_ASSERT_NO_MSG(0x695faa42, m_count >= SINGLE);
    return hkMath::abs(m_count);
}

HK_ALWAYS_INLINE hkSerialize::VarN::operator hkBoolOperator::BoolType() const
{
    return hkBoolOperator::cast(m_first.getAddress());
}

HK_ALWAYS_INLINE hkReflect::Var hkSerialize::VarN::getFirst() const { return m_first; }

HK_ALWAYS_INLINE hkReflect::Var hkSerialize::VarN::get(int id) const
{
    HK_ASSERT_NO_MSG(0x49f190de, id < m_count);
    return hkReflect::Var(hkAddByteOffset(m_first.getAddress(), id * m_first.getType()->getSizeOf()), m_first.getType());
}

HK_ALWAYS_INLINE hkSerialize::VarN hkSerialize::VarN::invalid() { return s_invalid; }

HK_ALWAYS_INLINE _Ret_notnull_ const hkReflect::Type* hkSerialize::Bundle::type(int i) const
{
    return m_types[i];
}

HK_ALWAYS_INLINE hkArrayView<const hkReflect::Type*> hkSerialize::Bundle::types() const
{
    return m_types;
}

HK_ALWAYS_INLINE hkSerialize::Bundle::Item::Item() : m_addr(HK_NULL), m_kind(VAR0), m_extra(0) {}

HK_INLINE void hkSerialize::Bundle::Item::set(_In_ const void* addr, hkReflect::QualType type, Kind kind, int extra)
{
    m_addr = addr;
    m_type = type;
    m_kind = kind;
    m_extra = extra;
}

HK_ALWAYS_INLINE bool hkSerialize::Bundle::Item::isVar() const { return m_kind == VAR0;  }

HK_ALWAYS_INLINE bool hkSerialize::Bundle::Item::isVarN() const { return m_kind == VARN; }
HK_ALWAYS_INLINE int hkSerialize::Bundle::Item::getCount() const { return isVarN() ? m_extra : hkSerialize::VarN::SINGLE; }

HK_ALWAYS_INLINE bool hkSerialize::Bundle::Item::isNote() const { return m_kind == NOTE; }
HK_ALWAYS_INLINE int hkSerialize::Bundle::Item::getAnnotated() const { return isNote() ? m_extra : 0; }

HK_INLINE hkReflect::Var hkSerialize::Bundle::Item::var() const
{
    HK_ASSERT_NO_MSG(0x72d95bb8, isVar() || isNote());
    return hkReflect::Var(m_addr, m_type);
}

HK_INLINE hkSerialize::VarN hkSerialize::Bundle::Item::varn() const
{
    HK_ASSERT_NO_MSG(0x1e17732a, isVarN());
    return hkSerialize::VarN::fromArray(m_addr, m_type, getCount());
}

template<typename T>
HK_ALWAYS_INLINE void hkSerialize::BundleBuilder::add(_In_ const T* t) { return add(hkReflect::Var(t)); }

HK_INLINE void hkSerialize::BundleBuilder::Item::set(const hkReflect::Var& var, bool weak)
{
    m_var = var;
    m_weak = weak;
    m_written = false;
    m_annotated = 0;
}

template<typename ImportType>
void hkSerialize::BundleBuilder::addGenericImport(const hkReflect::Var& var, const ImportType& import)
{
    VarId origId = lookup(var);
    if (m_items[origId].m_written)
    {
        // Do not do anything.
        
        return;
    }

    if (m_imported.insert(var.getAddress()))
    {
        // Allocate a new weak id for the object.
        VarId newId = m_items.getSize();
        m_items.expandOne().set(var, true);

        // Remap the object original id to the import note, so that all pointers to the object will be annotated.
        hkReflect::Var& imp = m_imports.expandOne();
        imp = new ImportType(import);
        m_items[origId].m_var = imp;
        m_items[origId].m_annotated = newId;
        m_idFromKey.insert(imp, origId);
        write(origId);
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
