// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/Serialize/Core/hkSerializeCore.h>

#define DEBUG_LOG_IDENTIFIER "s11n.Serialize"
#include <Common/Base/System/Log/hkLog.hxx>

const hkSerialize::VarN hkSerialize::VarN::s_invalid(HK_NULL, HK_NULL, 0);

hkSerialize::Bundle::Bundle() {}
hkSerialize::Bundle::~Bundle() {}


hkViewPtr<hkSerialize::Bundle> hkSerialize::ReadFormat::inplace(_In_reads_bytes_(bufLen) const void* buf, hkUlong bufLen, _Out_ hkUlong* usedOut, _In_ const hkReflect::TypeReg* typeReg)
{
    return HK_NULL;
}

hkSerialize::BundleBuilder::BundleBuilder(_In_ WriteFormat* format, _In_ hkIo::WriteBuffer* buf)
    : m_format(format)
    , m_ptrCallback(HK_NULL)
    , m_varCallback(HK_NULL)
    , m_cbData(HK_NULL)
{
    HK_ASSERT_NO_MSG(0x2444044a, m_format);
    // null is the zero-th item
    m_items.expandOne();
    m_items.back().m_weak = false;
    m_items.back().m_written = true;
    m_idxUnresolved = -1;

    m_format->beginBundle(buf);
}

hkSerialize::IdFromVar::~IdFromVar()
{
}

hkSerialize::BundleBuilder::~BundleBuilder()
{
    m_format->endBundle();

    for (int i = 0; i < m_imports.getSize(); ++i)
    {
        m_imports[i].destroy();
    }

    m_imports.clear();
}

void hkSerialize::BundleBuilder::add(const hkReflect::Var& var)
{
    hkSerialize::VarId id = lookup(var);
    write(id);
}

void hkSerialize::BundleBuilder::write(VarId startId)
{
    if (m_items[startId].m_written == false)
    {
        m_items[startId].m_weak = false;

        if (m_varCallback && !m_items[startId].m_annotated)
        {
            hkReflect::Var item = m_items[startId].m_var;
            (*m_varCallback)(item, *this, m_cbData);
        }

        m_writeQueue.pushBack(startId);
        if (m_writeQueue.getSize() == 1)
        {
            // Iterate on all the objects in the queue as it grows and write them.
            
            for (int i = 0; i < m_writeQueue.getSize(); ++i)
            {
                VarId currId = m_writeQueue[i];

                // Check if any callback has changed m_written.
                if (m_items[currId].m_written == false)
                {
                    hkReflect::Var item = m_items[currId].m_var;
                    if (m_items[currId].m_annotated != 0)
                    {
                        
                        writing(currId);
                        m_format->writeNote(m_items[currId].m_annotated, item, *this);
                    }
                    else
                    {
                        m_format->write(item, *this);
                    }
                }

            }
            m_writeQueue.clear();
        }
    }
}

void hkSerialize::BundleBuilder::addSubstitution(const hkReflect::Var& sub, const hkReflect::Var& orig)
{
    DLOG("Substituting {} for {}", sub, orig);

    if (orig.getAddress() == HK_NULL)
    {
        return;
    }
    bool weak = false;

    VarId newId = m_items.getSize();
    IdFromKey::Iterator it = m_idFromKey.findOrInsertKey(orig, newId);
    VarId id = m_idFromKey.getValue(it);
    if (id == newId)
    {
        m_items.expandOne().set(sub, weak);
    }
    else if (!weak)
    {
        // Can't substitute if we have already written it
        HK_ASSERT_NO_MSG(0x3d99c1f7, !m_items[id].m_written);
        m_items[id].m_weak = weak;
        m_items[id].m_var = sub;
    }
    m_idFromKey.insert(sub, id);
}

void hkSerialize::BundleBuilder::addExport(const hkReflect::Var& var, _In_z_ const char* name)
{
    hkScopedPtr<Note::Export>& exp = m_exports.expandOne();
    exp.reset(new Note::Export(name));
    addNote(var, exp.get());
}

void hkSerialize::BundleBuilder::addImport(const hkReflect::Var& var, _In_z_ const char* name)
{
    addGenericImport(var, Note::Import(name));
}

void hkSerialize::BundleBuilder::addNote(const hkReflect::Var& var, const hkReflect::Var& note)
{
    HK_ASSERT(0x372a0729, var.isValid(), "Cannot add a note on a null Var");

    VarId vid = lookup(var);

    HK_ASSERT(0x5f6c145c, m_items[vid].m_annotated == 0, "Cannot add note on note");

    HK_ON_DEBUG(int lastId = m_items.getSize());
    VarId noteId = lookup(note);

    HK_ON_DEBUG(bool isNew = m_items.getSize() != lastId);
    HK_ASSERT(0x7296a32c, isNew || m_items[noteId].m_annotated == vid,
        "Cannot mark an already looked-up/added object as a note");

    // Mark the item as a note.
    m_items[noteId].m_annotated = vid;
    write(noteId);
}

void hkSerialize::BundleBuilder::addEmpty(const hkReflect::Var& var)
{
    writing(lookup(var));
}

bool hkSerialize::BundleBuilder::nextUnresolved()
{
    
    if ( m_idxUnresolved >= 0 && m_idxUnresolved < m_items.getSize() )
    {
        for( int i = m_idxUnresolved; i < m_items.getSize(); ++i )
        {
            if( m_items[i].m_written == false && m_items[i].m_weak == false)
            {
                m_idxUnresolved = i;
                return true;
            }
        }
    }

    for( int i = 0; i < m_items.getSize(); ++i )
    {
        if( m_items[i].m_written == false && m_items[i].m_weak == false)
        {
            m_idxUnresolved = i;
            return true;
        }
    }
    m_idxUnresolved = -1;
    return false;
}

hkReflect::Var hkSerialize::BundleBuilder::currentUnresolved() // could be RecordVar, ContainerVar, StringVar
{
    return m_items[m_idxUnresolved].m_var;
}


void hkSerialize::BundleBuilder::setCallbacks(_In_ void* cbdata, Save::VarCallback vcb, Save::PtrCallback pcb)
{
    m_cbData = cbdata;
    m_varCallback = vcb;
    m_ptrCallback = pcb;
}


hkResult hkSerialize::BundleBuilder::recursiveAdd()
{
    while(nextUnresolved())
    {
        hkReflect::Var obj = currentUnresolved();
        add(obj);
    }

    return HK_SUCCESS;
}


hkSerialize::VarId hkSerialize::BundleBuilder::pointer(const hkReflect::PointerVar& ptr)
{
    hkReflect::Var v = ptr.getValue();
    if( v && m_ptrCallback )
    {
        v = m_ptrCallback(ptr, *this, m_cbData);
    }
    return lookup(v);
}

hkSerialize::VarId hkSerialize::BundleBuilder::lookup(const hkReflect::Var& var)
{
    if( !var.isValid() )
    {
        return 0;
    }
    bool weak = false;

    while(1)
    {
        VarId newId = m_items.getSize();
        IdFromKey::Iterator it = m_idFromKey.findOrInsertKey(var, newId);
        VarId id = m_idFromKey.getValue(it);
        if( id == newId )
        {
            m_items.expandOne().set(var, weak);
        }
        else if(!weak)
        {
            m_items[id].m_weak = weak;
        }
        return id;
    }
}

void hkSerialize::BundleBuilder::writing(hkSerialize::VarId id)
{
    m_items[id].m_weak = false;
    m_items[id].m_written = true;
}

hkSerialize::VarId hkSerialize::BundleBuilder::newId()
{
    VarId id = m_items.getSize();
    Item& item = m_items.expandOne();
    item.m_weak = false;
    item.m_written = true;
    item.m_annotated = 0;
    return id;
}

hkSerialize::WriteFormat::~WriteFormat()
{
}

void hkSerialize::WriteFormat::beginTypeCompendium(const hkIo::Detail::WriteBufferAdapter& sink)
{
}

void hkSerialize::WriteFormat::endTypeCompendium()
{
}

hkResult hkSerialize::WriteFormat::enableMultiBundle()
{
    return HK_FAILURE;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
