// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Reflect/Visitor/Detail/hkReflectVisitorDetail.h>

namespace hkReflect
{
        /// Visit a hkReflect::Type.
        /// Inherit from this class and write "visit" methods.
        /// Call the method "RType dispatch(const Type* type, <args>)" to start the visitor.
        /// This will dispatch to the correct overloaded "visit" method.
        ///
        /// You must have a visit method for all types, otherwise you will get a compile error.
        /// Normal overloading rules apply however so if you have a visit method which handles ValueType for instance,
        /// you need not explicitly handle BoolType, IntType, FloatType etc.
    template <typename Visitor, typename RType = void, typename Arg1 = void, typename Arg2 = void, typename Arg3 = void>
    struct TypeVisitor : public Detail::UnaryVisitor<Visitor, Detail::VisitTypes, RType, Arg1, Arg2, Arg3>
    {
        // RType dispatch(const Type* type, <args>) starts the visitor.

        // RType visit(<const ExactType*> var, <args>) you provide overloads for each type.
    };

        /// Visit a hkReflect::Var.
        /// Inherit from this class and write "visit" methods.
        /// Call the method "RType dispatch(Var var, <args>)" to start the visitor.
        /// This will dispatch to the correct overloaded "visit" method.
        ///
        /// You must have a visit method for all var types, otherwise you will get a compile error.
        /// Normal overloading rules apply however so if you have a visit method which handles ValueVar for instance,
        /// you need not explicitly handle BoolVar, IntVar, FloatVar etc.
    template <typename Visitor, typename RType = void, typename Arg1 = void, typename Arg2 = void, typename Arg3 = void>
    struct VarVisitor : public Detail::UnaryVisitor<Visitor, Detail::VisitVars, RType, Arg1, Arg2, Arg3>
    {
        // RType dispatch(Var var, <args>) to start the visitor.

        // RType visit(const <ExactVar>& var, <args>) you provide overloads for each var type. Note the first parameter is a const reference.
    };
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
