// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

namespace hkReflect
{
    namespace Detail
    {
        struct VisitVars {};
        struct VisitTypes {};

        // GetTagToVisitedType associates VisitHandle/VisitTypes with some associated utility functions and types
        template<typename VisitedThing>
        struct GetTagToVisitedType;

        template<>
        struct GetTagToVisitedType<VisitVars>
        {
            typedef const hkReflect::Var& GenericType;
            typedef const hkReflect::OpaqueVar& OpaqueType;

            template<hkReflect::Kind kind>
            struct GetType
            {
                typedef const typename hkReflect::VarFromKind<kind>::Type& Type;
            };

            template<typename T>
            static hkReflect::Kind getKind(const T& t)
            {
                return t.getType()->getKind();
            }

            template<typename T>
            static bool isValid(const T& t)
            {
                
                return t.getType() != HK_NULL;
            }
        };

        template<>
        struct GetTagToVisitedType<VisitTypes>
        {
            typedef const hkReflect::Type* GenericType;
            typedef const hkReflect::OpaqueType* OpaqueType;

            template<hkReflect::Kind kind>
            struct GetType
            {
                typedef const typename hkReflect::TypeFromKind<kind>::Type* Type;
            };

            template<typename T>
            static hkReflect::Kind getKind(const T* t)
            {
                return t->getKind();
            }

            template<typename T>
            static bool isValid(const T* t)
            {
                return t != HK_NULL;
            }
        };

        template<typename P> struct AddConstRef { typedef const P& Type; };
        template<> struct AddConstRef<void> { typedef void Type; };

        /************************ ParentOf ************************/
        // The purpose of ParentOf is to recurse through the hierarchy from the bottom (child) up to the root.
        // The root's parent should be 'void' which stops the recursion.
        // Note that it doesn't necessarily mean there's a inheritance relationship between the types.
        template <typename T> struct ParentOf { typedef typename T::ParentType Type; };
        template <typename T> struct ParentOf<T*> { typedef typename ParentOf<T>::Type* Type; };
        template <typename T> struct ParentOf<const T*> { typedef const typename ParentOf<T>::Type* Type; };
        template <typename T> struct ParentOf<T&> { typedef typename ParentOf<T>::Type& Type; };
        //template <typename T> struct ParentOf<const T&> { typedef const typename ParentOf<T>::Type& Type; };
        template <typename T> struct ParentOf<const T&> { typedef typename AddConstRef< typename ParentOf<T>::Type >::Type Type; };
        template <> struct ParentOf<void> { typedef void Type; };

        /************************ MakeMethodType ************************/
        // MakeMethodType takes the Visitor's exact type and the various types necessary to build the type of the visit() method.
        // It is specialized to allow different arities discarding any 'void' type it gets as argument type.
        template <typename Visitor, typename ReturnType, typename VisitedType, typename Arg1, typename Arg2, typename Arg3>
        struct MakeMethodType
        {
            typedef ReturnType (Visitor::*Type)(VisitedType, Arg1, Arg2, Arg3);
        };

        template <typename Visitor, typename ReturnType, typename VisitedType, typename Arg1, typename Arg2>
        struct MakeMethodType<Visitor, ReturnType, VisitedType, Arg1, Arg2, void>
        {
            typedef ReturnType (Visitor::*Type)(VisitedType, Arg1, Arg2);
        };

        template <typename Visitor, typename ReturnType, typename VisitedType, typename Arg1>
        struct MakeMethodType<Visitor, ReturnType, VisitedType, Arg1, void, void>
        {
            typedef ReturnType (Visitor::*Type)(VisitedType, Arg1);
        };

        template <typename Visitor, typename ReturnType, typename VisitedType>
        struct MakeMethodType<Visitor, ReturnType, VisitedType, void, void, void>
        {
            typedef ReturnType (Visitor::*Type)(VisitedType);
        };

        /************************ GetMethod ************************/
        // GetMethod emulates the C++ overloading rules by successively trying to get methods in the visitor from the most specific
        // one to the most general one.
        struct MissingOverloadFlag { };
        template<typename First, typename Second> struct TypePair { typedef First FirstType; typedef Second SecondType; };
        template <typename Visitor, typename ReturnType, typename VisitedType, typename Arg1, typename Arg2, typename Arg3>
        struct GetMethod
        {
            //typedef void (Visitor::*methodType)(const void*);
            typedef typename MakeMethodType<Visitor, ReturnType, VisitedType, Arg1, Arg2, Arg3>::Type ExactMethodType;

            typedef char yes;
            typedef int no;

            // This is a typical SFINAE check. The compiler will prefer the first overload if it can instantiate it
            // because of overloading rules stating the '...' is the least preferred overload. In order to instantiate
            // the first method it has to be able to assign &Deferred::visit to a method pointer of type ExactMethodType.
            // Deferred here is always 'Visitor' but has to be a template parameter nonetheless because we have to prevent
            // any early instantiation of the methods which would lead to a compile error.
#if defined(HK_COMPILER_GHS)
            // Workaround WiiU compiler issue
            template <typename Deferred, ExactMethodType f> struct hasExactVisit{};
            template <typename Deferred> static yes getExact(hasExactVisit<Deferred, &Deferred::visit>* = 0);
#elif defined(_MSC_VER) && _MSC_VER < 1900
            template <typename Deferred, ExactMethodType f = &Deferred::visit> struct hasExactVisit {};
            template <typename Deferred>
            static yes getExact(_In_opt_ hasExactVisit<Deferred>* = 0);
#else
            static yes testSignature(ExactMethodType);

            template <class T>
            static decltype(testSignature(&T::visit)) getExact(void*);
#endif
            template <typename Deferred>
            static no getExact(...);

            // SelectOverload implements the actual recursion from the child type up to the root to find the most specific
            // method type we can call.
            // SelectOverload<>::Type will be the type of the most specific visit() method we can call or MissingOverloadFlag
            // if none was found.
            // The Unused parameter is there to avoid any early instantiation.
            template <unsigned HasExactOverload, typename Unused>
            struct SelectOverload;

            template <typename Unused>
            struct SelectOverload<sizeof(yes), Unused>
            {
                typedef TypePair<ExactMethodType, VisitedType> Type;
            };

            template<typename Unused>
            struct SelectOverload<sizeof(no), Unused>
            {
                typedef typename GetMethod<Visitor, ReturnType, typename ParentOf<VisitedType>::Type, Arg1, Arg2, Arg3>::Type Type;
            };

            typedef typename SelectOverload<sizeof(getExact<Visitor>(0)), void>::Type Type;
        };

        // Specialization of GetMethod for the case when ParentOf<T> returned void (and therefore VisitedType=const void*)
        template <typename Visitor, typename ReturnType, typename Arg1, typename Arg2, typename Arg3>
        struct GetMethod<Visitor, ReturnType, const void*, Arg1, Arg2, Arg3>
        {
            typedef TypePair<MissingOverloadFlag, void> Type;
        };

        template <typename Visitor, typename ReturnType, typename Arg1, typename Arg2, typename Arg3>
        struct GetMethod<Visitor, ReturnType, void, Arg1, Arg2, Arg3>
        {
            typedef TypePair<MissingOverloadFlag, void> Type;
        };

        /************************ PtrTable ************************/
        // The PtrTable is a statically constructed table associating hkReflect::KindValue to method pointers
        template <typename T, typename VisitedThing, typename Arg1 = void, typename Arg2 = void, typename Arg3 = void>
        struct PtrTable
        {
            // Generic method type used to store the pointers. We don't expect to have weird method pointers here (no
            // multiple inheritance etc).
            typedef void (T::*methodType)(typename GetTagToVisitedType<VisitedThing>::GenericType);

            // We store the pointer table in a static method to avoid relying on static initialization order
            HK_INLINE static _Ret_notnull_ methodType* getTable() { static methodType table[hkReflect::_KIND_MAX] = { HK_NULL }; return table; }
        };

        template <typename T, typename MissingOverload>
        struct MissingOverloadFromVisitor
        {
            enum { value = 1 };
        };

        template <typename MissingOverload>
        struct MissingOverloadFromVisitor< MissingOverloadFlag, MissingOverload >;


        template<typename Visitor, typename VisitedThing, typename ExactVisitedType, typename ExactMethodType>
        struct GetMethodPointer;

        template<typename Visitor, typename ExactVisitedType, typename ExactMethodType>
        struct GetMethodPointer<Visitor, VisitTypes, ExactVisitedType, ExactMethodType>
        {
            static ExactMethodType get()
            {
                return static_cast<ExactMethodType>(&Visitor::visit);
            }
        };

        template<typename Visitor, typename ExactVisitedType, typename ExactMethodType>
        struct GetMethodPointer<Visitor, VisitVars, ExactVisitedType, ExactMethodType>
        {
                // If ever you see undefined references to UnaryVisitor<...>::wrap than like gcc your
                // compiler doesn't like the reinterpret_cast on the method pointer. The workaround is
                // slightly more expensive at compile time and is therefore #ifdef-ed out for compilers
                // which don't need it.
#ifdef HK_COMPILER_GCC
            // The trick is to make the compiler deduce the type for the method by going through getMethod before
            // reinterpret_cast-ing it.
            template<typename M>
            HK_INLINE static M getMethod(M m) { return m; }

            static ExactMethodType get()
            {
                return reinterpret_cast<ExactMethodType>(getMethod(&Visitor::template wrap<Visitor, ExactMethodType, ExactVisitedType>));
            }
#else
            static ExactMethodType get()
            {
                return reinterpret_cast<ExactMethodType>(&Visitor::template wrap<Visitor, ExactMethodType, ExactVisitedType>);
            }
#endif
        };

        template <typename Visitor, typename RType>
        struct BaseVisitor
        {
            typedef RType ReturnType;
        };


#ifndef __HAVOK_PARSER__
        // The Assign metafunction is there to initialize the method pointer of one kind given the ExactMethodType which is the most specific method we can
        // call.
        template <typename Visitor, typename VisitedThing, typename ExactVisitedType, typename ExactMethodType, typename Arg1, typename Arg2, typename Arg3, hkReflect::Kind kind>
        struct Assign
        {
            HK_ALWAYS_INLINE static void assign()
            {
                typedef typename PtrTable<Visitor, VisitedThing, Arg1, Arg2, Arg3>::methodType GenericMethodType;
                // This generates a nicer error message if an overload is missing from a Visitor (in that case ExactMethodType = MissingOverloadFlag)
                HK_POSSIBLY_UNUSED int checkMissingOverload = MissingOverloadFromVisitor<ExactMethodType, typename GetTagToVisitedType<VisitedThing>::template GetType<kind>::Type >::value;
                checkMissingOverload = 0;

                PtrTable<Visitor, VisitedThing, Arg1, Arg2, Arg3>::getTable()[unsigned(kind)] =
                    reinterpret_cast<GenericMethodType>(GetMethodPointer<Visitor, VisitedThing, ExactVisitedType, ExactMethodType>::get());
            }
        };

        // This handles the default fallback for KIND_OPAQUE. It is specialized for the case where we didn't find a suitable method
        // (MissingOverloagFlag) which means the Visitor didn't overload the visit() method for hkReflect::OpaqueType.
        template <typename Visitor, typename VisitedThing, typename ExactVisitedType, typename Arg1, typename Arg2, typename Arg3>
        struct Assign<Visitor, VisitedThing, ExactVisitedType, MissingOverloadFlag, Arg1, Arg2, Arg3, hkReflect::KIND_OPAQUE>
        {
            HK_ALWAYS_INLINE static void assign();
        };
#endif
        // InitPtrTable recurses through all the kinds from 0 to hkReflect::_KIND_MAX. If the enum has holes hkReflect::TypeFromTag will return hkReflect::InvalidTag
        // and that case will be caught by specializations. For all the valid enum values we find we call Assign<>.
        template <typename Visitor, typename TagToType, typename Arg1 = void, typename Arg2 = void, typename Arg3 = void, unsigned kind = 0,
                  bool hasMethod = !hkTrait::TypesAreEqual<typename hkReflect::TypeFromKind<hkReflect::Kind(kind)>::Type, hkReflect::InvalidTag>::result>
        struct InitPtrTable;

        template <typename Visitor, typename VisitedThing, typename Arg1, typename Arg2, typename Arg3, unsigned kind>
        struct InitPtrTable<Visitor, VisitedThing, Arg1, Arg2, Arg3, kind, true> : public InitPtrTable<Visitor, VisitedThing, Arg1, Arg2, Arg3, kind + 1>
        {
            HK_ALWAYS_INLINE InitPtrTable();
        };

        // Stop on _KIND_MAX. We need to explicitly specialize both cases (hasMethod = true | false) to avoid
        // any ambiguity with the last specialization.
        template <typename Visitor, typename VisitedThing, typename Arg1, typename Arg2, typename Arg3>
        struct InitPtrTable<Visitor, VisitedThing, Arg1, Arg2, Arg3, hkReflect::_KIND_MAX, true>
        {
        };

        template <typename Visitor, typename VisitedThing, typename Arg1, typename Arg2, typename Arg3>
        struct InitPtrTable<Visitor, VisitedThing, Arg1, Arg2, Arg3, hkReflect::_KIND_MAX, false>
        {
        };

#ifndef __HAVOK_PARSER__
        // We found a invalid enum value which isn't _KIND_MAX, skip it and continue on the next one
        template <typename Visitor, typename VisitedThing, typename Arg1, typename Arg2, typename Arg3, unsigned kind>
        struct InitPtrTable<Visitor, VisitedThing, Arg1, Arg2, Arg3, kind, false> : public InitPtrTable<Visitor, VisitedThing, Arg1, Arg2, Arg3, kind + 1>
        {
            HK_ALWAYS_INLINE InitPtrTable()
                : InitPtrTable<Visitor, VisitedThing, Arg1, Arg2, Arg3, kind + 1>()
            {
            }
        };
#endif
        template <typename Visitor, typename VisitedThing, typename RType, typename Arg1, typename Arg2, typename Arg3>
        struct UnaryVisitorBase : public BaseVisitor<Visitor, RType>
        {
#ifndef __HAVOK_PARSER__
            UnaryVisitorBase() { HK_POSSIBLY_UNUSED void* p = &initTable; p = HK_NULL; }
            static Detail::InitPtrTable<Visitor, VisitedThing, Arg1, Arg2, Arg3> initTable;
#endif
        };

#ifndef __HAVOK_PARSER__
        template <typename Visitor, typename VisitedThing, typename RType, typename Arg1, typename Arg2, typename Arg3>
        Detail::InitPtrTable<Visitor, VisitedThing, Arg1, Arg2, Arg3> UnaryVisitorBase<Visitor, VisitedThing, RType, Arg1, Arg2, Arg3>::initTable;
#endif

        template <typename Visitor, typename VisitedThing, typename RType = void, typename Arg1 = void, typename Arg2 = void, typename Arg3 = void>
        struct UnaryVisitor : public UnaryVisitorBase<Visitor, VisitedThing, RType, Arg1, Arg2, Arg3>
        {
            typedef typename GetTagToVisitedType<VisitedThing>::GenericType GenericType;
            typedef RType (Visitor::*callType)(GenericType, Arg1, Arg2, Arg3);
            typedef Arg1 firstArgumentType;
            typedef Arg2 secondArgumentType;
            typedef Arg3 thirdArgumentType;

            RType dispatch(GenericType thing, Arg1 arg1, Arg2 arg2, Arg3 arg3)
            {
                HK_ASSERT_NO_MSG( 0xf03d43df, GetTagToVisitedType<VisitedThing>::isValid(thing) );  // we need this assert since a crash further down results in a callstack corruption.
                Visitor& self = *static_cast<Visitor*>(this);
                callType method = reinterpret_cast<callType>(Detail::PtrTable<Visitor, VisitedThing, Arg1, Arg2, Arg3>::getTable()[GetTagToVisitedType<VisitedThing>::getKind(thing)]);

                return (self.*method)(thing, arg1, arg2, arg3);
            }

            RType visit(typename GetTagToVisitedType<VisitedThing>::OpaqueType type, Arg1 arg1, Arg2 arg2, Arg3 arg3)
            {
                HK_ASSERT(0x19c1ffda, false, "Unexpected Incomplete type encountered during visitation.");
                return dispatch(type, arg1, arg2, arg3); // Infinite loop - crash on release.
            }

            // The wrap method wraps the call to the specific visit() method in order to call the approriate type constructor
            template<typename ExactVisitorType, typename ExactMethodType, typename ExactVisitedType>
            RType wrap(GenericType thing, Arg1 arg1, Arg2 arg2, Arg3 arg3)
            {
                typedef typename hkTrait::RemoveConstRef<ExactVisitedType>::Type Type;
                return (static_cast<Visitor*>(this)->*static_cast<ExactMethodType>(&ExactVisitorType::visit))(Type(thing), arg1, arg2, arg3);
            }
        };

        template <typename Visitor, typename VisitedThing>
        struct UnaryVisitor<Visitor, VisitedThing, void, void, void, void> : public UnaryVisitorBase<Visitor, VisitedThing, void, void, void, void>
        {
            typedef typename GetTagToVisitedType<VisitedThing>::GenericType GenericType;

            void dispatch(GenericType thing)
            {
                HK_ASSERT_NO_MSG( 0xf03d43df, GetTagToVisitedType<VisitedThing>::isValid(thing) );  // we need this assert since a crash further down results in a callstack corruption.
                (static_cast<Visitor*>(this)->*((Detail::PtrTable<Visitor, VisitedThing>::getTable()[GetTagToVisitedType<VisitedThing>::getKind(thing)])))(thing);
            }

            void visit(typename GetTagToVisitedType<VisitedThing>::OpaqueType type)
            {
                HK_ASSERT(0x19c1ffda, false, "Unexpected Incomplete type encountered during visitation.");
                return dispatch(type); // Infinite loop - crash on release.
            }

            // The wrap method wraps the call to the specific visit() method in order to call the approriate type constructor
            template<typename ExactVisitorType, typename ExactMethodType, typename ExactVisitedType>
            void wrap(GenericType thing)
            {
                typedef typename hkTrait::RemoveConstRef<ExactVisitedType>::Type Type;
                (static_cast<Visitor*>(this)->*static_cast<ExactMethodType>(&ExactVisitorType::visit))(Type(thing));
            }
        };

        template <typename Visitor, typename VisitedThing, typename RType>
        struct UnaryVisitor<Visitor, VisitedThing, RType, void, void, void> : public UnaryVisitorBase<Visitor, VisitedThing, RType, void, void, void>
        {
            typedef typename GetTagToVisitedType<VisitedThing>::GenericType GenericType;
            typedef RType (Visitor::*callType)(GenericType);

            RType dispatch(GenericType thing)
            {
                HK_ASSERT_NO_MSG( 0xf03d43df, GetTagToVisitedType<VisitedThing>::isValid(thing) );  // we need this assert since a crash further down results in a callstack corruption.
                Visitor& self = *static_cast<Visitor*>(this);
                callType method = reinterpret_cast<callType>(Detail::PtrTable<Visitor, VisitedThing>::getTable()[GetTagToVisitedType<VisitedThing>::getKind(thing)]);

                return (self.*method)(thing);
            }

            RType visit(typename GetTagToVisitedType<VisitedThing>::OpaqueType type)
            {
                HK_ASSERT(0x19c1ffda, false, "Unexpected Incomplete type encountered during visitation.");
                return dispatch(type); // Infinite loop - crash on release.
            }

            // The wrap method wraps the call to the specific visit() method in order to call the approriate type constructor
            template<typename ExactVisitorType, typename ExactMethodType, typename ExactVisitedType>
            RType wrap(GenericType thing)
            {
                typedef typename hkTrait::RemoveConstRef<ExactVisitedType>::Type Type;
                return (static_cast<Visitor*>(this)->*static_cast<ExactMethodType>(&ExactVisitorType::visit))(Type(thing));
            }
        };

        template <typename Visitor, typename VisitedThing, typename RType, typename Arg1>
        struct UnaryVisitor<Visitor, VisitedThing, RType, Arg1, void, void> : public UnaryVisitorBase<Visitor, VisitedThing, RType, Arg1, void, void>
        {
            typedef typename GetTagToVisitedType<VisitedThing>::GenericType GenericType;
            typedef RType (Visitor::*callType)(GenericType, Arg1);
            typedef Arg1 firstArgumentType;

            RType dispatch(GenericType thing, Arg1 arg1)
            {
                HK_ASSERT_NO_MSG( 0xf03d43df, GetTagToVisitedType<VisitedThing>::isValid(thing) );  // we need this assert since a crash further down results in a callstack corruption.
                Visitor& self = *static_cast<Visitor*>(this);
                callType method = reinterpret_cast<callType>(Detail::PtrTable<Visitor, VisitedThing, Arg1>::getTable()[GetTagToVisitedType<VisitedThing>::getKind(thing)]);

                return (self.*method)(thing, arg1);
            }

            RType visit(typename GetTagToVisitedType<VisitedThing>::OpaqueType type, Arg1 arg1)
            {
                HK_ASSERT(0x19c1ffda, false, "Unexpected Incomplete type encountered during visitation.");
                return dispatch(type, arg1); // Infinite loop - crash on release.
            }

            HK_DETAIL_DIAG_MSVC_PUSH();
            HK_DETAIL_DIAG_MSVC_OFF(4702); // unreachable code
            // The wrap method wraps the call to the specific visit() method in order to call the approriate type constructor
            template<typename ExactVisitorType, typename ExactMethodType, typename ExactVisitedType>
            RType wrap(GenericType thing, Arg1 arg1)
            {
                typedef typename hkTrait::RemoveConstRef<ExactVisitedType>::Type Type;
                return (static_cast<Visitor*>(this)->*static_cast<ExactMethodType>(&ExactVisitorType::visit))(Type(thing), arg1);
            }
            HK_DETAIL_DIAG_MSVC_POP();
        };

        template <typename Visitor, typename VisitedThing, typename RType, typename Arg1, typename Arg2>
        struct UnaryVisitor<Visitor, VisitedThing, RType, Arg1, Arg2, void> : public UnaryVisitorBase<Visitor, VisitedThing, RType, Arg1, Arg2, void>
        {
            typedef typename GetTagToVisitedType<VisitedThing>::GenericType GenericType;
            typedef RType (Visitor::*callType)(GenericType, Arg1, Arg2);
            typedef Arg1 firstArgumentType;
            typedef Arg2 secondArgumentType;

            RType dispatch(GenericType thing, Arg1 arg1, Arg2 arg2)
            {
                HK_ASSERT_NO_MSG( 0xf03d43df, GetTagToVisitedType<VisitedThing>::isValid(thing) );  // we need this assert since a crash further down results in a callstack corruption.
                Visitor& self = *static_cast<Visitor*>(this);
                callType method = reinterpret_cast<callType>(Detail::PtrTable<Visitor, VisitedThing, Arg1, Arg2>::getTable()[GetTagToVisitedType<VisitedThing>::getKind(thing)]);

                return (self.*method)(thing, arg1, arg2);
            }

            RType visit(typename GetTagToVisitedType<VisitedThing>::OpaqueType type, Arg1 arg1, Arg2 arg2)
            {
                HK_ASSERT(0x19c1ffda, false, "Unexpected Incomplete type encountered during visitation.");
                return dispatch(type, arg1, arg2); // Infinite loop - crash on release.
            }

            // The wrap method wraps the call to the specific visit() method in order to call the approriate type constructor
            template<typename ExactVisitorType, typename ExactMethodType, typename ExactVisitedType>
            RType wrap(GenericType thing, Arg1 arg1, Arg2 arg2)
            {
                typedef typename hkTrait::RemoveConstRef<ExactVisitedType>::Type Type;
                return (static_cast<Visitor*>(this)->*static_cast<ExactMethodType>(&ExactVisitorType::visit))(Type(thing), arg1, arg2);
            }
        };

        template <typename Visitor, typename VisitedThing, typename Arg1, typename Arg2, typename Arg3, unsigned ukind>
        HK_ALWAYS_INLINE InitPtrTable<Visitor, VisitedThing, Arg1, Arg2, Arg3, ukind, true>::InitPtrTable()
            : InitPtrTable<Visitor, VisitedThing, Arg1, Arg2, Arg3, ukind + 1>()
            {
    #ifndef __HAVOK_PARSER__
                // If we are here we are sure that Tag is a valid enum value.
                const hkReflect::Kind kind = hkReflect::Kind(ukind);
                typedef typename GetMethod<Visitor, typename Visitor::ReturnType, typename GetTagToVisitedType<VisitedThing>::template GetType<kind>::Type, Arg1, Arg2, Arg3>::Type GetMethodResult;

                typedef typename GetMethodResult::FirstType ExactMethodType;
                typedef typename GetMethodResult::SecondType ExactVisitedType;

                Assign<Visitor, VisitedThing, ExactVisitedType, ExactMethodType, Arg1, Arg2, Arg3, kind>::assign();
    #endif
            }

#ifndef __HAVOK_PARSER__
        // Uses UnaryVisitor, so after that def, but Visitor uses Assign, so inline func at end here
        template <typename Visitor, typename VisitedThing, typename ExactVisitedType, typename Arg1, typename Arg2, typename Arg3>
        HK_ALWAYS_INLINE void Assign<Visitor, VisitedThing, ExactVisitedType, MissingOverloadFlag, Arg1, Arg2, Arg3, hkReflect::KIND_OPAQUE>::assign()
        {
            typedef UnaryVisitor<Visitor, VisitedThing, typename Visitor::ReturnType, Arg1, Arg2, Arg3> VisitorBase;
            typedef typename PtrTable<Visitor, VisitedThing, Arg1, Arg2, Arg3>::methodType GenericMethodType;
            typedef typename GetTagToVisitedType<VisitedThing>::template GetType<hkReflect::KIND_OPAQUE>::Type IncompleteThingType;
            typedef typename MakeMethodType<Visitor, typename Visitor::ReturnType, IncompleteThingType, Arg1, Arg2, Arg3>::Type FallbackMethodType;

            PtrTable<Visitor, VisitedThing, Arg1, Arg2, Arg3>::getTable()[unsigned(hkReflect::KIND_OPAQUE)] =
                reinterpret_cast<GenericMethodType>(GetMethodPointer<VisitorBase, VisitedThing, IncompleteThingType, FallbackMethodType>::get());
        }
#endif

    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
