// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class hkDataObject;
namespace hkSerialize
{
    struct PatchFunctionHelper;
}

namespace hkReflect
{
    namespace Version
    {
        namespace Compat { class DataObject; }
        enum LegacyType
        {
            /// Not reflected.
            TYPE_VOID = 0,

            /// Byte, signed or unsigned 8-bit integer, used only in arrays and tuples
            TYPE_BYTE,
            /// Signed or unsigned 8/16/32/64-bit integer.
            TYPE_INT,
            /// 32-bit float.
            TYPE_REAL,
            /// Fixed array of 4 TYPE_REAL (e.g., hkVector, hkQuaternion).
            TYPE_VEC_4,
            /// Fixed array of 8 TYPE_REAL.
            TYPE_VEC_8,
            /// Fixed array of 12 TYPE_REAL (e.g., hkMatrix3, hkQsTransform, hkRotation).
            TYPE_VEC_12,
            /// Fixed array of 16 TYPE_REAL (e.g., hkTransform, hkMatrix4).
            TYPE_VEC_16,
            /// hkDataObject.
            TYPE_OBJECT,
            /// hkDataObject (embedded struct data).
            TYPE_STRUCT,
            /// C-style string.
            TYPE_CSTRING,
            /// Type described by its string representation
            TYPE_FROMNAME,
            /// The number of basic hkDataObject types.
            TYPE_NUM_BASIC_TYPES,
            /// Mask for the basic hkDataObject types.
            TYPE_MASK_BASIC_TYPES = 0xf,

            /// Bit indicating an array of the basic type data.
            TYPE_ARRAY = 0x10, // per object size array
            /// Array of TYPE_BYTE.
            TYPE_ARRAY_BYTE = TYPE_ARRAY | TYPE_BYTE,
            /// Array of TYPE_INT.
            TYPE_ARRAY_INT = TYPE_ARRAY | TYPE_INT,
            /// Array of TYPE_REAL.
            TYPE_ARRAY_REAL = TYPE_ARRAY | TYPE_REAL,
            /// Array of TYPE_VEC_4.
            TYPE_ARRAY_VEC_4 = TYPE_ARRAY | TYPE_VEC_4,
            /// Array of TYPE_VEC_8.
            TYPE_ARRAY_VEC_8 = TYPE_ARRAY | TYPE_VEC_8,
            /// Array of TYPE_VEC_12.
            TYPE_ARRAY_VEC_12 = TYPE_ARRAY | TYPE_VEC_12,
            /// Array of TYPE_VEC_16.
            TYPE_ARRAY_VEC_16 = TYPE_ARRAY | TYPE_VEC_16,
            /// Array of TYPE_OBJECT.
            TYPE_ARRAY_OBJECT = TYPE_ARRAY | TYPE_OBJECT,
            /// Array of TYPE_STRUCT.
            TYPE_ARRAY_STRUCT = TYPE_ARRAY | TYPE_STRUCT,
            /// Array of TYPE_CSTRING.
            TYPE_ARRAY_CSTRING = TYPE_ARRAY | TYPE_CSTRING,

            /// Bit indicating a tuple of the basic type data.
            TYPE_TUPLE = 0x20, // fixed size array, size is per class
            /// Tuple of TYPE_BYTE.
            TYPE_TUPLE_BYTE = TYPE_TUPLE | TYPE_BYTE,
            /// Tuple of TYPE_INT.
            TYPE_TUPLE_INT = TYPE_TUPLE | TYPE_INT,
            /// Tuple of TYPE_REAL.
            TYPE_TUPLE_REAL = TYPE_TUPLE | TYPE_REAL,
            /// Tuple of TYPE_VEC_4.
            TYPE_TUPLE_VEC_4 = TYPE_TUPLE | TYPE_VEC_4,
            /// Tuple of TYPE_VEC_8.
            TYPE_TUPLE_VEC_8 = TYPE_TUPLE | TYPE_VEC_8,
            /// Tuple of TYPE_VEC_12.
            TYPE_TUPLE_VEC_12 = TYPE_TUPLE | TYPE_VEC_12,
            /// Tuple of TYPE_VEC_16.
            TYPE_TUPLE_VEC_16 = TYPE_TUPLE | TYPE_VEC_16,
            /// Tuple of TYPE_OBJECT.
            TYPE_TUPLE_OBJECT = TYPE_TUPLE | TYPE_OBJECT,
            /// Tuple of TYPE_STRUCT.
            TYPE_TUPLE_STRUCT = TYPE_TUPLE | TYPE_STRUCT,
            /// Tuple of TYPE_CSTRING.
            TYPE_TUPLE_CSTRING = TYPE_TUPLE | TYPE_CSTRING,
        };



        /// Class defining a versioning patch for reflected class.
        struct HK_EXPORT_COMMON PatchInfo
        {
            enum PatchType
            {
                PATCH_INVALID = 0,

                // Any components of these types force versioning to use the 2014.2 pipeline (or fail if this isn't registered)
                PATCH_MEMBER_ADDED,
                PATCH_MEMBER_REMOVED,
                PATCH_MEMBER_RENAMED,
                PATCH_MEMBER_DEFAULT_SET,

                PATCH_DATAOBJECT_FUNCTION,

                PATCH_CAST,

                PATCH_DEPENDS,

                PATCH_PARENT_SET,

                PATCH_VAR_FUNCTION,

                PATCH_TYPED_MEMBER_ADDED,
                PATCH_TYPED_MEMBER_REMOVED,

                PATCH_TYPE_CHANGED,
                PATCH_VAR_TYPE_CHANGED,

                
                PATCH_TYPE_TEMPLATE_PARAMETER_ADDED,
                PATCH_VALUE_TEMPLATE_PARAMETER_ADDED,
                PATCH_TYPE_TEMPLATE_PARAMETER_REMOVED,
                PATCH_VALUE_TEMPLATE_PARAMETER_REMOVED,

                PATCH_SET_VALUE,

                PATCH_END
            };

            /// Set class version dependency in patch.
            struct HK_EXPORT_COMMON DependsPatch
            {
                enum { PATCH_TYPE = PATCH_DEPENDS };
                HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SERIALIZE, DependsPatch);
                const char* name; ///< Class name of dependency
                hkInt32 version; ///< Class version of dependency
            };

            /// Define class member renamed in patch.
            struct HK_EXPORT_COMMON MemberRenamedPatch
            {
                enum { PATCH_TYPE = PATCH_MEMBER_RENAMED };
                HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SERIALIZE, MemberRenamedPatch);
                const char* oldName; ///< Old name
                const char* newName; ///< New name
            };

            /// Define class member added in patch.
            struct HK_EXPORT_COMMON MemberAddedPatch
            {
                enum { PATCH_TYPE = PATCH_MEMBER_ADDED };
                HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SERIALIZE, MemberAddedPatch);
                const char* name; ///< Name of the new member.
                LegacyType type; ///< Type of the new member.
                const char* typeName; ///< Name of class or null for basic types.
                hkInt32 tuples; ///< The number of elements in a c-style array, usually zero for "not an c-array".
                const void* defaultPtr; ///< Pointer to default value, if given.
            };

            /// Define class member removed in patch.
            struct HK_EXPORT_COMMON MemberRemovedPatch
            {
                HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SERIALIZE, MemberRemovedPatch);
                enum { PATCH_TYPE = PATCH_MEMBER_REMOVED };
                const char* name; ///< Name of the removed member
                LegacyType type; ///< Type of the removed member
                const char* typeName;  ///< Class name of the removed member or null for basic types.
                hkInt32 tuples;  ///< Count of elements in c-style array or zero for "not a c-array".
            };

            /// Set class parent in patch.
            struct HK_EXPORT_COMMON SetParentPatch
            {
                HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SERIALIZE, SetParentPatch);
                enum { PATCH_TYPE = PATCH_PARENT_SET };
                const char* oldParent; ///< Old parent
                const char* newParent; ///< New parent
            };

            typedef void (HK_CALL *DataObjectFunction)(hkDataObject& o); // hkReflect::Version::Compat::DataObject

            /// Set function to be called in patch.
            struct HK_EXPORT_COMMON DataObjectFunctionPatch
            {
                HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SERIALIZE, DataObjectFunctionPatch);
                enum { PATCH_TYPE = PATCH_DATAOBJECT_FUNCTION };
                const char* name; ///< Name of the function as a string for debugging.
                DataObjectFunction function; ///< Function pointer.
            };

            typedef void (HK_CALL *VarFunction)(hkReflect::Var o, hkSerialize::PatchFunctionHelper& helper);

            struct HK_EXPORT_COMMON VarFunctionPatch
            {
                HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SERIALIZE, VarFunctionPatch);
                enum { PATCH_TYPE = PATCH_VAR_FUNCTION };
                const char* name; ///< Name of the function as a string for debugging.
                VarFunction function; ///< Function pointer.
            };

            typedef void (HK_CALL *TypeChangedFunction)(hkDataObject& o, _In_z_ const char* oldName, _In_z_ const char* newName); // hkReflect::Version::Compat::DataObject

            struct HK_EXPORT_COMMON TypeChangedFunctionPatch
            {
                enum { PATCH_TYPE = PATCH_TYPE_CHANGED };

                const char* m_name; ///< Name of the new member.
                LegacyType m_oldType; ///< Type of the new member.
                const char* m_oldTypeName; ///< Name of class or null for basic types.
                hkInt32 m_oldTuples; ///< The number of elements in a c-style array, usually zero for "not an c-array".
                LegacyType m_newType; ///< Type of the new member.
                const char* m_newTypeName; ///< Name of class or null for basic types.
                hkInt32 m_newTuples; ///< The number of elements in a c-style array, usually zero for "not an c-array".
                TypeChangedFunction m_function;
            };

            typedef void (HK_CALL *VarTypeChangedFunction)(hkReflect::Var o, hkSerialize::PatchFunctionHelper& helper, _In_z_ const char* oldName, _In_z_ const char* newName); // hkReflect::Version::Compat::DataObject

            struct HK_EXPORT_COMMON VarTypeChangedFunctionPatch
            {
                enum { PATCH_TYPE = PATCH_VAR_TYPE_CHANGED };

                const char* m_name; ///< Name of the new member.
                const char* m_oldType; ///< Type of the new member.
                const char* m_newType; ///< Type of the new member.
                VarTypeChangedFunction m_function;
            };

            /// Set cast to class in patch.
            struct HK_EXPORT_COMMON CastPatch
            {
                HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SERIALIZE, CastPatch);
                enum { PATCH_TYPE = PATCH_CAST };
                const char* name;
            };

            /// Default changed for class member in patch.
            struct HK_EXPORT_COMMON DefaultChangedPatch
            {
                enum { PATCH_TYPE = PATCH_MEMBER_DEFAULT_SET };
                HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SERIALIZE, DefaultChangedPatch);
                const char* name; ///< Name of the member.
                const void* defaultPtr; ///< Pointer to new default value
            };

            /// Define class member added in patch.
            struct HK_EXPORT_COMMON TypedMemberAddedPatch
            {
                enum { PATCH_TYPE = PATCH_MEMBER_ADDED };
                HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SERIALIZE, TypedMemberAddedPatch);
                const char* name; ///< Name of the new member.
                const hkReflect::Type* type;
            };

            /// Define class member removed in patch.
            struct HK_EXPORT_COMMON TypedMemberRemovedPatch
            {
                HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SERIALIZE, TypedMemberRemovedPatch);
                enum { PATCH_TYPE = PATCH_MEMBER_REMOVED };
                const char* name; ///< Name of the removed member
                const hkReflect::Type* type;
            };

            struct HK_EXPORT_COMMON TypeTemplateParameterAddedPatch
            {
                HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SERIALIZE, TypeTemplateParameterAddedPatch);
                enum { PATCH_TYPE = PATCH_TYPE_TEMPLATE_PARAMETER_ADDED };
                const char* name; ///< Name of the type parameter
                const char* defaultTypeName;
            };

            struct HK_EXPORT_COMMON TypeTemplateParameterRemovedPatch
            {
                HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SERIALIZE, TypeTemplateParameterRemovedPatch);
                enum { PATCH_TYPE = PATCH_TYPE_TEMPLATE_PARAMETER_REMOVED };
                const char* name; ///< Name of the type parameter
                const char* defaultTypeName;
            };

            struct HK_EXPORT_COMMON ValueTemplateParameterAddedPatch
            {
                HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SERIALIZE, ValueTemplateParameterAddedPatch);
                enum { PATCH_TYPE = PATCH_VALUE_TEMPLATE_PARAMETER_ADDED };
                const char* name; ///< Name of the type parameter
                hkUlong defaultValue;
            };

            struct HK_EXPORT_COMMON ValueTemplateParameterRemovedPatch
            {
                HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SERIALIZE, ValueTemplateParameterRemovedPatch);
                enum { PATCH_TYPE = PATCH_VALUE_TEMPLATE_PARAMETER_REMOVED };
                const char* name; ///< Name of the type parameter
                hkUlong defaultValue;
            };

            struct HK_EXPORT_COMMON SetValuePatch
            {
                HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SERIALIZE, SetValuePatch);
                enum { PATCH_TYPE = PATCH_SET_VALUE };
                const char* m_name; ///< Name of the type parameter
                hkReflect::QualType (*m_type)(); // pointer to hkReflect::getType<TYPE>, this indirection allows the SetValuePatch struct to be compile-time const
                const void* m_value;
            };

            /// Class defining a component of the versioning patch, e.g., add and/or remove class member.
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SERIALIZE, PatchInfo);
            struct Component
            {
                HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SERIALIZE, Component);
                PatchType type;
                const void* patch;

                _Ret_maybenull_ const DependsPatch* asDependsPatch() const { return (type == PATCH_DEPENDS ? reinterpret_cast<const DependsPatch*>(patch) : HK_NULL); }
                _Ret_maybenull_ const MemberRenamedPatch* asMemberRenamedPatch() const { return (type == PATCH_MEMBER_RENAMED ? reinterpret_cast<const MemberRenamedPatch*>(patch) : HK_NULL); }
                _Ret_maybenull_ const MemberAddedPatch* asMemberAddedPatch() const { return (type == PATCH_MEMBER_ADDED ? reinterpret_cast<const MemberAddedPatch*>(patch) : HK_NULL); }
                _Ret_maybenull_ const MemberRemovedPatch* asMemberRemovedPatch() const { return (type == PATCH_MEMBER_REMOVED ? reinterpret_cast<const MemberRemovedPatch*>(patch) : HK_NULL); }
                _Ret_maybenull_ const SetParentPatch* asSetParentPatch() const { return (type == PATCH_PARENT_SET ? reinterpret_cast<const SetParentPatch*>(patch) : HK_NULL); }
                _Ret_maybenull_ const DataObjectFunctionPatch* asDataObjectFunctionPatch() const { return (type == PATCH_DATAOBJECT_FUNCTION ? reinterpret_cast<const DataObjectFunctionPatch*>(patch) : HK_NULL); }
                _Ret_maybenull_ const VarFunctionPatch* asVarFunctionPatch() const { return (type == PATCH_VAR_FUNCTION ? reinterpret_cast<const VarFunctionPatch*>(patch) : HK_NULL); }
                _Ret_maybenull_ const CastPatch* asCastPatch() const { return (type == PATCH_CAST ? reinterpret_cast<const CastPatch*>(patch) : HK_NULL); }
                _Ret_maybenull_ const DefaultChangedPatch* asDefaultChangedPatch() const { return (type == PATCH_MEMBER_DEFAULT_SET ? reinterpret_cast<const DefaultChangedPatch*>(patch) : HK_NULL); }
                _Ret_maybenull_ const TypedMemberAddedPatch* asTypedMemberAddedPatch() const { return (type == PATCH_TYPED_MEMBER_ADDED ? reinterpret_cast<const TypedMemberAddedPatch*>(patch) : HK_NULL); }
                _Ret_maybenull_ const TypedMemberRemovedPatch* asTypedMemberRemovedPatch() const { return (type == PATCH_TYPED_MEMBER_REMOVED ? reinterpret_cast<const TypedMemberRemovedPatch*>(patch) : HK_NULL); }
                _Ret_maybenull_ const TypeTemplateParameterAddedPatch* asTypeTemplateParameterAddedPatch() const { return (type == PATCH_TYPE_TEMPLATE_PARAMETER_ADDED ? reinterpret_cast<const TypeTemplateParameterAddedPatch*>(patch) : HK_NULL); }
                _Ret_maybenull_ const TypeTemplateParameterRemovedPatch* asTypeTemplateParameterRemovedPatch() const { return (type == PATCH_TYPE_TEMPLATE_PARAMETER_REMOVED ? reinterpret_cast<const TypeTemplateParameterRemovedPatch*>(patch) : HK_NULL); }
                _Ret_maybenull_ const ValueTemplateParameterAddedPatch* asValueTemplateParameterAddedPatch() const { return (type == PATCH_VALUE_TEMPLATE_PARAMETER_ADDED ? reinterpret_cast<const ValueTemplateParameterAddedPatch*>(patch) : HK_NULL); }
                _Ret_maybenull_ const ValueTemplateParameterRemovedPatch* asValueTemplateParameterRemovedPatch() const { return (type == PATCH_VALUE_TEMPLATE_PARAMETER_REMOVED ? reinterpret_cast<const ValueTemplateParameterRemovedPatch*>(patch) : HK_NULL); }
                _Ret_maybenull_ const TypeChangedFunctionPatch* asTypeChangedFunctionPatch() const { return (type == PATCH_TYPE_CHANGED ? reinterpret_cast<const TypeChangedFunctionPatch*>(patch) : HK_NULL); }
                _Ret_maybenull_ const VarTypeChangedFunctionPatch* asVarTypeChangedFunctionPatch() const { return (type == PATCH_VAR_TYPE_CHANGED ? reinterpret_cast<const VarTypeChangedFunctionPatch*>(patch) : HK_NULL); }
                _Ret_maybenull_ const SetValuePatch* asSetValuePatch() const { return (type == PATCH_SET_VALUE ? reinterpret_cast<const SetValuePatch*>(patch) : HK_NULL); }
            };
            const char* oldName;
            const char* newName;
            hkInt32 oldVersion;
            hkInt32 newVersion;
            const Component* component;
            hkInt32 numComponent;
            bool m_isNewPatch; // TODO: This is a bit inefficient, we could easily encode this somewhere else without adding 4 bytes to every patch. It will probably change to new patch types anyway
            bool m_isCombine;

            // We have zero component patches that are compat renames, for now everything is a compat patch
            bool isV2Patch() const { return m_isNewPatch; }
            bool isCompatPatch() const { return !m_isNewPatch; }
            bool isClassAdded() const { return oldVersion == -1; }
            bool isCombine() const { return m_isCombine; }
        };
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
