// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

namespace hkSerialize { class Bundle; }

namespace hkReflect
{
    namespace Version
    {
        class PatchSet;
        class PatchInfoCache;
        class PatchRegistry;


        // This is used for the compat patcher, maybe could move somewhere else??
        class PatcherInterface2014 : public hkReferencedObject
        {
        public:
            HK_DECLARE_CLASS( PatcherInterface2014, New );

            virtual hkViewPtr<hkSerialize::Bundle> applyPatchesTo(hkViewPtr<hkSerialize::Bundle> bundleIn, _In_ hkReflect::Version::PatchSet* patchSet) = 0;
            virtual ~PatcherInterface2014() {}

            // Registration helper. Allows for the implementation to be stripped if it is not registered.
            typedef PatcherInterface2014* (HK_CALL *CreatePatcherFn)(const hkReflect::TypeReg* cb, hkReflect::Version::PatchSet& patches);
            static HK_EXPORT_COMMON CreatePatcherFn s_createPatcher;
        };


        class PatcherInterface : public hkReferencedObject
        {
        public:
            HK_DECLARE_CLASS( PatcherInterface, New );

            // Create a patcher implementation.
            // Returns NULL if no patcher is registered.
            static inline hkRefPtr<PatcherInterface> create( hkReflect::Version::PatchRegistry* patchReg = nullptr )
            {
                return s_createPatcher ? s_createPatcher(patchReg) : nullptr;
            }

            virtual hkViewPtr<hkSerialize::Bundle> applyPatchesTo( hkViewPtr<hkSerialize::Bundle> bundleIn, _In_opt_ hkReflect::MutableTypeReg* typeReg = HK_NULL,
                _In_opt_ hkReflect::Version::PatchRegistry* patchReg = HK_NULL, bool failIfVersioningRequired = false ) = 0;
            virtual _Ret_maybenull_ hkReflect::Version::PatchInfoCache* getPatchInfoCache() = 0;

            // Registration helper. Allows for the implementation to be stripped if it is not registered.
            typedef hkRefPtr<PatcherInterface> (HK_CALL *CreatePatcherFn)(hkReflect::Version::PatchRegistry* optionalPatchReg);
            static HK_EXPORT_COMMON CreatePatcherFn s_createPatcher;
        };
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
