// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Reflect/Version/hkReflectVersionPatcher.h>
#include <Common/Base/Reflect/Version/hkReflectVersionPatches.h>
#include <Common/Base/Reflect/Version/hkReflectPatchRegistry.h>
#include <Common/Base/Serialize/Core/hkSerializeCore.h>
#include <Common/Base/Reflect/TypeReg/hkTypeReg.h>
#include <Common/Base/Serialize/Version/hkVersionBundle.h>
#include <Common/Base/Config/hkOptionalComponent.h>

namespace hkReflect
{
    namespace Version
    {
        class Patcher : public PatcherInterface
        {
        public:
            HK_DECLARE_CLASS( Patcher, New );

            Patcher( _In_opt_ hkReflect::Version::PatchRegistry* patchReg = HK_NULL );
            virtual ~Patcher();

            virtual hkViewPtr<hkSerialize::Bundle> applyPatchesTo( hkViewPtr<hkSerialize::Bundle> bundleIn, _In_opt_ hkReflect::MutableTypeReg* typeReg = HK_NULL
                , _In_opt_ hkReflect::Version::PatchRegistry* patchReg = HK_NULL, bool failIfVersioningRequired = false ) HK_OVERRIDE;
            virtual _Ret_maybenull_ hkReflect::Version::PatchInfoCache* getPatchInfoCache() HK_OVERRIDE { return m_patchInfoCache; }

        private:
            hkRefPtr<hkReflect::Version::PatchRegistry> m_patchReg;
            hkRefPtr<hkReflect::Version::PatchInfoCache> m_patchInfoCache;
            hkRefPtr<hkReflect::Version::PatchSet> m_patchSet;
            class Impl;
            Impl* m_impl;
        };

        class Patcher::Impl
        {
        public:
            HK_DECLARE_CLASS(Impl, New);

            hkViewPtr<hkSerialize::Bundle> applyPatchesTo(hkViewPtr<hkSerialize::Bundle> bundleIn, _Inout_ hkReflect::Version::PatchSet* patchSet, _Inout_ hkReflect::MutableTypeReg* typeReg)
            {
                hkArrayView<const hkReflect::Version::PatchInfo*> patches = patchSet->getPatchList();

                hkViewPtr<hkSerialize::Bundle> thisBundle = bundleIn;

                // We need this to run backwards from the compiled types
                if (patchSet->containsV2Patches())
                {
                    if (!m_versionBundle)
                    {
                        m_versionBundle.setAndDontIncrementRefCount(new hkSerialize::VersionBundle(patchSet->getReg(), *typeReg));
                    }
                }

                if(patchSet->containsCompatPatches())
                {
                    if (hkReflect::Version::PatcherInterface2014::s_createPatcher != HK_NULL)
                    {
                        if (patchSet->containsV2Patches())
                        {
                            // We need a custom typereg that will reverse the new patching to get the output from the old system
                            // This doesn't exist yet, we can't mix old and new
                            typeReg = m_versionBundle->createBackwardCompatibleTypeReg();
                            //HK_ASSERT(0x4341dc0a, 0);
                        }

                        if (!m_compatPatcher)
                        {
                            m_compatPatcher.setAndDontIncrementRefCount(hkReflect::Version::PatcherInterface2014::s_createPatcher(typeReg, *patchSet));
                        }
                        // This will skip any new patches
                        thisBundle = m_compatPatcher->applyPatchesTo(bundleIn, patchSet);
                    }
                    else
                    {
                        HK_WARN_ONCE(0xd09301ef, "Versioning is trying to create a patcher but there is no registered patcher creation function. Ensure you have linked against hkCompat and not excluded it from hkProductFeatures");
                        return HK_NULL;
                    }
                }
                if (patchSet->containsV2Patches())
                {
                    return m_versionBundle->applyPatchesTo(thisBundle, false); // Fail if versioning??
                }
                else
                {
                    return thisBundle;
                }
            }

            hkRefPtr<class hkReflect::Version::PatcherInterface2014> m_compatPatcher;
            hkRefPtr<class hkSerialize::VersionBundle> m_versionBundle;
        };

        Patcher::Patcher(_In_opt_ hkReflect::Version::PatchRegistry* patchReg) : m_patchReg(patchReg), m_impl(HK_NULL)
        {
        }

        hkViewPtr<hkSerialize::Bundle> Patcher::applyPatchesTo(hkViewPtr<hkSerialize::Bundle> bundleIn, _In_opt_ hkReflect::MutableTypeReg* typeReg
                                                                , _In_opt_ hkReflect::Version::PatchRegistry* patchReg, bool failIfVersioningRequired)
        {
            if (!typeReg)
            {
                typeReg = hkReflect::getTypeReg();
            }
            if (!patchReg)
            {
                patchReg = m_patchReg ? m_patchReg.val() : hkReflect::Version::PatchRegistry::getInstancePtr();
            }
            if (!m_patchInfoCache)
            {
                m_patchInfoCache.setAndDontIncrementRefCount(new hkReflect::Version::PatchInfoCache());
            }
            if (!m_patchSet)
            {
                m_patchSet.setAndDontIncrementRefCount(new hkReflect::Version::PatchSet(*patchReg, typeReg, m_patchInfoCache));
                hkResult res = m_patchSet->addPatchesNeededFor(bundleIn->types());
                if (!res.isSuccess())
                {
                    HK_ASSERT_NO_MSG(0xb42979b, 0); // Some failure in patching, need better messages here
                    return HK_NULL;
                }
            }

            // First, see if any versioning is required
            if (m_patchSet->isNotEmpty())
            {
                if (failIfVersioningRequired)
                {
                    return HK_NULL;
                }
                if (m_impl)
                {
                    delete m_impl;
                }
                m_impl = new Impl();
                hkViewPtr<hkSerialize::Bundle> res = m_impl->applyPatchesTo(bundleIn, m_patchSet, typeReg);
                return res;
            }

            return bundleIn;
        }

        Patcher::~Patcher()
        {
            delete m_impl;
        }
    }
}


#ifndef HK_DYNAMIC_DLL
static
#endif
hkRefPtr<hkReflect::Version::PatcherInterface> s_createPatcherImplementation( hkReflect::Version::PatchRegistry* patchReg )
{
    HK_OPTIONAL_COMPONENT_MARK_USED( hkPatcher );
    return hk::makeRef<hkReflect::Version::Patcher>(patchReg);
}

HK_OPTIONAL_COMPONENT_DEFINE( hkPatcher, hkReflect::Version::Patcher::s_createPatcher, s_createPatcherImplementation );

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
