// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

// Note that anything that refers to the dll-local statics (s_listHead etc) MUST be in this file
// If it is in the cpp, it will always see the Common version and will ignore whatever the dll has done
#include <Common/Base/Reflect/Version/hkReflectPatchRegistry.h>

hkReflect::Detail::PatchesRegNode* hkReflect::Detail::PatchesRegNode::s_listHead = HK_NULL;
bool hkReflect::Detail::PatchesRegNode::s_accessedHead = false;

#define POINTER_CLEAR_BITS(v) POINTER_CLEAR_BIT(v, 0x03)
#define POINTER_CLEAR_BIT(v,b) hkClearBits(v, b)

_Ret_maybenull_ hkReflect::Detail::PatchesRegNode* HK_CALL hkReflect::Detail::PatchesRegNode::getFirstLocalEntry()
{
    s_accessedHead = true;
    return POINTER_CLEAR_BITS(s_listHead);
}

#undef POINTER_CLEAR_BITS
#undef POINTER_CLEAR_BIT

hkResult HK_CALL hkReflect::Detail::PatchesRegNode::addToBuiltinRegistry(_In_opt_ void*)
{
    if (hkReflect::Version::PatchRegistry::getInstancePtr())
    {
        if (hkReflect::Detail::PatchesRegNode* patchesRegNode = getFirstLocalEntry())
        {
            addToBuiltinRegistry(patchesRegNode);
        }
        return HK_SUCCESS;
    }
    return HK_FAILURE;
}

hkResult HK_CALL hkReflect::Detail::PatchesRegNode::removeFromBuiltinRegistry(_In_opt_ void*)
{
    if (hkReflect::Version::PatchRegistry::getInstancePtr())
    {
        if (hkReflect::Detail::PatchesRegNode* patchesRegNode = getFirstLocalEntry())
        {
            removeFromBuiltinRegistry(patchesRegNode);
        }
        return HK_SUCCESS;
    }
    return HK_FAILURE;
}

static hkBaseSystem::InitNode s_initVersionPatches("Register Patches",
    &hkReflect::Detail::PatchesRegNode::addToBuiltinRegistry,
    &hkReflect::Detail::PatchesRegNode::removeFromBuiltinRegistry);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
