// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

namespace hkReflect {
namespace Version { class PatchHandler; }
namespace Detail {

/// Static instances of this class are in the generated reflection
/// files. This ensures all known types are added on startup.o
/// The file hkPatchesRegNode.hxx should be included in any DLL which contains reflection data.
struct PatchesRegNode
{
public:
    typedef void (*RegistrationFunction)(hkReflect::Version::PatchHandler& man);

    HK_DECLARE_CLASS(PatchesRegNode, NoNew);

    /// Constructor which automatically registers the entry.
    /// This should only be used in static data.
    inline PatchesRegNode(RegistrationFunction type);

    /// Constructor which doesn't automatically register the entry.
    inline PatchesRegNode(RegistrationFunction type, PatchesRegNode* next);

    ///
    inline _Ret_maybenull_ PatchesRegNode* getNext();
    inline _Ret_maybenull_ const PatchesRegNode* getNext() const;


public:

    static hkResult HK_CALL addToBuiltinRegistry(_In_opt_ void*);
    static hkResult HK_CALL removeFromBuiltinRegistry(_In_opt_ void*);
    static _Ret_maybenull_ PatchesRegNode* HK_CALL getFirstLocalEntry();

private:

    static HK_EXPORT_COMMON void addToBuiltinRegistry(_In_opt_ PatchesRegNode* head);
    static HK_EXPORT_COMMON void removeFromBuiltinRegistry(_In_opt_ PatchesRegNode* head);

    /// A list corresponding to the types in a library.
    /// This list gets merged with the lists of other projects by the type registry.
    mutable PatchesRegNode* m_next;

    RegistrationFunction m_function;

    static hkReflect::Detail::PatchesRegNode* s_listHead;
    static bool s_accessedHead;
};

}
}

#define POINTER_CLEAR_BITS(v) POINTER_CLEAR_BIT(v, 0x03)
#define POINTER_CLEAR_BIT(v,b) hkClearBits(v, b)

hkReflect::Detail::PatchesRegNode::PatchesRegNode(hkReflect::Detail::PatchesRegNode::RegistrationFunction fn) : m_next(POINTER_CLEAR_BITS(s_listHead)), m_function(fn)
{
    HK_ASSERT(0x23b111a0, !s_accessedHead, "This constructor automatically registers patches, and is intended only for the static initialization in excutables and dynamic libraries.");
    s_listHead = this;
}

hkReflect::Detail::PatchesRegNode::PatchesRegNode(hkReflect::Detail::PatchesRegNode::RegistrationFunction fn, _In_opt_ PatchesRegNode* next) : m_next(HK_NULL), m_function(fn)
{

}

_Ret_maybenull_ hkReflect::Detail::PatchesRegNode* hkReflect::Detail::PatchesRegNode::getNext()
{
    return POINTER_CLEAR_BITS(m_next);
}

_Ret_maybenull_ const hkReflect::Detail::PatchesRegNode* hkReflect::Detail::PatchesRegNode::getNext() const
{
    return POINTER_CLEAR_BITS(m_next);
}

#undef POINTER_CLEAR_BITS
#undef POINTER_CLEAR_BIT

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
