// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/System/hkBaseSystem.h>
#include <Common/Base/Reflect/Version/hkPatchesRegNode.h>
#if defined(HK_DYNAMIC_DLL)
// In the dll build, each dll has its own copy of the init list
#include <Common/Base/Reflect/Version/hkPatchesRegNode.hxx>
#endif

#include <Common/Base/Reflect/Version/hkReflectPatchRegistry.h>

void HK_EXPORT_COMMON hkReflect::Detail::PatchesRegNode::addToBuiltinRegistry(_In_opt_ PatchesRegNode* originalHead)
{
    if (originalHead)
    {
        hkReflect::Version::PatchAdder adder;
        for (PatchesRegNode* head = originalHead; head; head = head->getNext())
        {
            head->m_function(adder);
        }
    }
}

void HK_EXPORT_COMMON hkReflect::Detail::PatchesRegNode::removeFromBuiltinRegistry(_In_opt_ PatchesRegNode* originalHead)
{
    if (originalHead)
    {
        hkReflect::Version::PatchRemover adder;
        for (PatchesRegNode* head = originalHead; head; head = head->getNext())
        {
            head->m_function(adder);
        }
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
