// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

namespace hkReflect
{
        /// Utility to allow custom conversion rules between vars of possibly different types.
        /// Static methods are provided which each perform a single conversion.
        /// You can also use an instance of this class to manage a set of allowed conversions.
    class HK_EXPORT_COMMON VarCoerce
    {
        public:

                /// Try to convert from src to dst.
            typedef bool (*ConvertFunc)(const hkReflect::Var& dst, const hkReflect::Var& src);

                /// Initially, no kinds convert to any other kind.
            VarCoerce();

                /// Register a function to allow conversion between vars of the given kinds.
            template<hkReflect::Kind DST, hkReflect::Kind SRC>
            void allow(bool (*func)( const typename hkReflect::VarFromKind<DST>::Type& dst, const typename hkReflect::VarFromKind<SRC>::Type& src ) )
            {
                m_conversions[DST][SRC] = hkBitCast<ConvertFunc>(func);
            }

                /// Disallow conversion between vars of the given kinds.
            void disallow(hkReflect::Kind dst, hkReflect::Kind src);

                /// Copy into dst from src.
            bool copy(const hkReflect::Var& dst, const hkReflect::Var& src) const;

        public:

            // Static functions which do a best effort attempt to convert the value.

            static bool boolFromBool(const BoolVar& dst, const BoolVar& src);
            static bool boolFromInt(const BoolVar& dst, const IntVar& src);
            static bool boolFromFloat(const BoolVar& dst, const FloatVar& src);
                // null string is false, all other values are true
            static bool boolFromString(const BoolVar& dst, const StringVar& src);

            static bool intFromBool(const IntVar& dst, const BoolVar& src);
            static bool intFromInt(const IntVar& dst, const IntVar& src);
            static bool intFromFloat(const IntVar& dst, const FloatVar& src);
            static bool intFromString(const IntVar& dst, const StringVar& src);

            static bool floatFromBool(const FloatVar& dst, const BoolVar& src);
            static bool floatFromInt(const FloatVar& dst, const IntVar& src);
            static bool floatFromFloat(const FloatVar& dst, const FloatVar& src);
            static bool floatFromString(const FloatVar& dst, const StringVar& src);

        private:
                // DST is always on the left (first index)
            ConvertFunc m_conversions[hkReflect::_KIND_MAX][hkReflect::_KIND_MAX];
    };
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
