// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/Reflect/Util/hkVarCoerce.h>
#include <Common/Base/System/Io/Util/hkFloatParseUtil.h>


hkReflect::VarCoerce::VarCoerce()
{
    hkMemUtil::memSet( m_conversions, 0, sizeof(m_conversions));
    allow<KIND_INT,KIND_INT>( &intFromInt );
    allow<KIND_BOOL,KIND_BOOL>( &boolFromBool );
    allow<KIND_FLOAT,KIND_FLOAT>( &floatFromFloat );
}

void hkReflect::VarCoerce::disallow(hkReflect::Kind dst, hkReflect::Kind src)
{
    m_conversions[dst][src] = HK_NULL;
}

bool hkReflect::VarCoerce::copy(const hkReflect::Var& dst, const hkReflect::Var& src) const
{
    HK_ASSERT_NO_MSG(0x1382cd96, dst);
    hkReflect::Kind sk = src.getType()->getKind();
    hkReflect::Kind dk = dst.getType()->getKind();
    if( ConvertFunc func = m_conversions[dk][sk] )
    {
        return (*func)(dst,src);
    }
    return false;
}


bool hkReflect::VarCoerce::boolFromBool(const BoolVar& dst, const BoolVar& src)
{
    HK_ASSERT_NO_MSG(0x6464ad4b, dst);
    return dst.setValue( src.getValue() ).isSuccess();
}

bool hkReflect::VarCoerce::boolFromInt(const BoolVar& dst, const IntVar& src)
{
    HK_ASSERT_NO_MSG(0x58a70f7c, dst);
    return dst.setValue( src.getValue().absValue() != 0 ).isSuccess();
}

bool hkReflect::VarCoerce::boolFromFloat(const BoolVar& dst, const FloatVar& src)
{
    HK_ASSERT_NO_MSG(0x78a92210, dst);
    return dst.setValue(src.getValue() != 0).isSuccess();
}

bool hkReflect::VarCoerce::boolFromString(const BoolVar& dst, const StringVar& src)
{
    HK_ASSERT_NO_MSG(0x50843c24, dst);
    return dst.setValue(src.getValue() != HK_NULL).isSuccess();
}


bool hkReflect::VarCoerce::intFromBool(const IntVar& dst, const BoolVar& src)
{
    HK_ASSERT_NO_MSG(0x43e8a802, dst);
    return dst.setValue(src.getValue() ? 1 : 0).isSuccess();
}

bool hkReflect::VarCoerce::intFromInt(const IntVar& dst, const IntVar& src)
{
    HK_ASSERT_NO_MSG(0xdbee7d3, dst);
    return dst.setValue(src.getValue()).isSuccess();
}

bool hkReflect::VarCoerce::intFromFloat(const IntVar& dst, const FloatVar& src)
{
    HK_ASSERT_NO_MSG(0x5c34edbf, dst);
    FloatValue fv = src.getValue();
    IntValue iv; iv.set(hkUint64(hkMath::fabs(fv)), fv < 0.0);
    return dst.setValue(iv).isSuccess();
}

bool hkReflect::VarCoerce::intFromString(const IntVar& dst, const StringVar& src)
{
    HK_ASSERT_NO_MSG(0xfb62afb, dst);
    if(const char* s = src.getValue())
    {
        if (dst.getType()->isSigned())
        {
            return dst.setValue(hkString::atoll( s )).isSuccess();
        }
        else
        {
            return dst.setValue(hkString::atoull( s )).isSuccess();
        }
    }
    return false;
}


bool hkReflect::VarCoerce::floatFromBool(const FloatVar& dst, const BoolVar& src)
{
    HK_ASSERT_NO_MSG(0x24d7f842, dst);
    return dst.setValue(src.getValue() ? 1 : 0).isSuccess();
}

bool hkReflect::VarCoerce::floatFromInt(const FloatVar& dst, const IntVar& src)
{
    HK_ASSERT_NO_MSG(0x7e3b8467, dst);
    IntValue iv = src.getValue();
    hkDouble64 d = (double)iv.absValue();
    if( iv.isNegative() )
    {
        d = -d;
    }
    return dst.setValue(d).isSuccess();
}

bool hkReflect::VarCoerce::floatFromFloat(const FloatVar& dst, const FloatVar& src)
{
    HK_ASSERT_NO_MSG(0x17c315cf, dst);
    return dst.setValue(src.getValue()).isSuccess();
}

bool hkReflect::VarCoerce::floatFromString(const FloatVar& dst, const StringVar& src)
{
    HK_ASSERT_NO_MSG(0x19bb8af5, dst);
    if(const char* s = src.getValue())
    {
        hkDouble64 d;
        if( hkFloatParseUtil::parseFloat(hkStringView(s), d).isSuccess() )
        {
            return dst.setValue(d).isSuccess();
        }
    }

    return false;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
