// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Container/PointerMap/hkMap.h>

template <typename T>
struct hkMapOperationsForVars
{
    HK_ALWAYS_INLINE static unsigned hash(const T& key, unsigned mod)
    {
        return hkMapOperations<void*>::hash(key.getAddress(), mod);
    }
    HK_ALWAYS_INLINE static void invalidate(T& key)
    {
        // Use a Var with an invalid type.
        
        new (&key) hkReflect::Var((void*)HK_NULL, reinterpret_cast<hkReflect::Type*>(0x1), HK_NULL);
    }
    HK_ALWAYS_INLINE static hkBool32 isValid(const T& key)
    {
        return key.getType().get() != reinterpret_cast<hkReflect::Type*>(0x1);
    }
    HK_ALWAYS_INLINE static hkBool32 equal(const T& key0, const T& key1)
    {
        return key0 == key1;
    }
};

#define HK_SPECIALIZE_MAP_OPERATIONS_FOR_VAR( VAR ) \
template <> struct hkMapOperations<VAR> : public hkMapOperationsForVars<VAR> {};

HK_SPECIALIZE_MAP_OPERATIONS_FOR_VAR(hkReflect::Var)
HK_SPECIALIZE_MAP_OPERATIONS_FOR_VAR(hkReflect::ValueVar)
HK_SPECIALIZE_MAP_OPERATIONS_FOR_VAR(hkReflect::BoolVar)
HK_SPECIALIZE_MAP_OPERATIONS_FOR_VAR(hkReflect::IntVar)
HK_SPECIALIZE_MAP_OPERATIONS_FOR_VAR(hkReflect::FloatVar)
HK_SPECIALIZE_MAP_OPERATIONS_FOR_VAR(hkReflect::StringVar)
HK_SPECIALIZE_MAP_OPERATIONS_FOR_VAR(hkReflect::CompoundVar)
HK_SPECIALIZE_MAP_OPERATIONS_FOR_VAR(hkReflect::PointerVar)
HK_SPECIALIZE_MAP_OPERATIONS_FOR_VAR(hkReflect::ContainerVar)
HK_SPECIALIZE_MAP_OPERATIONS_FOR_VAR(hkReflect::ArrayVar)
HK_SPECIALIZE_MAP_OPERATIONS_FOR_VAR(hkReflect::RecordVar)

#undef HK_SPECIALIZE_MAP_OPERATIONS_FOR_VAR

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
