// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Reflect/hkReflect.h>

namespace hkReflectUtil
{

    /// Add a copy (if necessary) of the string to an internal pool which will stay alive until hkBaseSystem::quit.
    HK_EXPORT_COMMON _Ret_z_ const char* internCopy(_When_(len != -1, _In_reads_(len)) _When_(len == -1, _In_z_) const char*, int len = -1);
    /// Add the given string (if not already present) to the internal string pool.
    HK_EXPORT_COMMON _Ret_z_ const char* internStatic(_In_z_ const char*);

    /// If the Var's type is a Field, return a Var referencing the surrounding/containing record,
    /// otherwise return an invalid Var.
    HK_EXPORT_COMMON hkReflect::Var getDeclContext(hkReflect::Var var);

    HK_EXPORT_COMMON hkReflect::FieldDecl HK_CALL getRecordFieldWithAncestors(_In_ const hkReflect::RecordType* self, int index);
    HK_EXPORT_COMMON int HK_CALL getRecordNumFieldsWithAncestors(_In_ const hkReflect::RecordType* self);
    HK_EXPORT_COMMON int HK_CALL getRecordFieldIndexWithAncestors(_In_ const hkReflect::RecordType* self, _In_z_ const char* fieldName);

    HK_EXPORT_COMMON hkReflect::IntValue HK_CALL getRangeMin(_In_ const hkReflect::IntType* intType);
    HK_EXPORT_COMMON hkReflect::IntValue HK_CALL getRangeMax(_In_ const hkReflect::IntType* intType);

} // hkReflectUtil

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
