// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/Reflect/Util/hkReflectUtil.h>
#include <Common/Base/Container/StringMap/hkStringMap.h>
#include <Common/Base/Thread/CriticalSection/hkCriticalSection.h>
#include <Common/Base/Object/hkSingleton.h>


class ReflectStrings : public hkReferencedObject
{
public:

    HK_DECLARE_CLASS(ReflectStrings, New, Singleton);
    ~ReflectStrings()
    {
        for (hkStringMap<int>::Iterator it = m_flagFromString.getIterator();
            m_flagFromString.isValid(it); it = m_flagFromString.getNext(it))
        {
            if (m_flagFromString.getValue(it))
            {
                hkDeallocate(const_cast<char*>(m_flagFromString.getKey(it)));
            }
        }
    }
    _Ret_z_ const char* internCopy(_When_(len != -1, _In_reads_(len)) _When_(len == -1, _In_z_) const char* str, int len) { return intern(str, len, true); }
    _Ret_z_ const char* internStatic(_When_(len != -1, _In_reads_(len)) _When_(len == -1, _In_z_) const char* str, int len) { return intern(str, len, false); }

protected:
    _Ret_z_ const char* intern(_When_(len != -1, _In_reads_ (len)) _When_(len == -1, _In_z_) const char* str, int len, bool copy)
    {
        hkCriticalSectionLock lock(&m_criticalSection);

        // Special case for inserting a non-null terminated string
        // copy it to add null terminator.
        
        hkArray<char>::Temp tmpCopy;
        if (len != -1)
        {
            tmpCopy.append(str, len);
            tmpCopy.pushBack(0);
            str = tmpCopy.begin();
        }

        hkStringMap<int>::Iterator it = m_flagFromString.findKey(str);
        if (!m_flagFromString.isValid(it))
        {
            const char* key = copy ? hkString::strDup(str) : str;
            m_flagFromString.insert(key, copy);
            return key;
        }
        else
        {
            return m_flagFromString.getKey(it);
        }
    }

    hkCriticalSection m_criticalSection;
    hkStringMap<int> m_flagFromString;
};
HK_SINGLETON_IMPLEMENTATION(ReflectStrings);

_Ret_z_ const char* hkReflectUtil::internCopy(_When_(len != -1, _In_reads_(len)) _When_(len == -1, _In_z_) const char* str, int len)
{
    return ReflectStrings::getInstance().internCopy(str, len);
}
_Ret_z_ const char* hkReflectUtil::internStatic(_In_z_ const char* str)
{
    return ReflectStrings::getInstance().internStatic(str, -1);
}

int hkReflectUtil::getRecordNumFieldsWithAncestors(_In_ const hkReflect::RecordType* self)
{
    int count = 0;
    for (const hkReflect::RecordType* cur = self; cur; cur = cur->getParentRecord())
    {
        count += cur->getNumFields();
    }
    return count;
}

hkReflect::FieldDecl hkReflectUtil::getRecordFieldWithAncestors(_In_ const hkReflect::RecordType* self, int index)
{
    int numFields = getRecordNumFieldsWithAncestors(self);
    HK_ASSERT(0x5a9fa0ed, index >= 0 && index < numFields, "invalid record field index");
    const hkReflect::RecordType* r = self;
    int localIndex = index - numFields;
    while (r)
    {
        hkArrayView<const hkReflect::FieldDecl> fields = r->getFields();
        localIndex += fields.getSize();
        if (localIndex >= 0)
        {
            return fields[localIndex];
        }
        r = r->getParentRecord();
    }
    HK_ASSERT_NO_MSG(0x21bcaa3, false); // should never happen
    return hkReflect::FieldDecl();
}

int hkReflectUtil::getRecordFieldIndexWithAncestors(_In_ const hkReflect::RecordType* self, _In_z_ const char* fieldName)
{
    int index = 0;
    for (hkReflect::DeclIter<hkReflect::FieldDecl> it(self); it.advance();)
    {
        if (hkString::strCmp(fieldName, it.current().getName()) == 0)
        {
            return index;
        }
        ++index;
    }
    return -1;
}

hkReflect::Var hkReflectUtil::getDeclContext(hkReflect::Var var)
{
    if (hkReflect::FieldDecl field = var.getType()->isField())
    {
        return hkReflect::Var(hkAddByteOffset(var.getAddress(), -hkLong(field.getOffset())), field.getDeclContext());
    }
    else
    {
        return hkReflect::Var();
    }
}

hkReflect::IntValue hkReflectUtil::getRangeMin(_In_ const hkReflect::IntType* intType)
{
    HK_ASSERT_NO_MSG(0x1cc2a628, intType );
    hkReflect::IntValue minValue;

    if (intType->isSigned())
    {
        int size = intType->getSizeOf();
        minValue.set( ((hkUint64)1) << ( size * 8 - 1 ), true );
    }
    else
    {
        minValue.set( 0, false );
    }

    if (const hk::AbsMin* min = intType->findAttribute<hk::AbsMin>())
    {
        hkReflect::IntVar minVar( min->get( intType ) );
        hkReflect::IntValue v = minVar.getValue();
        if (!v.isNegative() || (v.absValue() < minValue.absValue()) )
        {
            minValue = v;
        }
    }
    return minValue;
}

hkReflect::IntValue hkReflectUtil::getRangeMax(_In_ const hkReflect::IntType* intType )
{
    HK_ASSERT_NO_MSG(0x697da7d5, intType );
    hkReflect::IntValue maxValue;

    int size = intType->getSizeOf();
    if (intType->isSigned())
    {
        maxValue.set( ~((hkUint64)0) >> (65 - size * 8), false );
    }
    else
    {
        maxValue.set( ~((hkUint64)0) >> (64 - size * 8), false);
    }

    if (const hk::AbsMax* max = intType->findAttribute<hk::AbsMax>())
    {
        hkReflect::IntVar maxVar( max->get( intType ) );
        hkReflect::IntValue v = maxVar.getValue();
        if ( v.isNegative() || (v.absValue() < maxValue.absValue()))
        {
            maxValue = v;
        }
    }
    return maxValue;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
