// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

namespace hkReflect
{
    namespace Detail
    {
            /// Utility to synthesize a type at runtime which tries to behave like a builtin type.
            /// Classes need to opt-in to enable this behaviour. In most cases, an abstract base class
            /// will provide default method implementations for synthesized classes.
            ///
            /// To use this utility:
            /// * Choose a (often abstract) class which is the interface you want to synthesize. e.g. BaseFoo
            /// * Create a derived class (e.g. MyFakeFoo)
            ///     * implement any abstract methods
            ///     * ensure the final field is "hkReflect::Detail::SyntheticUtil m_syntheticUtil"
            ///     * add an attribute HK_RECORD_ATTR(hk::GenerateExactTypeMethod(false));
            ///     * implement getExactType() as return m_syntheticUtil.getType()
            /// * Add an attribute hk::SyntheticBase to your base (e.g. BaseFoo) which indicates the implementation
            ///   (the real C++ class) of any synthetic classes.
            ///   HK_RECORD_ATTR(hk::SyntheticBase( HK_REFLECT_GET_TYPE(MyFakeFoo) ));
        class HK_EXPORT_COMMON SyntheticUtil
        {
        public:
            HK_DECLARE_CLASS(SyntheticUtil, New, Reflect, BypassCtor);
            HK_RECORD_ATTR(hk::Serialize(false));
            SyntheticUtil(_In_ const hkReflect::Type* type) : m_type(type) {}
            hkReflect::QualType getType() const { return m_type; }
            ~SyntheticUtil();

            static _Ret_maybenull_ hkReflect::Type* build(_In_ const hkReflect::Type* typeIn);

            struct AllocationImpl : public hkReflect::Detail::ReferencedObjectAllocImpl
            {
                AllocationImpl() {}
                hkReflect::Var allocateForClone(const hkReflect::Var& src, _In_ const hkReflect::Type* type) const HK_OVERRIDE;
                hkReflect::Var allocate(_In_ const hkReflect::Type* type) const HK_OVERRIDE;
            };
            static const AllocationImpl s_allocImpl;

        protected:
            hkReflect::QualType m_type; // remember our "exact" type
        public: 
            void setType(hkReflect::QualType t) { m_type = t; }
        private:
            static void HK_CALL reflectConstruct(_Inout_ void* addr, _In_ const hkReflect::Type* type, int num);
        };
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
