// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/Reflect/Util/hkReflectSyntheticUtil.h>
#include <Common/Base/Reflect/Core/Detail/hkReflectTypeDetail.h>
#include <Common/Base/Reflect/Builder/hkTypeBuilder.h>
#include <Common/Base/Reflect/Builder/hkRecordLayout.h>
#include <Common/Base/Reflect/Util/hkReflectUtil.h>
#include <Common/Base/Reflect/TypeReg/hkTypeReg.h>

#define DEBUG_LOG_IDENTIFIER "reflect.SyntheticUtil"
#include <Common/Base/System/Log/hkLog.hxx>


void hkReflect::Detail::SyntheticUtil::reflectConstruct(_Inout_ void* addr, _In_ const hkReflect::Type* type, int num)
{
    const Type* baseSynthetic = type->getValueAttribute<hk::SyntheticBase>(HK_NULL);
    HK_ASSERT_NO_MSG(0x2ecf05ca, baseSynthetic->extendsOrEquals<hkReferencedObject>()); // we need this to correctly set memsize for cleanup
    HK_ON_DEBUG(hkResult res = )TypeDetail::reflectConstruct(addr, baseSynthetic, num);
    HK_ASSERT_NO_MSG(0x64609096, res.isSuccess());

    int stride = type->getSizeOf();
    if( DataFieldDecl synUtil = type->findField("syntheticUtil", true).asDataField() )
    {
        {
            
            hkReferencedObject* cur = reinterpret_cast<hkReferencedObject*>(addr);
            for (int i = 0; i < num; ++i)
            {
                HK_ASSERT_NO_MSG(0x778ae286, cur->getMemorySizeAndFlags() == stride);
                cur->setMemorySizeAndFlags(stride);
                cur->setReferenceCount(1);
                cur = hkAddByteOffset(cur, stride);
            }
        }
        // initialize the synthetic util to remember our type
        {
            auto* util = reinterpret_cast<hkReflect::Detail::SyntheticUtil*>(hkAddByteOffset(addr, synUtil.getOffset()));
            for (int i = 0; i < num; ++i)
            {
                util->setType(type);
                util = hkAddByteOffset(util, stride);
            }
        }
        // initialize synthetic fields (C++ ones are taken care of by the call to reflectConstruct above.)
        const hkReflect::Type* stem = baseSynthetic->getParent();
        for (DeclIter<DataFieldDecl> iter(type, stem); iter.advance(); )
        {
            DataFieldDecl field = iter.current();
            if (field != synUtil)
            {
                void* cur = hkAddByteOffset(addr, field.getOffset());
                if (Detail::UnaryFunction func = hkReflect::TypeDetail::getDefaultConstructionFunction(field.getType()))
                {
                    for (int i = 0; i < num; ++i)
                    {
                        (*func)(cur, field.getType(), 1);
                        cur = hkAddByteOffset(cur, stride);
                    }
                }
            }
        }
    }
    else
    {
        HK_ASSERT(0x188b0363, 0, "Something went wrong, m_syntheticUtil field was not found");
    }
}

hkReflect::Detail::SyntheticUtil::~SyntheticUtil()
{
    if (m_type)
    {
        if (const hkReflect::RecordType* rec = m_type->asRecord())
        {
            if (hkReflect::DataFieldDecl synUtil = rec->findField("syntheticUtil", false).asDataField())
            {
                int utilOffset = synUtil.getOffset();
                hkReflect::RecordVar var(hkAddByteOffset(this, -utilOffset), rec);
                for (int fi = 0; fi < rec->getNumFields(); ++fi)
                {
                    if (rec->getField(fi) != synUtil)
                    {
                        hkReflect::Var v = var[rec->getField(fi)];
                        v.destroy(hkReflect::Var::FLAG_DESTRUCT);
                    }
                }
            }
        }
    }
}

static bool s_findSuitableBase(_In_ const hkReflect::Type* srcTypeIn, _Outptr_ const hkReflect::Type** stemOut, _Outptr_ const hkReflect::Type** nativeOut)
{
    // typeIn - the type we're synthesizing
    // baseOut - the base class of typeIn which corresponds to nativeOut
    // nativeOut - the native base class

    for (const hkReflect::Type* cur = srcTypeIn->getParent();
        cur;
        cur = cur->getParent())
    {
        if (const hkReflect::Type* n = hkReflect::typeFromType(cur))
        {
            // only base on real types
            if (n->isDynamicType())
            {
                continue;
            }

            if (const hk::SyntheticBase* base = hkReflect::TypeDetail::localFindAttribute<hk::SyntheticBase>(n))
            {
                HK_ASSERT(0x4cd3f02f, base->m_value->getParent()->equals(n),
                    "The synthetic base must inherit directly from the original base");
                *stemOut = cur;
                *nativeOut = base->m_value;
                return true;
            }
        }
    }
    return false;
}

static void s_deleteTypeAndName(_Inout_ hkReflect::Type* type, _Inout_ hkMemoryAllocator* allocator, hkUlong data)
{
    char* name = const_cast<char*>(type->getName());
    hkString::strFree(name);
    hkReflect::TypeBuilder::deallocateType(type, allocator, data);
}

_Ret_maybenull_ hkReflect::Type* hkReflect::Detail::SyntheticUtil::build(_In_ const hkReflect::Type* typeIn)
{
    
    if (!typeIn->asRecord())
    {
        return HK_NULL;
    }

    // Find a base class which has a builtin version which is not dynamic
    const hkReflect::Type* stemIn;
    const hkReflect::Type* baseSynthetic;
    if (s_findSuitableBase(typeIn, &stemIn, &baseSynthetic) == false)
    {
        Log_Warning("Unable to make a synthetic type for {}, no suitable base found. "
            "Add a hk::SyntheticBase attribute to an appropriate base.", typeIn->getName());
        return HK_NULL;
    }

    hkReflect::TypeBuilder builder;

    const hkReflect::Type* stem = baseSynthetic->getParent();
    builder.beginRecord(hkString::strDup(typeIn->getName()), stem);

    builder.addItem<hkReflect::Opt::INHERITANCE>(*hkReflect::TypeDetail::getInheritance(baseSynthetic)); 
    builder.addItem<hkReflect::Opt::DEF_CONSTRUCTOR>(&hkReflect::Detail::SyntheticUtil::reflectConstruct);
    builder.addItem<hkReflect::Opt::ALLOC_IMPL>(&hkReflect::Detail::SyntheticUtil::s_allocImpl);
    builder.addFlags(Type::FlagBits(hkReflect::Type::TYPE_DYNAMIC | hkReflect::Type::TYPE_SYNTHETIC));

    // Add fields from the synthetic base.
    auto synthFields = baseSynthetic->getDataFields();
    for (int i = 0; i < synthFields.getSize(); ++i)
    {
        hkReflect::FieldDecl f = synthFields[i];
        HK_ASSERT(0x196e3854, !f.isSerializable(), "All fields in a synthetic base must be non-serializable");
        builder.addMember(f.getName(), 0, f.getFlags(), f.getType()->getParent());
    }

    // Add fields from the original type.
    for (hkReflect::DeclIter<hkReflect::DataFieldDecl> iter(typeIn, stemIn); iter.advance(); )
    {
        hkReflect::DataFieldDecl f = iter.current();
        
        if (const hkReflect::Type* ft = hkReflect::typeFromType(f.getType()))
        {
            
            const char* fname = hkReflectUtil::internCopy(f.getName());
            builder.addMember(fname, 0, 0, ft);
        }
        else
        {
            Log_Warning("Skipping field {} of type {} because there is no native version of it", f.getName(), f.getType()->getName());
        }
    }

    builder.addDeleteInfo(&s_deleteTypeAndName);
    hkReflect::Type* t = builder.allocate(hkMemHeapAllocator());
    hkReflect::RecordLayout::recomputeNative(t);
    return t;
}

static void updateMemSize(_Inout_ void* address, _In_ const hkReflect::Type* type)
{
    hkReferencedObject* ro = static_cast<hkReferencedObject*>(address);
    int curSize = ro->getMemorySizeAndFlags();
    int newSize = type->getSizeOf();
    if (curSize != newSize)
    {
        HK_ASSERT(0x1df29c1b, curSize == hkReferencedObject::AUTO_MEMSIZE,
            "Allocation size was already set (relarray?). Cannot set the correct allocation size");
        ro->setMemorySizeAndFlags(newSize);
    }
}

hkReflect::Var hkReflect::Detail::SyntheticUtil::AllocationImpl::allocateForClone(const hkReflect::Var& src, _In_ const hkReflect::Type* type) const
{
    hkReflect::Var var = ReferencedObjectAllocImpl::allocateForClone(src, type);
    updateMemSize(var.getAddress(), type);
    return var;
}

hkReflect::Var hkReflect::Detail::SyntheticUtil::AllocationImpl::allocate(_In_ const hkReflect::Type* type) const
{
    hkReflect::Var var = ReferencedObjectAllocImpl::allocate(type);
    updateMemSize(var.getAddress(), type);
    return var;
}

const hkReflect::Detail::SyntheticUtil::AllocationImpl hkReflect::Detail::SyntheticUtil::s_allocImpl;

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
