// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT    : COMMON
// VISIBILITY : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#define HK_STATIC_ASSERT_ENSURE_NOT_VAR_DERIVED \
    HK_COMPILE_TIME_ASSERT( false == hkTrait::InheritsFrom<T, Var>::result ) // todo.jh +message?

template <typename T>
HK_ALWAYS_INLINE hkReflect::Any hkReflect::Any::fromDefaultObj()
{
    HK_STATIC_ASSERT_ENSURE_NOT_VAR_DERIVED;
    Any ret;
    ret.init(getType<T>());
    return ret;
}

template <typename T>
HK_ALWAYS_INLINE hkReflect::Any hkReflect::Any::fromObj(const T& obj)
{
    HK_STATIC_ASSERT_ENSURE_NOT_VAR_DERIVED;
    Any ret;
    ret.setFromVarContent(Var(&obj));
    return ret;
}

HK_ALWAYS_INLINE hkReflect::Any hkReflect::Any::fromVar(const Var& var)
{
    Any ret;
    ret.setFromVarContent(var);
    return ret;
}

HK_ALWAYS_INLINE hkReflect::Any hkReflect::Any::asAnyOfAnyCopy( const Any& obj )
{
    Any ret;
    ret.setFromVarContent(Var(&obj));
    return ret;
}

HK_ALWAYS_INLINE hkReflect::Any::Any() : m_status(STATUS_EMPTY) {}

HK_ALWAYS_INLINE hkReflect::Any::Any(const Any& rhs)
    : m_status(STATUS_EMPTY)
{
    setFromVarContent(rhs.var());
}

HK_ALWAYS_INLINE void hkReflect::Any::operator=(const Any& rhs)
{
    setFromVarContent(rhs.var());
}

HK_ALWAYS_INLINE hkReflect::Any::~Any()
{
    clear();
}

HK_INLINE bool hkReflect::Any::containsObject() const
{
    HK_ASSERT_NO_MSG(0x785a2814, m_status!=STATUS_EMPTY || m_type.isNull());
    return m_status!=STATUS_EMPTY;
}

HK_INLINE bool hkReflect::Any::storesInplace() const
{
    return m_status == STATUS_INPLACE;
}

HK_INLINE void hkReflect::Any::init(const QualType type)
{
    clear();
    m_type = type;
    initInternal();
}

template <typename T>
HK_ALWAYS_INLINE void hkReflect::Any::setFromObj(const T& obj)
{
    HK_STATIC_ASSERT_ENSURE_NOT_VAR_DERIVED;
    setFromVarContent(Var(&obj));
}

HK_ALWAYS_INLINE void hkReflect::Any::setFromVar(const Var& var)
{
    setFromVarContent(var);
}

HK_ALWAYS_INLINE _Ret_notnull_ const void* hkReflect::Any::addr() const
{
    return addr2<const void* const>(*this);
}

HK_ALWAYS_INLINE _Ret_notnull_ void* hkReflect::Any::addr()
{
    return addr2<void*>(*this);
}

template<typename T, typename AnyType>
HK_INLINE T hkReflect::Any::addr2(AnyType& a)
{
    switch (a.m_status)
    {
        default:
        case STATUS_EMPTY: return HK_NULL;
        case STATUS_INPLACE: return reinterpret_cast<T>(&a.m_buf[0]);
        case STATUS_EXTERNAL: return reinterpret_cast<T*>(a.m_buf)[0];
    }
}

#undef HK_STATIC_ASSERT_ENSURE_NOT_VAR_DERIVED

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
