// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Reflect/Visitor/hkReflectVisitor.h>

namespace hkReflect
{
namespace Detail
{
    // Field Setters

    // General case: do no conversion.
    template<typename FieldType, typename ValueType>
    struct FieldSetterType
    {
        static HK_ALWAYS_INLINE const FieldType& getArgument( _In_ const void* arg )
        {
            return *reinterpret_cast<const FieldType*>( arg );
        }
    };

    // If the method accepts a pointer to the field type, pass the pointer directly.
    template<typename FieldType>
    struct FieldSetterType <FieldType, const FieldType*>
    {
        static HK_ALWAYS_INLINE _Ret_notnull_ const FieldType* getArgument(_In_ const void* arg )
        {
            return reinterpret_cast<const FieldType*>( arg );
        }
    };

    template<typename ReturnType>
    struct erasedFieldSetterCall;

    template<>
    struct erasedFieldSetterCall<bool>
    {
        template<typename MethodClass, typename FieldType, typename ValueType, bool ( MethodClass::*Setter )( ValueType )>
        static bool HK_CALL call(_Inout_ void* obj, _In_ const void* v)
        {
            return ( static_cast<MethodClass*>( obj )->*Setter )( FieldSetterType<FieldType, ValueType>::getArgument( v ) );
        }
    };

    template<>
    struct erasedFieldSetterCall<hkResult>
    {
        template<typename MethodClass, typename FieldType, typename ValueType, hkResult ( MethodClass::*Setter )( ValueType )>
        static bool call(_Inout_ void* obj, _In_ const void* v)
        {
            return (static_cast<MethodClass*>(obj)->*Setter)(FieldSetterType<FieldType, ValueType>::getArgument( v )).isSuccess();
        }
    };

    template<>
    struct erasedFieldSetterCall<void>
    {
        template<typename MethodClass, typename FieldType, typename ValueType, void ( MethodClass::*Setter )( ValueType )>
        static bool HK_CALL call(_Inout_ void* obj, _In_ const void* v)
        {
            ( static_cast<MethodClass*>( obj )->*Setter )( FieldSetterType<FieldType, ValueType>::getArgument( v ) );
            return true;
        }
    };

    // Impl for a generic field with a setter.
    template<typename MyType>
    struct HK_EXPORT_COMMON SetterValueImpl : public ImplFromType<MyType>::Type
    {
            
            typedef hk::FieldSetter::Fn SetterType;

            SetterValueImpl(SetterType setter, hkUint16 offset) : m_setter(setter), m_offset(offset) {}

            typedef typename ImplFromType<MyType>::Type MyImpl;
            typedef typename ValueFromType<MyType>::Type MyValue;
            typedef typename VarFromType<MyType>::Type MyVar;
            typedef typename hkTrait::If<sizeof(MyValue) <= 8, MyValue, const MyValue&>::Type MyValueParam;

            virtual hkResult setValue(_Inout_ void* addr, _In_ const MyType* type, MyValueParam value) const HK_OVERRIDE;
            virtual hkResult getValue(_In_ const void* addr, _In_ const MyType* type, _Out_ MyValue* val) const HK_OVERRIDE;

            virtual SetterType getSetter() const HK_OVERRIDE;

        protected:
            SetterType m_setter;
            hkUint16 m_offset;
    };

    // Impl for a Record field with a setter.
    struct HK_EXPORT_COMMON SetterRecordImpl : public SetterValueImpl<RecordType>
    {
        SetterRecordImpl(SetterType setter, hkUint16 offset) : SetterValueImpl<RecordType>(setter, offset) {}

        virtual _Ret_maybenull_ const Impl* getFieldImpl(const Var& parent, FieldDecl field) const HK_OVERRIDE;
        virtual hkResult setValue(_Inout_ void* addr, _In_ const RecordType* type, const RecordVar& other) const HK_OVERRIDE;
    };

    // Impl for an Array field with a setter.
    struct HK_EXPORT_COMMON SetterArrayImpl : public SetterValueImpl<ArrayType>
    {
        public:
            SetterArrayImpl(SetterType setter, hkUint16 offset) : SetterValueImpl<ArrayType>(setter, offset) {}

            virtual hkResult getValue(_In_ const void* arrAddr, _In_ const ArrayType* arrType, _Out_ ArrayValue* val) const HK_OVERRIDE;
            virtual hkResult setValue(_Inout_ void* arrAddr, _In_ const ArrayType* arrType, const ArrayValue& val) const HK_OVERRIDE;
            virtual hkResult setNumElements(_Inout_ void* arrAddr, _In_ const ArrayType* arrType, int nelem) const HK_OVERRIDE;
            virtual hkResult spliceInto(_Inout_ void* arrAddr, _In_ const ArrayType* arrType, int index, int numToDel, const ArrayValue& val) const HK_OVERRIDE;
            virtual AllocResult allocateElements(_Inout_ void* arrAddr, _In_ const ArrayType* arrType, QualType elemType, int n) const HK_OVERRIDE;
            virtual void clearAllocs(_Inout_ void* arrAddr, _In_ const ArrayType* arrType) const HK_OVERRIDE;
    };

    template<typename MyType> struct SetterImpl { typedef SetterValueImpl<MyType> Type; };
    template<> struct SetterImpl<RecordType> { typedef SetterRecordImpl Type; };
    template<> struct SetterImpl<ArrayType> { typedef SetterArrayImpl Type; };


    //
    // Array callbacks.

    template<typename ElementType, typename ParamType>
    struct ArrayAddType
    {
    };

    template<typename ElementType>
    struct ArrayAddType<ElementType, ElementType>
    {
        static ElementType getArgument(_In_ const void* arg) { return *reinterpret_cast<const ElementType*>(arg); }
    };

    template<typename ElementType>
    struct ArrayAddType <ElementType, const ElementType*>
    {
        static _Ret_notnull_ const ElementType* getArgument(_In_ const void* arg) { return reinterpret_cast<const ElementType*>(arg); }
    };

    template<typename ElementType>
    struct ArrayAddType <ElementType, const ElementType&>
    {
        static const ElementType& getArgument(_In_ const void* arg) { return *reinterpret_cast<const ElementType*>(arg); }
    };

    /// Templates which convert methods of various forms to a static function of the form AddFn.
    template<typename ReturnType>
    struct erasedArrayAddCall;

    template<>
    struct erasedArrayAddCall<bool>
    {
        template<typename MethodClass, typename ParamType, typename ElementType, bool (MethodClass::*Meth)(int, ParamType)>
        static bool HK_CALL call(_Inout_ void* obj, int index, _In_ const void* v)
        {
            // getArgument not a member of ArrayAddType?
            // The addToX method's 2nd argument needs to be one of ElementType, const ElementType* or const ElementType&.
            return (static_cast<MethodClass*>(obj)->*Meth)(index, ArrayAddType<ElementType, ParamType>::getArgument(v));
        }
    };

    template<>
    struct erasedArrayAddCall<void>
    {
        template<typename MethodClass, typename ParamType, typename ElementType, void (MethodClass::*Meth)(ParamType)>
        static bool HK_CALL call(_Inout_ void* obj, int index, _In_ const void* v)
        {
            // getArgument not a member of ArrayAddType?
            // The addToX method's 2nd argument needs to be one of ElementType, const ElementType* or const ElementType&.
            (static_cast<MethodClass*>(obj)->*Meth)(index, ArrayAddType<ElementType, ParamType>::getArgument(v));
            return true;
        }
    };

    /// Templates which convert methods of various forms to a static function of the form RemoveFn.
    template<typename ReturnType>
    struct erasedArrayRemoveCall;

    template<>
    struct erasedArrayRemoveCall<bool>
    {
        template<typename MethodClass, bool (MethodClass::*Meth)(int)>
        static bool HK_CALL call(_Inout_ void* obj, int index)
        {
            return (static_cast<MethodClass*>(obj)->*Meth)(index);
        }
    };

    template<>
    struct erasedArrayRemoveCall<void>
    {
        template<typename MethodClass, typename ValueType, void (MethodClass::*Meth)(int)>
        static bool HK_CALL call(_Inout_ void* obj, int index)
        {
            (static_cast<MethodClass*>(obj)->*Meth)(index);
            return true;
        }
    };

    // Traits used to extract the array element type from a reflected array type.

    template <typename T>
    class HasArraySubtype
    {
        typedef char yes;
        typedef long no;

        template <typename C, typename D = typename C::ReflectedArraySubtype> struct Test {};
        template <typename C> static yes test(Test<C>*);
        template <typename C> static no test(...);

    public:
        enum { result = sizeof(test<T>(0)) == sizeof(yes) };
    };

    template <typename T>
    class GetArraySubtype
    {
        template <typename C, bool hasSubtype > struct Helper { typedef void Type; };
        template <typename C> struct Helper<C, true> { typedef typename C::ReflectedArraySubtype Type; };

    public:
        typedef typename Helper< T, HasArraySubtype<T>::result >::Type Type;
    };

    template <typename T, int N> class HasArraySubtype< T[N] > { public: enum { result = true }; };
    template <typename T, int N> class GetArraySubtype< T[N] > { public: typedef T Type; };
}
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
