// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

template<typename InterpreterImpl>
hkTypeVm::UnaryInterpreter<InterpreterImpl>::UnaryInterpreter()
{
}

template<typename InterpreterImpl>
InterpreterImpl& hkTypeVm::UnaryInterpreter<InterpreterImpl>::run(const hkReflect::Var& obj)
{
    hkViewPtr<Program> prog = m_compiler.compile(obj.getType());
    return run(obj, *prog);
}

template<typename InterpreterImpl>
InterpreterImpl& hkTypeVm::UnaryInterpreter<InterpreterImpl>::run(const hkReflect::Var& obj, const hkTypeVm::Program& prog)
{
    using namespace hkTypeVm;

    InterpreterImpl& self = getExact();

    void* curAddr = HK_NULL;
    for(Program::ConstIterator it = prog.begin(); it != prog.end(); ++it)
    {
        const Program::InstructionBase& baseInstr = *it;

        curAddr = hkAddByteOffset(obj.getAddress(), baseInstr.getDstOffset());

        switch(it->getInstructionType())
        {
            case Program::INST_NONE:
            {
                HK_ASSERT_NO_MSG(0x4b9c36df, false);
            }
            break;

            case Program::INST_ARRAY:
            {
                const Program::ArrayInstruction& instr = static_cast<const Program::ArrayInstruction&>(baseInstr);
                self.execArray(curAddr, instr);
            }
            break;

            case Program::INST_BOOL:
            {
                const Program::DefaultInstruction& instr = static_cast<const Program::DefaultInstruction&>(baseInstr);
                self.execBool(curAddr, instr);
            }
            break;

            //case Program::INST_CONTAINER:
            //{
            //  const Program::DefaultInstruction& instr = static_cast<const Program::DefaultInstruction&>(baseInstr);
            //  self.execContainer(curAddr, instr);
            //}
            //break;

            case Program::INST_INT:
            {
                const Program::DefaultInstruction& instr = static_cast<const Program::DefaultInstruction&>(baseInstr);
                self.execInt(curAddr, instr);
            }
            break;

            case Program::INST_FLOAT:
            {
                const Program::DefaultInstruction& instr = static_cast<const Program::DefaultInstruction&>(baseInstr);
                self.execFloat(curAddr, instr);
            }
            break;

            case Program::INST_POINTER:
            {
                const Program::DefaultInstruction& instr = static_cast<const Program::DefaultInstruction&>(baseInstr);
                self.execPointer(curAddr, instr);
            }
            break;

            case Program::INST_RECORD:
            {
                const Program::RecordInstruction& instr = static_cast<const Program::RecordInstruction&>(baseInstr);
                self.execRecord(curAddr, instr);
            }
            break;

            case Program::INST_STRING:
            {
                const Program::DefaultInstruction& instr = static_cast<const Program::DefaultInstruction&>(baseInstr);
                self.execString(curAddr, instr);
            }
            break;

            case Program::INST_BLOCK:
            {
                const Program::BlockInstruction& instr = static_cast<const Program::BlockInstruction&>(baseInstr);
                self.execBlock(curAddr, instr);
            }
            break;

            case Program::INST_CONVERT_INTEGER:
            {
                const Program::DefaultInstruction& instr = static_cast<const Program::DefaultInstruction&>(baseInstr);
                self.execConvertInt(curAddr, instr);
                break;
            }

            case Program::INST_CONVERT_FLOAT:
            {
                const Program::DefaultInstruction& instr = static_cast<const Program::DefaultInstruction&>(baseInstr);
                self.execConvertFloat(curAddr, instr);
                break;
            }

            case Program::INST_CONVERT_BOOL:
            {
                const Program::DefaultInstruction& instr = static_cast<const Program::DefaultInstruction&>(baseInstr);
                self.execConvertBool(curAddr, instr);
                break;
            }

            //case Program::INST_WRITE_CONSTANT:
            //{
            //  const Program::WriteConstantInstruction& instr = static_cast<const Program::WriteConstantInstruction&>(baseInstr);
            //  self.execWriteConstant(curAddr, instr);
            //}
            //break;
            case Program::NUM_INSTRUCTIONS:
            {
                HK_ASSERT_NO_MSG(0x65c3f7e, false); // Unknown instruction
                break;
            }

        }
    }

    return self;
}

template<typename InterpreterImpl>
void hkTypeVm::UnaryInterpreter<InterpreterImpl>::execBool(_Inout_ void* addr, const hkTypeVm::Program::DefaultInstruction& instr)
{
    HK_UNREACHABLE(0x78b0b2ff, "Not implemented" );
}

template<typename InterpreterImpl>
void hkTypeVm::UnaryInterpreter<InterpreterImpl>::execInt(_Inout_ void* addr, const hkTypeVm::Program::DefaultInstruction& instr)
{
    HK_UNREACHABLE(0x350f8a3b, "Not implemented" );
}

template<typename InterpreterImpl>
void hkTypeVm::UnaryInterpreter<InterpreterImpl>::execFloat(_Inout_ void* addr, const hkTypeVm::Program::DefaultInstruction& instr)
{
    HK_UNREACHABLE(0x64eba96f, "Not implemented" );
}

template<typename InterpreterImpl>
void hkTypeVm::UnaryInterpreter<InterpreterImpl>::execString(_Inout_ void* addr, const hkTypeVm::Program::DefaultInstruction& instr)
{
    HK_UNREACHABLE(0x7ced3dea, "Not implemented" );
}

template<typename InterpreterImpl>
void hkTypeVm::UnaryInterpreter<InterpreterImpl>::execPointer(_Inout_ void* addr, const hkTypeVm::Program::DefaultInstruction& instr)
{
    HK_UNREACHABLE(0x2e65d307, "Not implemented" );
}

template<typename InterpreterImpl>
void hkTypeVm::UnaryInterpreter<InterpreterImpl>::execArray(_Inout_ void* addr, const hkTypeVm::Program::ArrayInstruction& instr)
{
    HK_UNREACHABLE(0x7f46c8c5, "Not implemented" );
}

template<typename InterpreterImpl>
void hkTypeVm::UnaryInterpreter<InterpreterImpl>::execRecord(_Inout_ void* addr, const hkTypeVm::Program::RecordInstruction& instr)
{
    HK_UNREACHABLE(0x177d7335, "Not implemented" );
}

template<typename InterpreterImpl>
void hkTypeVm::UnaryInterpreter<InterpreterImpl>::execBlock(_Inout_ void* addr, const hkTypeVm::Program::BlockInstruction& instr)
{
    HK_UNREACHABLE(0x3519c0a7, "Not implemented" );
}

template<typename InterpreterImpl>
void hkTypeVm::UnaryInterpreter<InterpreterImpl>::execConvertInt(_Inout_ void* addr, const hkTypeVm::Program::DefaultInstruction& instr)
{
    HK_UNREACHABLE(0x648e97c0, "Not implemented" );
}

template<typename InterpreterImpl>
void hkTypeVm::UnaryInterpreter<InterpreterImpl>::execConvertFloat(_Inout_ void* addr, const hkTypeVm::Program::DefaultInstruction& instr)
{
    HK_UNREACHABLE(0x4d7e36e2, "Not implemented" );
}

template<typename InterpreterImpl>
void hkTypeVm::UnaryInterpreter<InterpreterImpl>::execConvertBool(_Inout_ void* addr, const hkTypeVm::Program::DefaultInstruction& instr)
{
    HK_UNREACHABLE(0x2c828d1, "Not implemented" );
}


template<typename InterpreterImpl>
hkTypeVm::BinaryInterpreter<InterpreterImpl>::BinaryInterpreter()
{

}


template<typename InterpreterImpl>
InterpreterImpl& hkTypeVm::BinaryInterpreter<InterpreterImpl>::run(const hkReflect::Var& src, const hkReflect::Var& dst, hkTypeVm::Compiler& compiler)
{
    hkViewPtr<Program> prog = compiler.compile(src.getType(), dst.getType());
    return run(src, dst, *prog);
}

template<typename InterpreterImpl>
InterpreterImpl& hkTypeVm::BinaryInterpreter<InterpreterImpl>::run(const hkReflect::Var& src, const hkReflect::Var& dst, const hkTypeVm::Program& prog)
{
    using namespace hkTypeVm;

    InterpreterImpl& self = getExact();

    void* srcAddr = HK_NULL;
    void* dstAddr = HK_NULL;
    for(Program::ConstIterator it = prog.begin(); it != prog.end(); ++it)
    {
        const Program::InstructionBase& baseInstr = *it;

        srcAddr = hkAddByteOffset(src.getAddress(), baseInstr.getSrcOffset());
        dstAddr = hkAddByteOffset(dst.getAddress(), baseInstr.getDstOffset());

        switch(it->getInstructionType())
        {
            case Program::INST_NONE:
            {
                HK_ASSERT_NO_MSG(0x42d58841, false);
            }
            break;

            case Program::INST_ARRAY:
            {
                const Program::ArrayInstruction& instr = static_cast<const Program::ArrayInstruction&>(baseInstr);
                self.execArray(srcAddr, dstAddr, instr);
            }
            break;

            case Program::INST_BOOL:
            {
                const Program::DefaultInstruction& instr = static_cast<const Program::DefaultInstruction&>(baseInstr);
                self.execBool(srcAddr, dstAddr, instr);
            }
            break;

            //case Program::INST_CONTAINER:
            //{
            //  const Program::DefaultInstruction& instr = static_cast<const Program::DefaultInstruction&>(baseInstr);
            //  self.execContainer(srcAddr, dstAddr, instr);
            //}
            //break;

            case Program::INST_INT:
            {
                const Program::DefaultInstruction& instr = static_cast<const Program::DefaultInstruction&>(baseInstr);
                self.execInt(srcAddr, dstAddr, instr);
            }
            break;

            case Program::INST_FLOAT:
            {
                const Program::DefaultInstruction& instr = static_cast<const Program::DefaultInstruction&>(baseInstr);
                self.execFloat(srcAddr, dstAddr, instr);
            }
            break;

            case Program::INST_POINTER:
            {
                const Program::DefaultInstruction& instr = static_cast<const Program::DefaultInstruction&>(baseInstr);
                self.execPointer(srcAddr, dstAddr, instr);
            }
            break;

            case Program::INST_RECORD:
            {
                const Program::RecordInstruction& instr = static_cast<const Program::RecordInstruction&>(baseInstr);
                self.execRecord(srcAddr, dstAddr, instr);
            }
            break;

            case Program::INST_STRING:
            {
                const Program::DefaultInstruction& instr = static_cast<const Program::DefaultInstruction&>(baseInstr);
                self.execString(srcAddr, dstAddr, instr);
            }
            break;

            case Program::INST_BLOCK:
            {
                const Program::BlockInstruction& instr = static_cast<const Program::BlockInstruction&>(baseInstr);
                self.execBlock(srcAddr, dstAddr, instr);
            }
            break;

            case Program::INST_CONVERT_INTEGER:
            {
                const Program::DefaultInstruction& instr = static_cast<const Program::DefaultInstruction&>(baseInstr);
                self.execConvertInt(srcAddr, dstAddr, instr);
                break;
            }

            case Program::INST_CONVERT_FLOAT:
            {
                const Program::DefaultInstruction& instr = static_cast<const Program::DefaultInstruction&>(baseInstr);
                self.execConvertFloat(srcAddr, dstAddr, instr);
                break;
            }

            case Program::INST_CONVERT_BOOL:
            {
                const Program::DefaultInstruction& instr = static_cast<const Program::DefaultInstruction&>(baseInstr);
                self.execConvertBool(srcAddr, dstAddr, instr);
                break;
            }

            //case Program::INST_WRITE_CONSTANT:
            //{
            //  const Program::WriteConstantInstruction& instr = static_cast<const Program::WriteConstantInstruction&>(baseInstr);
            //  self.execWriteConstant(srcAddr, dstAddr, instr);
            //}
            case Program::NUM_INSTRUCTIONS:
            {
                HK_ASSERT_NO_MSG(0x4e7ef083, false); // Unknown instruction
                break;
            }
        }
    }

    return self;
}

template<typename InterpreterImpl>
void hkTypeVm::BinaryInterpreter<InterpreterImpl>::execBool(_Inout_ void* src, _Inout_ void* dst, const hkTypeVm::Program::DefaultInstruction& instr)
{
    HK_UNREACHABLE(0x364ca1b3, "Not implemented" );
}

template<typename InterpreterImpl>
void hkTypeVm::BinaryInterpreter<InterpreterImpl>::execInt(_Inout_ void* src, _Inout_ void* dst, const hkTypeVm::Program::DefaultInstruction& instr)
{
    HK_UNREACHABLE(0x6cb84653, "Not implemented" );
}

template<typename InterpreterImpl>
void hkTypeVm::BinaryInterpreter<InterpreterImpl>::execFloat(_Inout_ void* src, _Inout_ void* dst, const hkTypeVm::Program::DefaultInstruction& instr)
{
    HK_UNREACHABLE(0x4986fe0a, "Not implemented" );
}

template<typename InterpreterImpl>
void hkTypeVm::BinaryInterpreter<InterpreterImpl>::execString(_Inout_ void* src, _Inout_ void* dst, const hkTypeVm::Program::DefaultInstruction& instr)
{
    HK_UNREACHABLE(0x61b60076, "Not implemented" );
}

template<typename InterpreterImpl>
void hkTypeVm::BinaryInterpreter<InterpreterImpl>::execPointer(_Inout_ void* src, _Inout_ void* dst, const hkTypeVm::Program::DefaultInstruction& instr)
{
    HK_UNREACHABLE(0x6cfd09ba, "Not implemented" );
}

template<typename InterpreterImpl>
void hkTypeVm::BinaryInterpreter<InterpreterImpl>::execArray(_Inout_ void* src, _Inout_ void* dst, const hkTypeVm::Program::ArrayInstruction& instr)
{
    HK_UNREACHABLE(0x8a45877, "Not implemented" );
}

template<typename InterpreterImpl>
void hkTypeVm::BinaryInterpreter<InterpreterImpl>::execRecord(_Inout_ void* src, _Inout_ void* dst, const hkTypeVm::Program::RecordInstruction& instr)
{
    HK_UNREACHABLE(0x3e6f872, "Not implemented" );
}

template<typename InterpreterImpl>
void hkTypeVm::BinaryInterpreter<InterpreterImpl>::execBlock(_Inout_ void* src, _Inout_ void* dst, const hkTypeVm::Program::BlockInstruction& instr)
{
    HK_UNREACHABLE(0x4b2e367c, "Not implemented" );
}

template<typename InterpreterImpl>
void hkTypeVm::BinaryInterpreter<InterpreterImpl>::execConvertInt(_Inout_ void* src, _Inout_ void* dst, const hkTypeVm::Program::DefaultInstruction& instr)
{
    HK_UNREACHABLE(0x69571e46, "Not implemented" );
}

template<typename InterpreterImpl>
void hkTypeVm::BinaryInterpreter<InterpreterImpl>::execConvertFloat(_Inout_ void* src, _Inout_ void* dst, const hkTypeVm::Program::DefaultInstruction& instr)
{
    HK_UNREACHABLE(0x899ce8b, "Not implemented" );
}

template<typename InterpreterImpl>
void hkTypeVm::BinaryInterpreter<InterpreterImpl>::execConvertBool(_Inout_ void* src, _Inout_ void* dst, const hkTypeVm::Program::DefaultInstruction& instr)
{
    HK_UNREACHABLE(0x7785eac1, "Not implemented" );
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
