// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Reflect/TypeVm/hkTypeVmCompiler.h>

namespace hkTypeVm
{
    template<typename InterpreterImpl>
    class UnaryInterpreter
    {
        public:

            HK_DECLARE_CLASS(UnaryInterpreter, New);

            UnaryInterpreter();

            /// Runs the Interpreter on the given object using the default compiler.
            InterpreterImpl& run(const hkReflect::Var& obj);

            /// Runs the Interpreter on the given object using the given program.
            InterpreterImpl& run(const hkReflect::Var& obj, const hkTypeVm::Program& prog);

            hkTypeVm::Compiler& getCompiler() { return m_compiler; }

        private:

            InterpreterImpl& getExact() { return static_cast<InterpreterImpl&>(*this); }

            // Instruction type handlers. Default implementation calls HK_UNREACHABLE().
            void execBool(_Inout_ void* addr, const hkTypeVm::Program::DefaultInstruction& instr);
            void execInt(_Inout_ void* addr, const hkTypeVm::Program::DefaultInstruction& instr);
            void execFloat(_Inout_ void* addr, const hkTypeVm::Program::DefaultInstruction& instr);
            void execPointer(_Inout_ void* addr, const hkTypeVm::Program::DefaultInstruction& instr);
            void execString(_Inout_ void* addr, const hkTypeVm::Program::DefaultInstruction& instr);
            //void execContainer(_Inout_ void* addr, const hkTypeVm::Program::DefaultInstruction& instr);
            void execArray(_Inout_ void* addr, const hkTypeVm::Program::ArrayInstruction& instr);
            void execRecord(_Inout_ void* addr, const hkTypeVm::Program::RecordInstruction& instr);
            void execBlock(_Inout_ void* addr, const hkTypeVm::Program::BlockInstruction& instr);
            void execConvertInt(_Inout_ void* addr, const hkTypeVm::Program::DefaultInstruction& instr);
            void execConvertFloat(_Inout_ void* addr, const hkTypeVm::Program::DefaultInstruction& instr);
            void execConvertBool(_Inout_ void* addr, const hkTypeVm::Program::DefaultInstruction& instr);


            /// Override if you expect programs with INST_WRITE_CONSTANT instructions. Default implementation asserts.
            //void execWriteConstant(void* addr, const hkTypeCompiler::Program::WriteConstantInstruction& instr);

            hkTypeVm::Compiler m_compiler;
    };

    template<typename InterpreterImplParam>
    class BinaryInterpreter
    {
        public:

            typedef InterpreterImplParam InterpreterImpl;

            HK_DECLARE_CLASS(BinaryInterpreter, New);

            BinaryInterpreter();

            /// Runs the Interpreter on the given object using the given compiler.
            InterpreterImpl& run( const hkReflect::Var& src, const hkReflect::Var& dst, hkTypeVm::Compiler& compiler );

            /// Runs the Interpreter on the given object using the given program.
            InterpreterImpl& run(const hkReflect::Var& src, const hkReflect::Var& dst, const hkTypeVm::Program& prog);

        protected:

            InterpreterImpl& getExact() { return static_cast<InterpreterImpl&>( *this ); }
        private:

            // Instruction type handlers. Default implementation calls HK_UNREACHABLE().
            void execBool(_Inout_ void* src, _Inout_ void* dst, const hkTypeVm::Program::DefaultInstruction& instr);
            void execInt(_Inout_ void* src, _Inout_ void* dst, const hkTypeVm::Program::DefaultInstruction& instr);
            void execFloat(_Inout_ void* src, _Inout_ void* dst, const hkTypeVm::Program::DefaultInstruction& instr);
            void execPointer(_Inout_ void* src, _Inout_ void* dst, const hkTypeVm::Program::DefaultInstruction& instr);
            void execString(_Inout_ void* src, _Inout_ void* dst, const hkTypeVm::Program::DefaultInstruction& instr);
            //void execContainer(_Inout_ void* src, _Inout_ void* dst, const hkTypeVm::Program::DefaultInstruction& instr);
            void execArray(_Inout_ void* src, _Inout_ void* dst, const hkTypeVm::Program::ArrayInstruction& instr);
            void execRecord(_Inout_ void* src, _Inout_ void* dst, const hkTypeVm::Program::RecordInstruction& instr);
            void execBlock(_Inout_ void* src, _Inout_ void* dst, const hkTypeVm::Program::BlockInstruction& instr);
            void execConvertInt(_Inout_ void* addr, _Inout_ void* dst, const hkTypeVm::Program::DefaultInstruction& instr);
            void execConvertFloat(_Inout_ void* addr, _Inout_ void* dst, const hkTypeVm::Program::DefaultInstruction& instr);
            void execConvertBool(_Inout_ void* addr, _Inout_ void* dst, const hkTypeVm::Program::DefaultInstruction& instr);

            /// Override if you expect programs with INST_WRITE_CONSTANT instructions. Default implementation asserts.
            //void execWriteConstantvoid* src, void* dst, const hkTypeCompiler::Program::WriteConstantInstruction& instr);
    };
}

#include <Common/Base/Reflect/TypeVm/hkTypeVmInterpreter.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
