// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL !REFLECT
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Reflect/TypeVm/hkTypeVmCompiler.h>
#include <Common/Base/Reflect/Core/Detail/hkReflectTypeDetail.h>

namespace hkTypeVm
{
    // Implementation of a copy interpreter optimized for speed rather than ease of use.
    // You can customize it by subclassing and overriding the exec*() methods.
    class HK_EXPORT_COMMON FastCopyInterpreter
    {
        public:

            enum
            {
                // Arrays of more than MAX_ARRAY_CHUNK_SIZE elements are split into blocks of this size
                MAX_ARRAY_CHUNK_SIZE = 1024
            };

            // Sized blocks to make sure we don't write off the ends of the buffer. Should optimise to nothing in release
            struct SourceBlock
            {
                SourceBlock(_In_opt_ const void* addr = HK_NULL, int size = 0) : m_addr(addr), m_size(size) {}
                _Ret_maybenull_ const void* get(int size, int _offset = 0) const { HK_ASSERT_NO_MSG(0x10716984, (m_addr == 0) || ((_offset + size) <= m_size)); return hkAddByteOffsetConst(m_addr, m_addr ? _offset : 0); }
                SourceBlock offset(int _offset) const { HK_ASSERT_NO_MSG(0x585b56b7, (m_addr == 0) || (_offset < m_size)); return SourceBlock(hkAddByteOffsetConst(m_addr, m_addr ? _offset : 0), m_size - (m_addr ? _offset : 0)); }

                private:
                    const void* m_addr;
                    int m_size;
            };

            struct DestBlock
            {
                DestBlock(_In_opt_ void* addr = HK_NULL, int size = 0) : m_addr(addr), m_size(size) {}
                _Ret_maybenull_ void* get(int size, int _offset = 0) { HK_ASSERT_NO_MSG(0x5dcef9a9, (m_addr == 0) || ((_offset + size) <= m_size)); return hkAddByteOffset(m_addr, m_addr ? _offset : 0); }
                DestBlock offset(int _offset) const { HK_ASSERT_NO_MSG(0x5ecb369a, (m_addr == 0) || (_offset < m_size)); return DestBlock(hkAddByteOffset(m_addr, m_addr ? _offset : 0), m_size - (m_addr ? _offset : 0)); }

                private:
                    void* m_addr;
                    int m_size;
            };

            void execCopy(_Out_writes_bytes_(dstStride * repeat) void* HK_RESTRICT vdst, _In_reads_bytes_(srcStride * repeat) const void* HK_RESTRICT vsrc, _In_range_(>= , 0) int numBytes, _In_range_(>= , 1) int dstStride, _In_range_(>= , 1) int srcStride, _In_range_(>= , 0) int repeat);
            void execCopyBlock(_Out_writes_bytes_all_(numBytes * repeat) void* dst, _In_reads_bytes_(numBytes * repeat) const void* src, _In_range_(>= , 0) int numBytes, _In_range_(>= , 0) int repeat); // numBytes is expected to be large here

            hkResult execPointer(hkReflect::PointerVar dst, hkReflect::PointerVar src, int dstStride, int srcStride, int numElems);
            void execConvertInteger(_Out_writes_bytes_(dstStride * numElems) void* dst, _In_reads_bytes_(srcStride * numElems) const void* src, hkReflect::Format::Value dFormat, hkReflect::Format::Value sFormat, int dstStride, int srcStride, _In_range_(>= , 0) int numElems);
            void execConvertFloat(_Out_writes_bytes_(dstStride * numElems) void* dst, _In_reads_bytes_(srcStride * numElems) const void* src, hkReflect::Format::Value dFormat, hkReflect::Format::Value sFormat, int dstStride, int srcStride, _In_range_(0, MAX_ARRAY_CHUNK_SIZE / srcStride) int numElems);
            void execConvertBool(_Out_writes_bytes_(dstStride * numElems) void* dst, _In_reads_bytes_(srcStride * numElems) const void* src, const hkReflect::Type* dstType, const hkReflect::Type* srcType, int dstStride, int srcStride, _In_range_(>= , 0) int numElems);

            // Can't stride this as each one needs to return separately
            hkResult execBool(const hkReflect::BoolVar& dst, const hkReflect::BoolVar& src);
            hkResult execInt(const hkReflect::IntVar& dst, const hkReflect::IntVar& src);
            hkResult execFloat(const hkReflect::FloatVar& dst, const hkReflect::FloatVar& src);

            bool shouldHandleString(hkReflect::StringVar dst, hkReflect::StringVar src);
            hkResult execString(hkReflect::StringVar dst, hkReflect::StringVar src);
            // This function gives a hint as to how many times execArray will be called. Implementations can use this to pre-allocate internal data structures.
            void beginArrayOfArrays( int numElements );
            hkResult execArray(hkReflect::ArrayVar dst, hkReflect::ArrayVar src);

            template<typename T> T incrementAddress(const T& orig, int inc) { return T(hkAddByteOffset(orig.getAddress(), inc), orig.getType(), orig.getImpl()); }


            template<typename Interp>
            static hkResult execN(Interp& interp, _In_ const Program* program, _Out_writes_bytes_(dstSize) void* dst, int dstSize, _In_reads_bytes_(srcSize) const void* src, int srcSize, int dstStride, int srcStride, int numElems);

            template<typename Interp>
            static hkResult exec1(Interp& interp, _In_ const Program* program, _Out_writes_bytes_(dstSize) void* dst, int dstSize, _In_reads_bytes_(srcSize) const void* src, int srcSize)
            {
                return execN(interp, program, dst, dstSize, src, srcSize, 0, 0, 1);
            }
    };
}

#include <Common/Base/Reflect/TypeVm/hkTypeVmFastCopyInterpreter.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
