// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/Fwd/hkcstring.h>

#if 0 //set to 1 to debug
#undef HK_ALWAYS_INLINE
#define HK_ALWAYS_INLINE inline // "inline" doesn't inline in debug whereas HK_ALWAYS_INLINE does.
#endif

template<typename Self>
HK_ALWAYS_INLINE void hkTypeVm::CopyInterpreterTemplate<Self>::execBool(_Inout_ void* src, _Inout_ void* dst, const Program::DefaultInstruction& instr)
{
    hkReflect::BoolVar srcVar(src, instr.getSrcTypeAs<hkReflect::BoolType>());
    hkReflect::BoolVar dstVar(dst, instr.getDstTypeAs<hkReflect::BoolType>());
    dstVar.setValue(srcVar.getValue());
}

template<typename Self>
HK_ALWAYS_INLINE void hkTypeVm::CopyInterpreterTemplate<Self>::execInt(_Inout_ void* src, _Inout_ void* dst, const Program::DefaultInstruction& instr)
{
    hkReflect::IntVar srcVar(src, instr.getSrcTypeAs<hkReflect::IntType>());
    hkReflect::IntVar dstVar(dst, instr.getDstTypeAs<hkReflect::IntType>());
    dstVar.setValue(srcVar.getValue());
}

template<typename Self>
HK_ALWAYS_INLINE void hkTypeVm::CopyInterpreterTemplate<Self>::execFloat(_Inout_ void* src, _Inout_ void* dst, const Program::DefaultInstruction& instr)
{
    hkReflect::FloatVar srcVar(src, instr.getSrcTypeAs<hkReflect::FloatType>());
    hkReflect::FloatVar dstVar(dst, instr.getDstTypeAs<hkReflect::FloatType>());
    dstVar.setValue(srcVar.getValue());
}

template<typename Self>
HK_ALWAYS_INLINE void hkTypeVm::CopyInterpreterTemplate<Self>::execPointer(_Inout_ void* src, _Inout_ void* dst, const Program::DefaultInstruction& instr)
{
    hkReflect::PointerVar srcVar(src, instr.getSrcTypeAs<hkReflect::PointerType>());
    hkReflect::PointerVar dstVar(dst, instr.getDstTypeAs<hkReflect::PointerType>());
    dstVar.copyFrom(srcVar);
}

template<typename Self>
HK_ALWAYS_INLINE void hkTypeVm::CopyInterpreterTemplate<Self>::execString(_Inout_ void* src, _Inout_ void* dst, const Program::DefaultInstruction& instr)
{
    hkReflect::StringVar srcVar(src, instr.getSrcTypeAs<hkReflect::StringType>());
    hkReflect::StringVar dstVar(dst, instr.getDstTypeAs<hkReflect::StringType>());
    dstVar.setValue(srcVar.getValue());
}

//template<typename Self>
//HK_ALWAYS_INLINE void hkTypeVm::CopyInterpreterTemplate<Self>::execContainer(_Inout_ void* src, _Inout_ void* dst, const Program::DefaultInstruction& instr)
//{
//  HK_ASSERT_NO_MSG(0x186e8e91, false);
//}

template<typename Self>
HK_ALWAYS_INLINE void hkTypeVm::CopyInterpreterTemplate<Self>::execArray(_Inout_ void* src, _Inout_ void* dst, const Program::ArrayInstruction& instr)
{
    hkReflect::ArrayVar srcVar(src, instr.getSrcTypeAs<hkReflect::ArrayType>());
    hkReflect::ArrayVar dstVar(dst, instr.getDstTypeAs<hkReflect::ArrayType>());
    dstVar.setValue(srcVar.getValue());
}

template<typename Self>
HK_ALWAYS_INLINE void hkTypeVm::CopyInterpreterTemplate<Self>::execRecord(_Inout_ void* src, _Inout_ void* dst, const Program::RecordInstruction& instr)
{
    HK_ASSERT_NO_MSG(0x58c64232, instr.getProgram());
    // Let the child interpreter obtain some data from this, if required.
    typename hkTypeVm::CopyInterpreterTemplate<Self>::InterpreterImpl( this->getExact() ).run(hkReflect::Var(src, instr.getSrcType()), hkReflect::Var(dst, instr.getDstType()), *instr.getProgram());
}

template<typename Self>
HK_ALWAYS_INLINE void hkTypeVm::CopyInterpreterTemplate<Self>::execBlock(_Inout_ void* src, _Inout_ void* dst, const hkTypeVm::Program::BlockInstruction& instr)
{
    memcpy(dst, src, instr.getNumBytes());
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
