// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Reflect/TypeVm/hkTypeVmInterpreter.h>

namespace hkTypeVm
{
    /// Interpreter which copies data from src to dst.
    template<typename Self>
    class CopyInterpreterTemplate
        : public BinaryInterpreter< Self >
    {
    public:

        HK_DECLARE_CLASS(CopyInterpreterTemplate, New);
        CopyInterpreterTemplate() {}
        /// Derived CopyInterpreters should provide a constructor of this form to allow data from the parent to be passed to child interpreters.
        CopyInterpreterTemplate(const CopyInterpreterTemplate* parent) {}

        void execBool(_Inout_ void* src, _Inout_ void* dst, const Program::DefaultInstruction& instr);
        void execInt(_Inout_ void* src, _Inout_ void* dst, const Program::DefaultInstruction& instr);
        void execFloat(_Inout_ void* src, _Inout_ void* dst, const Program::DefaultInstruction& instr);
        void execPointer(_Inout_ void* src, _Inout_ void* dst, const Program::DefaultInstruction& instr);
        void execString(_Inout_ void* src, _Inout_ void* dst, const Program::DefaultInstruction& instr);
        //void execContainer(_Inout_ void* src, _Inout_ void* dst, const Program::DefaultInstruction& instr);
        void execArray(_Inout_ void* src, _Inout_ void* dst, const Program::ArrayInstruction& instr);
        void execRecord(_Inout_ void* src, _Inout_ void* dst, const Program::RecordInstruction& instr);
        void execBlock(_Inout_ void* src, _Inout_ void* dst, const hkTypeVm::Program::BlockInstruction& instr);
    };

    class HK_EXPORT_COMMON CopyInterpreter : public CopyInterpreterTemplate<CopyInterpreter>
    {
    public:
        HK_DECLARE_CLASS(CopyInterpreter, New);
        CopyInterpreter() {}
        CopyInterpreter(const CopyInterpreter* parent) : CopyInterpreterTemplate(parent) {}
    };
}

#include <Common/Base/Reflect/TypeVm/hkTypeVmCopyInterpreter.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
